/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters;

import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.ReferenceableConverter;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ComplexSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.PrimitiveSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Referenceable;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SchemaTypeConverter
extends ReferenceableConverter {
    int schemaAttributeCount;

    public SchemaTypeConverter(EntityDetail mainEntity, int schemaAttributeCount, OMRSRepositoryHelper repositoryHelper, String serviceName) {
        super(mainEntity, repositoryHelper, serviceName);
        this.schemaAttributeCount = schemaAttributeCount;
    }

    public SchemaType getBean() {
        InstanceType entityType;
        if (this.entity != null && (entityType = this.entity.getType()) != null) {
            String entityTypeName = entityType.getTypeDefName();
            if (this.repositoryHelper.isTypeOf(this.serviceName, entityTypeName, "PrimitiveSchemaType")) {
                return this.getPrimitiveSchemaTypeBean();
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, entityTypeName, "ComplexSchemaType")) {
                return this.getComplexSchemaTypeBean();
            }
            return this.getBasicSchemaTypeBean();
        }
        return null;
    }

    private void updateBasicSchemaTypeProperties(SchemaType bean, InstanceProperties instanceProperties, String methodName) {
        if (instanceProperties != null) {
            bean.setDisplayName(this.repositoryHelper.removeStringProperty(this.serviceName, "displayName", instanceProperties, methodName));
            bean.setVersionNumber(this.repositoryHelper.removeStringProperty(this.serviceName, "versionNumber", instanceProperties, methodName));
            bean.setAuthor(this.repositoryHelper.removeStringProperty(this.serviceName, "author", instanceProperties, methodName));
            bean.setUsage(this.repositoryHelper.removeStringProperty(this.serviceName, "usage", instanceProperties, methodName));
            bean.setEncodingStandard(this.repositoryHelper.removeStringProperty(this.serviceName, "encodingStandard", instanceProperties, methodName));
            bean.setAdditionalProperties(this.repositoryHelper.removeStringMapFromProperty(this.serviceName, "additionalProperties", instanceProperties, methodName));
        }
    }

    SchemaType getPrimitiveSchemaTypeBean() {
        String methodName = "getPrimitiveSchemaTypeBean";
        PrimitiveSchemaType bean = new PrimitiveSchemaType();
        super.updateBean((Referenceable)bean);
        InstanceProperties instanceProperties = this.entity.getProperties();
        if (instanceProperties != null) {
            this.updateBasicSchemaTypeProperties((SchemaType)bean, instanceProperties, "getPrimitiveSchemaTypeBean");
            bean.setDataType(this.repositoryHelper.removeStringProperty(this.serviceName, "dataType", instanceProperties, "getPrimitiveSchemaTypeBean"));
            bean.setDefaultValue(this.repositoryHelper.removeStringProperty(this.serviceName, "defaultValue", instanceProperties, "getPrimitiveSchemaTypeBean"));
            bean.setExtendedProperties(this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties));
        }
        return bean;
    }

    SchemaType getComplexSchemaTypeBean() {
        String methodName = "getComplexSchemaTypeBean";
        ComplexSchemaType bean = new ComplexSchemaType();
        super.updateBean((Referenceable)bean);
        InstanceProperties instanceProperties = this.entity.getProperties();
        if (instanceProperties != null) {
            this.updateBasicSchemaTypeProperties((SchemaType)bean, instanceProperties, "getComplexSchemaTypeBean");
            bean.setAttributeCount(this.schemaAttributeCount);
            bean.setExtendedProperties(this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties));
        }
        return bean;
    }

    SchemaType getBasicSchemaTypeBean() {
        String methodName = "getBasicSchemaTypeBean";
        SchemaType bean = new SchemaType();
        super.updateBean((Referenceable)bean);
        InstanceProperties instanceProperties = this.entity.getProperties();
        if (instanceProperties != null) {
            this.updateBasicSchemaTypeProperties(bean, instanceProperties, "getBasicSchemaTypeBean");
            bean.setExtendedProperties(this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties));
        }
        return bean;
    }
}

