/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.ffdc.OMAGOCFErrorCode;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryErrorHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class RootBuilder {
    protected RepositoryErrorHandler errorHandler;
    protected OMRSRepositoryHelper repositoryHelper;
    protected String serviceName;
    protected String serverName;
    protected List<Classification> classifications = null;

    protected RootBuilder(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        this.repositoryHelper = repositoryHelper;
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.errorHandler = new RepositoryErrorHandler(repositoryHelper, serviceName, serverName);
    }

    public void setClassifications(List<Classification> classifications) {
        this.classifications = classifications;
    }

    public List<org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification> getEntityClassifications(String methodName) throws InvalidParameterException {
        if (this.classifications == null) {
            return null;
        }
        if (this.classifications.isEmpty()) {
            return null;
        }
        ArrayList<org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification> entityClassifications = new ArrayList<org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification>();
        for (Classification classification : this.classifications) {
            if (classification == null) continue;
            org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification entityClassification = new org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification();
            if (classification.getClassificationName() == null) {
                OMAGOCFErrorCode errorCode = OMAGOCFErrorCode.NULL_CLASSIFICATION_NAME;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{this.serviceName, methodName});
                throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "Classification name");
            }
            entityClassification.setName(classification.getClassificationName());
            try {
                entityClassification.setProperties(this.repositoryHelper.addPropertyMapToInstance(this.serviceName, null, classification.getClassificationProperties(), methodName));
            }
            catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException error) {
                OMAGOCFErrorCode errorCode = OMAGOCFErrorCode.BAD_CLASSIFICATION_PROPERTIES;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{this.serviceName, classification.getClassificationName(), error.getMessage()});
                throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), (Throwable)error, "Properties for classification " + classification.getClassificationName());
            }
        }
        return entityClassifications;
    }

    protected InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        return null;
    }
}

