/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders;

import java.util.Map;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SchemaAttributeBuilder
extends ReferenceableBuilder {
    private String attributeName;
    private int elementPosition;
    private String cardinality;
    private String defaultValueOverride;

    public SchemaAttributeBuilder(String qualifiedName, String attributeName, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, repositoryHelper, serviceName, serverName);
        this.attributeName = attributeName;
    }

    public SchemaAttributeBuilder(String qualifiedName, String attributeName, int elementPosition, String cardinality, String defaultValueOverride, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, extendedProperties, repositoryHelper, serviceName, serverName);
        this.attributeName = attributeName;
        this.elementPosition = elementPosition;
        this.cardinality = cardinality;
        this.defaultValueOverride = defaultValueOverride;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.attributeName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "displayName", this.attributeName, methodName);
        }
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, "position", this.elementPosition, methodName);
        if (this.cardinality != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "cardinality", this.cardinality, methodName);
        }
        if (this.defaultValueOverride != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "defaultValueOverride", this.defaultValueOverride, methodName);
        }
        return properties;
    }

    @Override
    public InstanceProperties getNameInstanceProperties(String methodName) {
        InstanceProperties properties = super.getNameInstanceProperties(methodName);
        if (this.attributeName != null) {
            String literalName = this.repositoryHelper.getExactMatchRegex(this.attributeName);
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "displayName", literalName, methodName);
        }
        return properties;
    }

    @Override
    public InstanceProperties getQualifiedNameInstanceProperties(String methodName) {
        return super.getNameInstanceProperties(methodName);
    }
}

