/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters;

import java.util.Map;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.ElementHeaderConverter;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Comment;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.CommentType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class CommentConverter
extends ElementHeaderConverter {
    public CommentConverter(EntityDetail entity, Relationship relationship, OMRSRepositoryHelper repositoryHelper, String serviceName) {
        super(entity, relationship, repositoryHelper, serviceName);
    }

    public Comment getBean() {
        String methodName = "getBean";
        Comment bean = null;
        if (this.entity != null) {
            InstanceProperties instanceProperties;
            bean = new Comment();
            super.updateBean((ElementHeader)bean);
            bean.setUser(this.entity.getCreatedBy());
            if (this.relationship != null && (instanceProperties = this.relationship.getProperties()) != null) {
                bean.setPublic(this.repositoryHelper.getBooleanProperty(this.serviceName, "isPublic", instanceProperties, "getBean"));
            }
            if ((instanceProperties = this.entity.getProperties()) != null) {
                bean.setCommentText(this.repositoryHelper.removeStringProperty(this.serviceName, "text", instanceProperties, "getBean"));
                bean.setCommentType(this.removeCommentTypeFromProperties(instanceProperties));
                bean.setExtendedProperties(this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties));
            }
        }
        return bean;
    }

    private CommentType removeCommentTypeFromProperties(InstanceProperties properties) {
        Map instancePropertiesMap;
        InstancePropertyValue instancePropertyValue;
        CommentType commentType = CommentType.STANDARD_COMMENT;
        if (properties != null && (instancePropertyValue = (InstancePropertyValue)(instancePropertiesMap = properties.getInstanceProperties()).get("type")) instanceof EnumPropertyValue) {
            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            switch (enumPropertyValue.getOrdinal()) {
                case 0: {
                    commentType = CommentType.STANDARD_COMMENT;
                    break;
                }
                case 1: {
                    commentType = CommentType.QUESTION;
                    break;
                }
                case 2: {
                    commentType = CommentType.ANSWER;
                    break;
                }
                case 3: {
                    commentType = CommentType.SUGGESTION;
                    break;
                }
                case 4: {
                    commentType = CommentType.USAGE_EXPERIENCE;
                    break;
                }
                default: {
                    commentType = CommentType.OTHER;
                }
            }
            instancePropertiesMap.remove("type");
            properties.setInstanceProperties(instancePropertiesMap);
        }
        return commentType;
    }
}

