/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.AssetBuilder;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.AssetConverter;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.CertificationHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.CommentHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.ConnectionHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.EndpointHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.ExternalIdentifierHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.ExternalReferenceHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.InformalTagHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.LicenseHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.LikeHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.LocationHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.NoteLogHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.RatingHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.RelatedMediaHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.SchemaTypeHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Asset;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Classification;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Comment;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.CommentType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementOrigin;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.OwnerType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.RelatedAsset;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttribute;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.StarRating;
import org.odpi.openmetadata.metadatasecurity.properties.AssetAuditHeader;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class AssetHandler {
    private String localServerUserId;
    private String serviceName;
    private OMRSRepositoryHelper repositoryHelper;
    private String serverName;
    private InvalidParameterHandler invalidParameterHandler;
    private RepositoryHandler repositoryHandler;
    private CertificationHandler certificationHandler;
    private CommentHandler commentHandler;
    private ConnectionHandler connectionHandler;
    private EndpointHandler endpointHandler;
    private ExternalIdentifierHandler externalIdentifierHandler;
    private ExternalReferenceHandler externalReferenceHandler;
    private InformalTagHandler informalTagHandler;
    private LicenseHandler licenseHandler;
    private LikeHandler likeHandler;
    private LocationHandler locationHandler;
    private NoteLogHandler noteLogHandler;
    private RatingHandler ratingHandler;
    private RelatedMediaHandler relatedMediaHandler;
    private SchemaTypeHandler schemaTypeHandler;
    private OpenMetadataServerSecurityVerifier securityVerifier = new OpenMetadataServerSecurityVerifier();
    protected List<String> supportedZones;
    protected List<String> defaultZones;

    public AssetHandler(String serviceName, String serverName, String localServerUserId, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, CertificationHandler certificationHandler, CommentHandler commentHandler, ConnectionHandler connectionHandler, EndpointHandler endpointHandler, ExternalIdentifierHandler externalIdentifierHandler, ExternalReferenceHandler externalReferenceHandler, InformalTagHandler informalTagHandler, LicenseHandler licenseHandler, LikeHandler likeHandler, LocationHandler locationHandler, NoteLogHandler noteLogHandler, RatingHandler ratingHandler, RelatedMediaHandler relatedMediaHandler, SchemaTypeHandler schemaTypeHandler, List<String> supportedZones, List<String> defaultZones) {
        this.serviceName = serviceName;
        this.repositoryHelper = repositoryHelper;
        this.serverName = serverName;
        this.localServerUserId = localServerUserId;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHandler = repositoryHandler;
        this.certificationHandler = certificationHandler;
        this.commentHandler = commentHandler;
        this.connectionHandler = connectionHandler;
        this.endpointHandler = endpointHandler;
        this.externalIdentifierHandler = externalIdentifierHandler;
        this.externalReferenceHandler = externalReferenceHandler;
        this.informalTagHandler = informalTagHandler;
        this.licenseHandler = licenseHandler;
        this.likeHandler = likeHandler;
        this.locationHandler = locationHandler;
        this.noteLogHandler = noteLogHandler;
        this.ratingHandler = ratingHandler;
        this.relatedMediaHandler = relatedMediaHandler;
        this.schemaTypeHandler = schemaTypeHandler;
        this.supportedZones = supportedZones;
        this.defaultZones = defaultZones;
    }

    public void setSecurityVerifier(OpenMetadataServerSecurityVerifier securityVerifier) {
        if (securityVerifier != null) {
            this.securityVerifier = securityVerifier;
        }
    }

    private List<String> getSupportedZones(String userId, String serviceName) throws InvalidParameterException, PropertyServerException {
        return this.securityVerifier.setSupportedZonesForUser(this.supportedZones, serviceName, userId);
    }

    public List<String> getTypesOfAssetList() {
        return this.repositoryHelper.getSubTypesOf(this.serviceName, "Asset");
    }

    public Map<String, String> getTypesOfAssetDescriptions() {
        List assetTypeList = this.repositoryHelper.getSubTypesOf(this.serviceName, "Asset");
        HashMap<String, String> assetDescriptions = new HashMap<String, String>();
        if (assetTypeList != null) {
            for (String assetTypeName : assetTypeList) {
                TypeDef assetTypeDef;
                if (assetTypeName == null || (assetTypeDef = this.repositoryHelper.getTypeDefByName(this.serviceName, assetTypeName)) == null) continue;
                assetDescriptions.put(assetTypeName, assetTypeDef.getDescription());
            }
        }
        if (assetDescriptions.isEmpty()) {
            return null;
        }
        return assetDescriptions;
    }

    public Asset createEmptyAsset(String requestedTypeName, String methodName) throws InvalidParameterException {
        Asset asset = new Asset();
        ElementType elementType = new ElementType();
        String assetTypeName = "Asset";
        if (requestedTypeName != null) {
            assetTypeName = requestedTypeName;
        }
        String assetTypeGUID = this.invalidParameterHandler.validateTypeName(assetTypeName, "Asset", this.serviceName, methodName, this.repositoryHelper);
        elementType.setElementOrigin(ElementOrigin.LOCAL_COHORT);
        elementType.setElementTypeId(assetTypeGUID);
        elementType.setElementTypeName(assetTypeName);
        asset.setType(elementType);
        return asset;
    }

    public Asset createEmptyExternalAsset(String assetTypeName, ElementOrigin elementOrigin, String externalSourceGUID, String externalSourceName, String methodName) throws InvalidParameterException {
        Asset asset = this.createEmptyAsset(assetTypeName, methodName);
        if (asset != null) {
            ElementType elementType = asset.getType();
            elementType.setElementOrigin(elementOrigin);
            elementType.setElementHomeMetadataCollectionId(externalSourceGUID);
            elementType.setElementHomeMetadataCollectionName(externalSourceName);
        }
        return asset;
    }

    private AssetConverter retrieveAssetConverterFromRepositoryByGUID(String userId, String assetGUID, String guidParameterName, Relationship connectionRelationship, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail assetEntity = this.repositoryHandler.getEntityByGUID(userId, assetGUID, guidParameterName, "Asset", methodName);
        AssetConverter assetConverter = new AssetConverter(assetEntity, connectionRelationship, this.repositoryHelper, methodName);
        return assetConverter;
    }

    private Asset retrieveAssetFromRepositoryByGUID(String userId, String assetGUID, String guidParameterName, Relationship connectionRelationship, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        AssetConverter assetConverter = this.retrieveAssetConverterFromRepositoryByGUID(userId, assetGUID, guidParameterName, connectionRelationship, methodName);
        if (assetConverter != null) {
            return assetConverter.getAssetBean();
        }
        return null;
    }

    private AssetConverter retrieveAssetConverterFromRepositoryByName(String userId, String qualifiedName, String qualifiedNameParameter, Relationship connectionRelationship, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameter, methodName);
        AssetBuilder assetBuilder = new AssetBuilder(qualifiedName, null, this.repositoryHelper, this.serviceName, this.serverName);
        EntityDetail assetEntity = this.repositoryHandler.getUniqueEntityByName(userId, qualifiedName, qualifiedNameParameter, assetBuilder.getQualifiedNameInstanceProperties(methodName), "896d14c2-7522-4f6c-8519-757711943fe6", "Asset", methodName);
        AssetConverter assetConverter = new AssetConverter(assetEntity, connectionRelationship, this.repositoryHelper, methodName);
        return assetConverter;
    }

    public void saveAssociatedConnection(String userId, String assetGUID, String assetSummary, Connection connection, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "assetGUID";
        this.saveAssociatedConnection(userId, this.retrieveAssetFromRepositoryByGUID(userId, assetGUID, "assetGUID", null, methodName), assetSummary, connection, methodName);
    }

    private void saveAssociatedConnection(String userId, Asset asset, String assetSummary, Connection connection, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String assetGUIDParameter = "assetGUID";
        if (asset != null) {
            Relationship relationship;
            String connectionGUID;
            this.invalidParameterHandler.validateAssetInSupportedZone(asset.getGUID(), "assetGUID", asset.getZoneMembership(), this.getSupportedZones(userId, this.serviceName), this.serviceName, methodName);
            this.securityVerifier.validateUserForAssetAttachmentUpdate(userId, asset);
            if (connection != null && (connectionGUID = this.connectionHandler.saveConnection(userId, connection)) != null && (relationship = this.repositoryHandler.getRelationshipBetweenEntities(userId, connectionGUID, "Connection", asset.getGUID(), "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", methodName)) == null) {
                InstanceProperties properties = null;
                if (assetSummary != null) {
                    properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "assetSummary", assetSummary, methodName);
                }
                this.repositoryHandler.createRelationship(userId, "e777d660-8dbe-453e-8b83-903771f054c0", connectionGUID, asset.getGUID(), properties, methodName);
            }
        }
    }

    public void saveAssociatedSchemaType(String userId, String assetGUID, SchemaType schemaType, List<SchemaAttribute> schemaAttributes, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String assetGUIDParameter = "assetGUID";
        this.saveAssociatedSchemaType(userId, this.retrieveAssetFromRepositoryByGUID(userId, assetGUID, "assetGUID", null, methodName), schemaType, schemaAttributes, methodName);
    }

    private void saveAssociatedSchemaType(String userId, Asset asset, SchemaType schemaType, List<SchemaAttribute> schemaAttributes, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String assetGUIDParameter = "assetGUID";
        if (asset != null) {
            String schemaTypeGUID;
            this.invalidParameterHandler.validateAssetInSupportedZone(asset.getGUID(), "assetGUID", asset.getZoneMembership(), this.getSupportedZones(userId, this.serviceName), this.serviceName, methodName);
            this.securityVerifier.validateUserForAssetAttachmentUpdate(userId, asset);
            if (schemaType != null && (schemaTypeGUID = this.schemaTypeHandler.saveSchemaType(userId, schemaType, schemaAttributes, methodName)) != null) {
                this.repositoryHandler.createRelationship(userId, "815b004d-73c6-4728-9dd9-536f4fe803cd", schemaTypeGUID, asset.getGUID(), null, methodName);
            }
        }
    }

    public void saveSemanticAssignment(String userId, String assetGUID, String glossaryTermGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String assetGUIDParameter = "assetGUID";
        String glossaryTermGUIDParameter = "glossaryTermGUID";
        Asset asset = this.retrieveAssetFromRepositoryByGUID(userId, assetGUID, "assetGUID", null, methodName);
        if (asset != null) {
            this.invalidParameterHandler.validateAssetInSupportedZone(assetGUID, "assetGUID", asset.getZoneMembership(), this.getSupportedZones(userId, this.serviceName), this.serviceName, methodName);
            this.securityVerifier.validateUserForAssetAttachmentUpdate(userId, asset);
            this.repositoryHandler.validateEntityGUID(userId, glossaryTermGUID, "GlossaryTerm", methodName, "glossaryTermGUID");
            this.repositoryHandler.createRelationship(userId, "e6670973-645f-441a-bec7-6f5570345b92", assetGUID, glossaryTermGUID, null, methodName);
        }
    }

    public void saveSemanticAssignment(String userId, String assetGUID, String glossaryTermGUID, String assetElementGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String assetGUIDParameter = "assetGUID";
        String glossaryTermGUIDParameter = "glossaryTermGUID";
        String assetElementGUIDParameter = "assetElementGUID";
        Asset asset = this.retrieveAssetFromRepositoryByGUID(userId, assetGUID, "assetGUID", null, methodName);
        if (asset != null) {
            this.invalidParameterHandler.validateAssetInSupportedZone(assetGUID, "assetGUID", asset.getZoneMembership(), this.getSupportedZones(userId, this.serviceName), this.serviceName, methodName);
            this.securityVerifier.validateUserForAssetAttachmentUpdate(userId, asset);
            this.repositoryHandler.validateEntityGUID(userId, glossaryTermGUID, "GlossaryTerm", methodName, "glossaryTermGUID");
            this.repositoryHandler.validateEntityGUID(userId, assetElementGUID, "Referenceable", methodName, "assetElementGUID");
            this.repositoryHandler.createRelationship(userId, "e6670973-645f-441a-bec7-6f5570345b92", assetElementGUID, glossaryTermGUID, null, methodName);
        }
    }

    public void removeSemanticAssignment(String userId, String assetGUID, String glossaryTermGUID, String assetElementGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameter = "assetGUID";
        String glossaryTermGUIDParameter = "glossaryTermGUID";
        String assetElementGUIDParameter = "assetElementGUID";
        Asset asset = this.retrieveAssetFromRepositoryByGUID(userId, assetGUID, "assetGUID", null, methodName);
        if (asset != null) {
            this.invalidParameterHandler.validateAssetInSupportedZone(assetGUID, "assetGUID", asset.getZoneMembership(), this.getSupportedZones(userId, this.serviceName), this.serviceName, methodName);
            this.securityVerifier.validateUserForAssetAttachmentUpdate(userId, asset);
            this.repositoryHandler.validateEntityGUID(userId, glossaryTermGUID, "GlossaryTerm", methodName, "glossaryTermGUID");
            this.repositoryHandler.validateEntityGUID(userId, assetElementGUID, "Referenceable", methodName, "assetElementGUID");
            this.repositoryHandler.createRelationship(userId, "e6670973-645f-441a-bec7-6f5570345b92", assetElementGUID, glossaryTermGUID, null, methodName);
        }
    }

    public void removeSemanticAssignment(String userId, String assetGUID, String glossaryTermGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameter = "assetGUID";
        String glossaryTermGUIDParameter = "glossaryTermGUID";
        String assetElementGUIDParameter = "assetElementGUID";
        Asset asset = this.retrieveAssetFromRepositoryByGUID(userId, assetGUID, "assetGUID", null, methodName);
        if (asset != null) {
            this.invalidParameterHandler.validateAssetInSupportedZone(assetGUID, "assetGUID", asset.getZoneMembership(), this.getSupportedZones(userId, this.serviceName), this.serviceName, methodName);
            this.securityVerifier.validateUserForAssetAttachmentUpdate(userId, asset);
            this.repositoryHandler.validateEntityGUID(userId, glossaryTermGUID, "GlossaryTerm", methodName, "glossaryTermGUID");
            this.repositoryHandler.createRelationship(userId, "e6670973-645f-441a-bec7-6f5570345b92", assetGUID, glossaryTermGUID, null, methodName);
        }
    }

    public String addAsset(String userId, String requestedTypeName, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        Asset asset = this.createEmptyAsset(requestedTypeName, methodName);
        asset.setQualifiedName(qualifiedName);
        asset.setDisplayName(displayName);
        asset.setDescription(description);
        asset.setAdditionalProperties(additionalProperties);
        asset.setExtendedProperties(extendedProperties);
        return this.addAsset(userId, asset, null, null, null, methodName);
    }

    public String addAsset(String userId, Asset asset, Connection connection, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.addAsset(userId, asset, null, null, connection, methodName);
    }

    public String addAsset(String userId, Asset asset, SchemaType schemaType, List<SchemaAttribute> schemaAttributes, Connection connection, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String qualifiedNameParameter = "asset.qualifiedName";
        if (asset != null) {
            this.invalidParameterHandler.validateName(asset.getQualifiedName(), "asset.qualifiedName", methodName);
            if (asset.getOwner() == null) {
                asset.setOwner(userId);
                asset.setOwnerType(OwnerType.USER_ID);
            }
            String defaultLatestChange = "Asset created";
            if (asset.getLatestChange() == null) {
                asset.setLatestChange("Asset created");
            }
            asset.setZoneMembership(this.securityVerifier.initializeAssetZones(this.defaultZones, asset));
            this.securityVerifier.validateUserForAssetCreate(userId, asset);
            String assetTypeGUID = null;
            String assetTypeName = null;
            ElementType assetType = asset.getType();
            if (assetType != null) {
                assetTypeGUID = assetType.getElementTypeId();
                assetTypeName = assetType.getElementTypeName();
            }
            AssetBuilder assetBuilder = new AssetBuilder(asset.getQualifiedName(), asset.getDisplayName(), asset.getDescription(), asset.getOwner(), asset.getOwnerType(), asset.getZoneMembership(), asset.getLatestChange(), asset.getAdditionalProperties(), asset.getExtendedProperties(), this.repositoryHelper, this.serviceName, this.serverName);
            String assetGUID = this.repositoryHandler.createEntity(userId, assetTypeGUID, assetTypeName, assetBuilder.getInstanceProperties(methodName), methodName);
            this.saveAssociatedConnection(userId, assetGUID, asset.getShortDescription(), connection, methodName);
            this.saveAssociatedSchemaType(userId, assetGUID, schemaType, schemaAttributes, methodName);
            return assetGUID;
        }
        return null;
    }

    public String updateAsset(String userId, Asset originalAsset, AssetAuditHeader originalAssetAuditHeader, Asset updatedAsset, SchemaType schemaType, List<SchemaAttribute> schemaAttributes, Connection connection, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (originalAsset != null) {
            updatedAsset.setZoneMembership(this.securityVerifier.verifyAssetZones(this.defaultZones, this.getSupportedZones(userId, this.serviceName), originalAsset, updatedAsset));
            this.securityVerifier.validateUserForAssetDetailUpdate(userId, originalAsset, originalAssetAuditHeader, updatedAsset);
            ElementType type = originalAsset.getType();
            String assetTypeGUID = type.getElementTypeId();
            String assetTypeName = type.getElementTypeName();
            AssetBuilder assetBuilder = new AssetBuilder(updatedAsset.getQualifiedName(), updatedAsset.getDisplayName(), updatedAsset.getDescription(), updatedAsset.getOwner(), updatedAsset.getOwnerType(), updatedAsset.getZoneMembership(), updatedAsset.getLatestChange(), updatedAsset.getAdditionalProperties(), updatedAsset.getExtendedProperties(), this.repositoryHelper, this.serviceName, this.serverName);
            this.repositoryHandler.updateEntity(userId, originalAsset.getGUID(), assetTypeGUID, assetTypeName, assetBuilder.getInstanceProperties(methodName), methodName);
            if (originalAsset.getZoneMembership() == null) {
                if (updatedAsset.getZoneMembership() != null) {
                    this.repositoryHandler.classifyEntity(userId, originalAsset.getGUID(), "a1c17a86-9fd3-40ca-bb9b-fe83c6981deb", "AssetZoneMembership", assetBuilder.getZoneMembershipProperties(methodName), methodName);
                }
            } else {
                if (updatedAsset.getZoneMembership() == null) {
                    this.repositoryHandler.declassifyEntity(userId, originalAsset.getGUID(), "a1c17a86-9fd3-40ca-bb9b-fe83c6981deb", "AssetZoneMembership", methodName);
                }
                if (!originalAsset.getZoneMembership().equals(updatedAsset.getZoneMembership())) {
                    this.repositoryHandler.reclassifyEntity(userId, originalAsset.getGUID(), "a1c17a86-9fd3-40ca-bb9b-fe83c6981deb", "AssetZoneMembership", assetBuilder.getZoneMembershipProperties(methodName), methodName);
                }
            }
            if (originalAsset.getOwner() == null) {
                if (updatedAsset.getOwner() != null) {
                    this.repositoryHandler.classifyEntity(userId, originalAsset.getGUID(), "d531c566-03d2-470a-be69-6f52cabd5fb9", "AssetOwnership", assetBuilder.getOwnerProperties(methodName), methodName);
                }
            } else {
                if (updatedAsset.getOwner() == null) {
                    this.repositoryHandler.declassifyEntity(userId, originalAsset.getGUID(), "d531c566-03d2-470a-be69-6f52cabd5fb9", "AssetOwnership", methodName);
                }
                if (!originalAsset.getOwner().equals(updatedAsset.getOwner())) {
                    this.repositoryHandler.reclassifyEntity(userId, originalAsset.getGUID(), "d531c566-03d2-470a-be69-6f52cabd5fb9", "AssetOwnership", assetBuilder.getOwnerProperties(methodName), methodName);
                }
            }
            this.saveAssociatedConnection(userId, originalAsset, updatedAsset.getShortDescription(), connection, methodName);
            this.saveAssociatedSchemaType(userId, originalAsset, schemaType, schemaAttributes, methodName);
            return originalAsset.getGUID();
        }
        return null;
    }

    public void addAssetOrigin(String userId, String assetGUID, String organizationGUID, String businessCapabilityGUID, Map<String, String> otherOriginValues, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameterName = "assetGUID";
        String organizationGUIDParameterName = "assetGUID";
        String businessCapabilityGUIDParameterName = "businessCapabilityGUID";
        AssetConverter converter = this.retrieveAssetConverterFromRepositoryByGUID(userId, assetGUID, "assetGUID", null, methodName);
        if (converter != null) {
            Asset assetBean = converter.getAssetBean();
            this.invalidParameterHandler.validateAssetInSupportedZone(assetGUID, "assetGUID", assetBean.getZoneMembership(), this.getSupportedZones(userId, this.serviceName), this.serviceName, methodName);
            Asset updatedAsset = new Asset(assetBean);
            InstanceProperties properties = null;
            HashMap<String, Object> propertiesMap = new HashMap<String, Object>();
            if (organizationGUID != null) {
                this.repositoryHandler.validateEntityGUID(userId, organizationGUID, "Organization", methodName, "assetGUID");
                propertiesMap.put("organization", organizationGUID);
                properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "organization", organizationGUID, methodName);
            }
            if (businessCapabilityGUID != null) {
                this.repositoryHandler.validateEntityGUID(userId, businessCapabilityGUID, "BusinessCapability", methodName, "businessCapabilityGUID");
                propertiesMap.put("businessCapability", businessCapabilityGUID);
                properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "businessCapability", businessCapabilityGUID, methodName);
            }
            if (otherOriginValues != null && !otherOriginValues.isEmpty()) {
                propertiesMap.put("otherOriginValues", otherOriginValues);
                properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, "otherOriginValues", otherOriginValues, methodName);
            }
            Classification classification = new Classification();
            classification.setClassificationName("AssetOrigin");
            classification.setClassificationProperties(propertiesMap);
            ArrayList<Classification> assetClassifications = assetBean.getClassifications();
            if (assetClassifications == null) {
                assetClassifications = new ArrayList<Classification>();
            }
            assetClassifications.add(classification);
            updatedAsset.setClassifications(assetClassifications);
            updatedAsset.setZoneMembership(this.securityVerifier.verifyAssetZones(this.defaultZones, this.getSupportedZones(userId, this.serviceName), assetBean, updatedAsset));
            this.securityVerifier.validateUserForAssetDetailUpdate(userId, assetBean, converter.getAssetAuditHeader(), updatedAsset);
            this.repositoryHandler.classifyEntity(userId, assetGUID, "e530c566-03d2-470a-be69-6f52bfbd5fb7", "AssetOrigin", properties, methodName);
        }
    }

    public void removeAssetOrigin(String userId, String assetGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.repositoryHandler.declassifyEntity(userId, assetGUID, "e530c566-03d2-470a-be69-6f52bfbd5fb7", "AssetOrigin", methodName);
    }

    public void updateAssetZones(String userId, String assetGUID, List<String> assetZones, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameterName = "assetGUID";
        AssetConverter converter = this.retrieveAssetConverterFromRepositoryByGUID(userId, assetGUID, "assetGUID", null, methodName);
        if (converter != null) {
            Asset originalAsset = converter.getAssetBean();
            this.invalidParameterHandler.validateAssetInSupportedZone(assetGUID, "assetGUID", originalAsset.getZoneMembership(), this.getSupportedZones(userId, this.serviceName), this.serviceName, methodName);
            Asset updatedAsset = new Asset(originalAsset);
            updatedAsset.setZoneMembership(assetZones);
            updatedAsset.setLatestChange("New Zone Setting");
            this.updateAsset(userId, originalAsset, converter.getAssetAuditHeader(), updatedAsset, null, null, null, methodName);
        }
    }

    public void addSecurityTags(String userId, String assetGUID, List<String> securityLabels, Map<String, Object> securityProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void removeSecurityTags(String userId, String assetGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.repositoryHandler.declassifyEntity(userId, assetGUID, "a0b07a86-9fd3-40ca-bb9b-fe83c6981deb", "SecurityTags", methodName);
    }

    public void addSecurityTags(String userId, String assetGUID, String assetElementGUID, List<String> securityLabels, Map<String, Object> securityProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void removeSecurityTags(String userId, String assetGUID, String assetElementGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.repositoryHandler.declassifyEntity(userId, assetElementGUID, "a0b07a86-9fd3-40ca-bb9b-fe83c6981deb", "SecurityTags", methodName);
    }

    public void updateAssetOwner(String userId, String assetGUID, String ownerId, OwnerType ownerType, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameterName = "assetGUID";
        AssetConverter converter = this.retrieveAssetConverterFromRepositoryByGUID(userId, assetGUID, "assetGUID", null, methodName);
        if (converter != null) {
            Asset originalAsset = converter.getAssetBean();
            this.invalidParameterHandler.validateAssetInSupportedZone(assetGUID, "assetGUID", originalAsset.getZoneMembership(), this.getSupportedZones(userId, this.serviceName), this.serviceName, methodName);
            Asset updatedAsset = new Asset(originalAsset);
            updatedAsset.setOwner(ownerId);
            updatedAsset.setOwnerType(ownerType);
            updatedAsset.setLatestChange("New Owner");
            this.updateAsset(userId, originalAsset, converter.getAssetAuditHeader(), updatedAsset, null, null, null, methodName);
        }
    }

    private void updateAssetLatestAttachment(String callingUserId, Asset asset, String latestChange, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String userId = callingUserId;
        if (this.localServerUserId != null) {
            userId = this.localServerUserId;
        }
        ElementType type = asset.getType();
        String assetTypeGUID = type.getElementTypeId();
        String assetTypeName = type.getElementTypeName();
        AssetBuilder assetBuilder = new AssetBuilder(asset.getQualifiedName(), asset.getDisplayName(), asset.getDescription(), asset.getOwner(), asset.getOwnerType(), asset.getZoneMembership(), latestChange, asset.getAdditionalProperties(), asset.getExtendedProperties(), this.repositoryHelper, this.serviceName, this.serverName);
        this.repositoryHandler.updateEntity(userId, asset.getGUID(), assetTypeGUID, assetTypeName, assetBuilder.getInstanceProperties(methodName), methodName);
    }

    public void removeAsset(String userId, String assetGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String assetGUIDParameterName = "assetGUID";
        String validatingParameterName = "qualifiedName";
        Asset asset = this.getAsset(userId, this.getSupportedZones(userId, this.serviceName), assetGUID, this.serviceName, methodName);
        if (asset != null) {
            this.invalidParameterHandler.validateAssetInSupportedZone(assetGUID, "assetGUID", asset.getZoneMembership(), this.getSupportedZones(userId, this.serviceName), this.serviceName, methodName);
            this.securityVerifier.validateUserForAssetDelete(userId, asset);
            List relationships = this.repositoryHandler.getRelationshipsByType(userId, assetGUID, "Asset", "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", methodName);
            this.repositoryHandler.removeEntity(userId, assetGUID, "896d14c2-7522-4f6c-8519-757711943fe6", "Asset", "qualifiedName", asset.getQualifiedName(), methodName);
            if (relationships != null) {
                for (Relationship relationship : relationships) {
                    EntityProxy entityProxy;
                    if (relationship == null || (entityProxy = relationship.getEntityOneProxy()) == null) continue;
                    this.repositoryHandler.removeRelationshipBetweenEntities(userId, "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", entityProxy.getGUID(), "Connection", assetGUID, methodName);
                    this.removeDisconnectedConnection(userId, entityProxy.getGUID(), methodName);
                }
            }
        }
    }

    private void removeDisconnectedConnection(String userId, String connectionGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List relationships;
        if (connectionGUID != null && ((relationships = this.repositoryHandler.getRelationshipsByType(userId, connectionGUID, "Connection", "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", methodName)) == null || relationships.isEmpty())) {
            this.connectionHandler.removeConnection(userId, connectionGUID);
        }
    }

    protected Asset validatedVisibleAsset(String userId, List<String> supportedZones, String guidParameterName, Asset retrievedAsset, String serviceName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateAssetInSupportedZone(retrievedAsset.getGUID(), guidParameterName, retrievedAsset.getZoneMembership(), this.securityVerifier.setSupportedZonesForUser(supportedZones, serviceName, userId), serviceName, methodName);
        this.securityVerifier.validateUserForAssetRead(userId, retrievedAsset);
        return retrievedAsset;
    }

    public Asset getAsset(String userId, List<String> supportedZones, String assetGUID, String serviceName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "assetGUID";
        EntityDetail assetEntity = this.repositoryHandler.getEntityByGUID(userId, assetGUID, "assetGUID", "Asset", methodName);
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, assetGUID, "Asset", "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", methodName);
        AssetConverter assetConverter = new AssetConverter(assetEntity, relationship, this.repositoryHelper, methodName);
        return this.validatedVisibleAsset(userId, supportedZones, "assetGUID", assetConverter.getAssetBean(), serviceName, methodName);
    }

    public Asset getAsset(String userId, List<String> supportedZones, Relationship assetConnectionRelationship, String serviceName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "assetGUID";
        if (assetConnectionRelationship != null) {
            EntityProxy connectionProxy = assetConnectionRelationship.getEntityOneProxy();
            EntityProxy assetProxy = assetConnectionRelationship.getEntityTwoProxy();
            if (connectionProxy != null && assetProxy != null) {
                EntityDetail assetEntity = this.repositoryHandler.getEntityByGUID(userId, assetProxy.getGUID(), "assetGUID", "Asset", methodName);
                AssetConverter assetConverter = new AssetConverter(assetEntity, assetConnectionRelationship, this.repositoryHelper, methodName);
                return this.validatedVisibleAsset(userId, supportedZones, "assetGUID", assetConverter.getAssetBean(), serviceName, methodName);
            }
        }
        return null;
    }

    public Asset getAsset(String userId, List<String> supportedZones, String assetGUID, String connectionGUID, String serviceName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "assetGUID";
        EntityDetail assetEntity = this.repositoryHandler.getEntityByGUID(userId, assetGUID, "assetGUID", "Asset", methodName);
        Relationship relationship = null;
        if (connectionGUID != null) {
            relationship = this.repositoryHandler.getRelationshipBetweenEntities(userId, assetGUID, "Asset", connectionGUID, "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", methodName);
        }
        AssetConverter assetConverter = new AssetConverter(assetEntity, relationship, this.repositoryHelper, methodName);
        return this.validatedVisibleAsset(userId, supportedZones, "assetGUID", assetConverter.getAssetBean(), serviceName, methodName);
    }

    public Connection getConnectionForAsset(String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityProxy entityProxy;
        String methodName = "getConnectionForAsset";
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, assetGUID, "Asset", "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", "getConnectionForAsset");
        if (relationship != null && (entityProxy = relationship.getEntityOneProxy()) != null) {
            return this.connectionHandler.getConnection(userId, entityProxy.getGUID());
        }
        return null;
    }

    public List<Connection> getConnectionsForAsset(String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getConnectionsForAsset";
        List relationships = this.repositoryHandler.getRelationshipsByType(userId, assetGUID, "Asset", "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", "getConnectionsForAsset");
        ArrayList<Connection> connections = new ArrayList<Connection>();
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                Connection linkedConnection;
                EntityProxy entityProxy;
                if (relationship == null || (entityProxy = relationship.getEntityOneProxy()) == null || (linkedConnection = this.connectionHandler.getConnection(userId, entityProxy.getGUID())) == null) continue;
                connections.add(linkedConnection);
            }
        }
        if (connections.isEmpty()) {
            return null;
        }
        return connections;
    }

    public String getAssetForConnection(String userId, String connectionGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityProxy entityProxy;
        String methodName = "getAssetForConnection";
        String guidParameter = "connectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "getAssetForConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "getAssetForConnection");
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, connectionGUID, "Connection", "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", "getAssetForConnection");
        if (relationship != null && (entityProxy = relationship.getEntityTwoProxy()) != null) {
            return entityProxy.getGUID();
        }
        return null;
    }

    public String getAssetForConnectionName(String userId, String connectionName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        Connection connection = this.connectionHandler.getConnectionByName(userId, connectionName, methodName);
        if (connection != null && connection.getGUID() != null) {
            return this.getAssetForConnection(userId, connection.getGUID());
        }
        return null;
    }

    public List<String> assetGUIDsScan(String userId, String subTypeGUID, String subTypeName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getGUIDs(this.assetScan(userId, subTypeGUID, subTypeName, startFrom, pageSize, methodName));
    }

    public List<Asset> assetScan(String userId, String subTypeGUID, String subTypeName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        String typeGUID = "896d14c2-7522-4f6c-8519-757711943fe6";
        String typeName = "Asset";
        if (subTypeGUID != null) {
            typeGUID = subTypeGUID;
        }
        if (subTypeName != null) {
            typeName = subTypeName;
        }
        List<Asset> results = new ArrayList<Asset>();
        boolean moreResultsAvailable = true;
        int startNextQueryFrom = startFrom;
        while (moreResultsAvailable && results.size() < pageSize) {
            List retrievedEntities = this.repositoryHandler.getEntitiesForType(userId, typeGUID, typeName, startFrom, pageSize, methodName);
            if (retrievedEntities != null) {
                results = this.getAssetList(userId, retrievedEntities, results, pageSize, methodName);
                moreResultsAvailable = retrievedEntities.size() == pageSize;
                startNextQueryFrom += pageSize;
                continue;
            }
            moreResultsAvailable = false;
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<Asset> assetZoneScan(String userId, String zoneName, String subTypeGUID, String subTypeName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<String> zonesForVisibleAssets;
        this.invalidParameterHandler.validateUserId(userId, methodName);
        String typeGUID = "896d14c2-7522-4f6c-8519-757711943fe6";
        String typeName = "Asset";
        if (subTypeGUID != null) {
            typeGUID = subTypeGUID;
        }
        if (subTypeName != null) {
            typeName = subTypeName;
        }
        if ((zonesForVisibleAssets = this.getSupportedZones(userId, this.serviceName)).contains(zoneName)) {
            ArrayList<Asset> results = new ArrayList<Asset>();
            boolean moreResultsAvailable = true;
            int startNextQueryFrom = startFrom;
            while (moreResultsAvailable && results.size() < pageSize) {
                List retrievedEntities = this.repositoryHandler.getEntitiesForType(userId, typeGUID, typeName, startFrom, pageSize, methodName);
                if (retrievedEntities != null) {
                    for (EntityDetail entity : retrievedEntities) {
                        AssetConverter converter;
                        Asset asset;
                        List assetZones;
                        if (entity == null || results.size() >= pageSize || (assetZones = (asset = (converter = new AssetConverter(entity, null, this.repositoryHelper, this.serviceName)).getAssetBean()).getZoneMembership()) == null || !assetZones.contains(zoneName)) continue;
                        results.add(asset);
                    }
                    moreResultsAvailable = retrievedEntities.size() == pageSize;
                    startNextQueryFrom += pageSize;
                    continue;
                }
                moreResultsAvailable = false;
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    private List<String> getGUIDs(List<Asset> assets) {
        if (assets != null && !assets.isEmpty()) {
            ArrayList<String> results = new ArrayList<String>();
            for (Asset asset : assets) {
                String guid;
                if (asset == null || (guid = asset.getGUID()) == null) continue;
                results.add(guid);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public List<String> getAssetGUIDsByQualifiedName(String userId, String name, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getGUIDs(this.getAssetsByQualifiedName(userId, name, startFrom, pageSize, methodName));
    }

    public List<Asset> getAssetsByQualifiedName(String userId, String name, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nameParameterName = "name";
        this.invalidParameterHandler.validateName(name, "name", methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        AssetBuilder builder = new AssetBuilder(name, name, this.repositoryHelper, this.serviceName, this.serverName);
        List<Asset> results = new ArrayList<Asset>();
        boolean moreResultsAvailable = true;
        int startNextQueryFrom = startFrom;
        while (moreResultsAvailable && (queryPageSize == 0 || results.size() < queryPageSize)) {
            List retrievedEntities = this.repositoryHandler.getEntitiesByName(userId, builder.getQualifiedNameInstanceProperties(methodName), "896d14c2-7522-4f6c-8519-757711943fe6", startFrom, queryPageSize, methodName);
            if (retrievedEntities != null) {
                results = this.getAssetList(userId, retrievedEntities, results, queryPageSize, methodName);
                moreResultsAvailable = retrievedEntities.size() == queryPageSize;
                startNextQueryFrom += queryPageSize;
                continue;
            }
            moreResultsAvailable = false;
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<String> getAssetGUIDsByName(String userId, String name, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getGUIDs(this.getAssetsByName(userId, name, startFrom, pageSize, methodName));
    }

    public List<Asset> getAssetsByName(String userId, String name, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nameParameterName = "name";
        this.invalidParameterHandler.validateName(name, "name", methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        AssetBuilder builder = new AssetBuilder(name, name, this.repositoryHelper, this.serviceName, this.serverName);
        List<Asset> results = new ArrayList<Asset>();
        boolean moreResultsAvailable = true;
        int startNextQueryFrom = startFrom;
        while (moreResultsAvailable && (queryPageSize == 0 || results.size() < queryPageSize)) {
            List retrievedEntities = this.repositoryHandler.getEntitiesByName(userId, builder.getQualifiedNameInstanceProperties(methodName), "896d14c2-7522-4f6c-8519-757711943fe6", startFrom, queryPageSize, methodName);
            if (retrievedEntities == null) {
                retrievedEntities = this.repositoryHandler.getEntitiesByName(userId, builder.getNameInstanceProperties(methodName), "896d14c2-7522-4f6c-8519-757711943fe6", startFrom, queryPageSize, methodName);
            }
            if (retrievedEntities != null) {
                results = this.getAssetList(userId, retrievedEntities, results, queryPageSize, methodName);
                moreResultsAvailable = retrievedEntities.size() == queryPageSize;
                startNextQueryFrom += queryPageSize;
                continue;
            }
            moreResultsAvailable = false;
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<String> getAssetGUIDsByEndpoint(String userId, String networkAddress, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getGUIDs(this.getAssetsByEndpoint(userId, networkAddress, startFrom, pageSize, methodName));
    }

    public List<Asset> getAssetsByEndpoint(String userId, String networkAddress, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String addressParameterName = "networkAddress";
        this.invalidParameterHandler.validateName(networkAddress, "networkAddress", methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        ArrayList<Asset> assets = new ArrayList<Asset>();
        boolean moreResultsAvailable = true;
        int startNextQueryFrom = startFrom;
        while (moreResultsAvailable && (queryPageSize == 0 || assets.size() < queryPageSize)) {
            List<Endpoint> endpoints = this.endpointHandler.getEndpointsByNetworkAddress(userId, networkAddress, startFrom, queryPageSize, methodName);
            if (endpoints != null) {
                for (Endpoint endpoint : endpoints) {
                    List connectionEntities;
                    if (endpoint == null || (connectionEntities = this.repositoryHandler.getEntitiesForRelationshipType(userId, endpoint.getGUID(), "Endpoint", "887a7132-d6bc-4b92-a483-e80b60c86fb2", "ConnectionEndpoint", startNextQueryFrom, queryPageSize, methodName)) == null) continue;
                    for (EntityDetail connectionEntity : connectionEntities) {
                        List connectionRelationships;
                        if (connectionEntity == null || (connectionRelationships = this.repositoryHandler.getRelationshipsByType(userId, connectionEntity.getGUID(), "Connection", "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", startFrom, queryPageSize, methodName)) == null) continue;
                        for (Relationship connectionRelationship : connectionRelationships) {
                            Asset asset;
                            if (connectionRelationship == null || (asset = this.getAsset(userId, this.supportedZones, connectionRelationship, this.serviceName, methodName)) == null || assets.size() > queryPageSize) continue;
                            assets.add(asset);
                        }
                    }
                }
            }
            if (endpoints.size() < queryPageSize || assets.size() == queryPageSize) {
                moreResultsAvailable = false;
                continue;
            }
            startNextQueryFrom += queryPageSize;
        }
        if (assets.isEmpty()) {
            return null;
        }
        return assets;
    }

    public List<String> findAssetGUIDs(String userId, String searchString, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getGUIDs(this.findAssets(userId, searchString, startFrom, pageSize, methodName));
    }

    public List<Asset> findAssets(String userId, String searchString, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String searchParameter = "searchString";
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        AssetBuilder builder = new AssetBuilder(searchString, searchString, searchString, this.repositoryHelper, this.serviceName, this.serverName);
        List<Asset> results = new ArrayList<Asset>();
        boolean moreResultsAvailable = true;
        int startNextQueryFrom = startFrom;
        while (moreResultsAvailable && (queryPageSize == 0 || results.size() < queryPageSize)) {
            List retrievedEntities = this.repositoryHandler.getEntitiesByName(userId, builder.getSearchInstanceProperties(methodName), "896d14c2-7522-4f6c-8519-757711943fe6", startNextQueryFrom, queryPageSize, methodName);
            if (retrievedEntities != null) {
                results = this.getAssetList(userId, retrievedEntities, results, queryPageSize, methodName);
                moreResultsAvailable = retrievedEntities.size() == queryPageSize;
                startNextQueryFrom += queryPageSize;
                continue;
            }
            moreResultsAvailable = false;
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    private List<Asset> getAssetList(String userId, List<EntityDetail> retrievedEntities, List<Asset> currentAssetList, int maxPageSize, String methodName) {
        List<Asset> results = currentAssetList;
        if (results == null) {
            results = new ArrayList<Asset>();
        }
        if (retrievedEntities != null) {
            for (EntityDetail entity : retrievedEntities) {
                if (entity == null || results.size() >= maxPageSize) continue;
                AssetConverter converter = new AssetConverter(entity, null, this.repositoryHelper, this.serviceName);
                Asset asset = converter.getAssetBean();
                try {
                    results.add(this.validatedVisibleAsset(userId, this.getSupportedZones(userId, this.serviceName), "asset.getGUID()", asset, this.serviceName, methodName));
                }
                catch (Throwable throwable) {}
            }
        }
        return results;
    }

    private void verifyAttachment(String userId, String assetGUID, List<String> supportedZones, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameter = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", methodName);
        this.repositoryHandler.validateEntityGUID(userId, assetGUID, "Asset", methodName, "assetGUID");
        Asset asset = this.getAsset(userId, supportedZones, assetGUID, this.serviceName, methodName);
        this.securityVerifier.validateUserForAssetFeedback(userId, asset);
    }

    private void verifyAttachment(String userId, String assetGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.verifyAttachment(userId, assetGUID, this.getSupportedZones(userId, this.serviceName), methodName);
    }

    public int getCertificationCount(String userId, String anchorGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.certificationHandler.countCertifications(userId, anchorGUID, methodName);
    }

    public int getCommentCount(String userId, String anchorGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.commentHandler.countAttachedComments(userId, anchorGUID, methodName);
    }

    public List<Comment> getAssetComments(String userId, List<String> supportedZones, String assetGUID, String anchorGUID, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.verifyAttachment(userId, assetGUID, supportedZones, methodName);
        return this.commentHandler.getComments(userId, anchorGUID, "Asset", startingFrom, pageSize, methodName);
    }

    public String addCommentToAsset(String userId, String assetGUID, CommentType commentType, String commentText, boolean isPublic, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.verifyAttachment(userId, assetGUID, methodName);
        return this.commentHandler.addCommentToAnchor(userId, assetGUID, "Asset", commentType, commentText, isPublic, methodName);
    }

    public void updateAssetComment(String userId, String assetGUID, String commentGUID, CommentType commentType, String commentText, boolean isPublic, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.verifyAttachment(userId, assetGUID, methodName);
        this.commentHandler.updateComment(userId, assetGUID, "Asset", commentGUID, commentType, commentText, isPublic, methodName);
    }

    public String addCommentReply(String userId, String assetGUID, String attachmentGUID, CommentType commentType, String commentText, boolean isPublic, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.verifyAttachment(userId, assetGUID, methodName);
        return this.commentHandler.addCommentReplyToAnchor(userId, assetGUID, "Asset", attachmentGUID, commentType, commentText, isPublic, methodName);
    }

    public void removeAssetComment(String userId, String assetGUID, String commentGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.verifyAttachment(userId, assetGUID, methodName);
        this.commentHandler.removeCommentFromAnchor(userId, assetGUID, "Asset", commentGUID, methodName);
    }

    public int getConnectionCount(String userId, String anchorGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.connectionHandler.countAttachedConnections(userId, anchorGUID, methodName);
    }

    public int getExternalIdentifierCount(String userId, String anchorGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.externalIdentifierHandler.countExternalIdentifiers(userId, anchorGUID, methodName);
    }

    public int getExternalReferencesCount(String userId, String anchorGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.externalReferenceHandler.countExternalReferences(userId, anchorGUID, methodName);
    }

    public int getInformalTagCount(String userId, String anchorGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.informalTagHandler.countTags(userId, anchorGUID, methodName);
    }

    public void addTagToAsset(String userId, String assetGUID, String tagGUID, boolean isPublic, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.verifyAttachment(userId, assetGUID, methodName);
        this.informalTagHandler.addTagToAnchor(userId, assetGUID, "Asset", tagGUID, isPublic, methodName);
    }

    public void removeTagFromAsset(String userId, String assetGUID, String tagGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.verifyAttachment(userId, assetGUID, methodName);
        this.informalTagHandler.removeTagFromAnchor(userId, assetGUID, "Asset", tagGUID, methodName);
    }

    public List<String> getAssetsByTag(String userId, String tagGUID, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return null;
    }

    public List<String> getAssetsByMeaning(String userId, String termGUID, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return null;
    }

    public int getLicenseCount(String userId, String anchorGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.licenseHandler.countLicenses(userId, anchorGUID, methodName);
    }

    public int getLikeCount(String userId, String anchorGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.likeHandler.countLikes(userId, anchorGUID, methodName);
    }

    public void addLikeToAsset(String userId, String assetGUID, boolean isPublic, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.verifyAttachment(userId, assetGUID, methodName);
        this.likeHandler.addLikeToReferenceable(userId, assetGUID, "Asset", isPublic, methodName);
    }

    public void removeLikeFromAsset(String userId, String assetGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.verifyAttachment(userId, assetGUID, methodName);
        this.likeHandler.removeLikeFromReferenceable(userId, assetGUID, "Asset", methodName);
    }

    public int getKnownLocationsCount(String userId, String anchorGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.locationHandler.countKnownLocations(userId, anchorGUID, methodName);
    }

    public int getNoteLogsCount(String userId, String anchorGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.noteLogHandler.countAttachedNoteLogs(userId, anchorGUID, methodName);
    }

    public int getRatingsCount(String userId, String anchorGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.ratingHandler.countRatings(userId, anchorGUID, methodName);
    }

    public void addRatingToAsset(String userId, String assetGUID, StarRating starRating, String review, boolean isPublic, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String ratingParameter = "starRating";
        this.invalidParameterHandler.validateEnum((Object)starRating, "starRating", methodName);
        this.verifyAttachment(userId, assetGUID, methodName);
        this.ratingHandler.addRatingToReferenceable(userId, assetGUID, "Asset", starRating, review, isPublic, methodName);
    }

    public void removeRatingFromAsset(String userId, String assetGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.verifyAttachment(userId, assetGUID, methodName);
        this.ratingHandler.removeRatingFromReferencable(userId, assetGUID, "Asset", methodName);
    }

    public int getRelatedAssetCount(String userId, String anchorGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<RelatedAsset> relatedAssets = this.getRelatedAssets(userId, this.getSupportedZones(userId, this.serviceName), anchorGUID, 0, this.invalidParameterHandler.getMaxPagingSize(), this.serviceName, methodName);
        if (relatedAssets == null) {
            return 0;
        }
        return relatedAssets.size();
    }

    public List<RelatedAsset> getRelatedAssets(String userId, List<String> supportedZones, String anchorGUID, int startFrom, int pageSize, String serviceName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getRelatedAssets(userId, supportedZones, anchorGUID, null, "all", startFrom, pageSize, serviceName, methodName);
    }

    public List<RelatedAsset> getRelatedAssets(String userId, List<String> supportedZones, String anchorGUID, String relationshipTypeGUID, String relationshipTypeName, int startFrom, int pageSize, String serviceName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List assetRelationships;
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        String relationshipTypeDisplayName = "all";
        if (relationshipTypeName != null) {
            relationshipTypeDisplayName = relationshipTypeName;
        }
        if ((assetRelationships = this.repositoryHandler.getRelationshipsByType(userId, anchorGUID, "Asset", relationshipTypeGUID, relationshipTypeDisplayName, startFrom, queryPageSize, methodName)) != null) {
            ArrayList<RelatedAsset> relatedAssets = new ArrayList<RelatedAsset>();
            for (Relationship relationship : assetRelationships) {
                EntityProxy relatedEntityProxy;
                if (relationship == null || (relatedEntityProxy = this.repositoryHandler.getOtherEnd(anchorGUID, relationship)) == null || !this.repositoryHelper.isTypeOf(serviceName, relatedEntityProxy.getType().getTypeDefName(), "Asset")) continue;
                RelatedAsset relatedAsset = new RelatedAsset();
                relatedAsset.setTypeName(relatedEntityProxy.getType().getTypeDefName());
                relatedAsset.setAttributeName(this.repositoryHelper.getOtherEndName(serviceName, anchorGUID, relationship));
                relatedAsset.setRelatedAsset(this.getAsset(userId, supportedZones, relatedEntityProxy.getGUID(), serviceName, methodName));
                relatedAssets.add(relatedAsset);
            }
            if (relatedAssets.isEmpty()) {
                return null;
            }
            return relatedAssets;
        }
        return null;
    }

    public int getRelatedMediaReferenceCount(String userId, String anchorGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.relatedMediaHandler.countRelatedMedia(userId, anchorGUID, methodName);
    }

    public SchemaType getSchemaType(String userId, String anchorGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.schemaTypeHandler.getSchemaTypeForAsset(userId, anchorGUID, methodName);
    }
}

