/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers;

import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.LastAttachmentBuilder;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.LastAttachmentConverter;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.properties.LastAttachment;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class LastAttachmentHandler {
    private String localServerUserId;
    private String serviceName;
    private OMRSRepositoryHelper repositoryHelper;
    private String serverName;
    private RepositoryHandler repositoryHandler;

    public LastAttachmentHandler(String serviceName, String serverName, String localServerUserId, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper) {
        this.serviceName = serviceName;
        this.repositoryHelper = repositoryHelper;
        this.serverName = serverName;
        this.localServerUserId = localServerUserId;
        this.repositoryHandler = repositoryHandler;
    }

    private void addLastAttachment(String anchorGUID, String anchorType, String attachmentGUID, String attachmentType, String attachmentOwner, String description, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        LastAttachmentBuilder builder = new LastAttachmentBuilder(anchorGUID, anchorType, attachmentGUID, attachmentType, attachmentOwner, description, this.repositoryHelper, this.serviceName, this.serverName);
        String entityGUID = this.repositoryHandler.createEntity(this.localServerUserId, "ba3c8dfa-42a5-492c-bebc-88fa7492e75a", "LastAttachment", builder.getInstanceProperties(methodName), methodName);
        this.repositoryHandler.createRelationship(this.localServerUserId, "57e3687e-393e-4c0c-a4f1-a6634075465b", anchorGUID, entityGUID, null, methodName);
    }

    void updateLastAttachment(String anchorGUID, String anchorType, String attachmentGUID, String attachmentType, String attachmentOwner, String description, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail entity = this.repositoryHandler.getEntityForRelationshipType(this.localServerUserId, anchorGUID, anchorType, "57e3687e-393e-4c0c-a4f1-a6634075465b", "LastAttachmentLink", methodName);
        if (entity == null) {
            this.addLastAttachment(anchorGUID, anchorType, attachmentGUID, attachmentType, attachmentOwner, description, methodName);
        } else {
            LastAttachmentBuilder builder = new LastAttachmentBuilder(anchorGUID, anchorType, attachmentGUID, attachmentType, attachmentOwner, description, this.repositoryHelper, this.serviceName, this.serverName);
            this.repositoryHandler.updateEntity(this.localServerUserId, entity.getGUID(), "ba3c8dfa-42a5-492c-bebc-88fa7492e75a", "LastAttachment", builder.getInstanceProperties(methodName), methodName);
        }
    }

    LastAttachment getLastAttachment(String anchorGUID, String anchorTypeName, String methodName) throws PropertyServerException, UserNotAuthorizedException {
        LastAttachment lastAttachment = null;
        EntityDetail entity = this.repositoryHandler.getEntityForRelationshipType(this.localServerUserId, anchorGUID, anchorTypeName, "57e3687e-393e-4c0c-a4f1-a6634075465b", "LastAttachmentLink", methodName);
        if (entity != null) {
            LastAttachmentConverter converter = new LastAttachmentConverter(entity, this.repositoryHelper, this.serviceName);
            lastAttachment = converter.getBean();
        }
        return lastAttachment;
    }
}

