/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.BoundedSchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.ComplexSchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.PrimitiveSchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.SchemaAttributeBuilder;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.SchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.SchemaAttributeConverter;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.SchemaTypeConverter;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.LastAttachmentHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.BoundedSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ComplexSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementOrigin;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.PrimitiveSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttribute;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaElement;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SchemaTypeHandler {
    private String serviceName;
    private String serverName;
    private OMRSRepositoryHelper repositoryHelper;
    private RepositoryHandler repositoryHandler;
    private InvalidParameterHandler invalidParameterHandler;
    private LastAttachmentHandler lastAttachmentHandler;

    public SchemaTypeHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, LastAttachmentHandler lastAttachmentHandler) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHandler = repositoryHandler;
        this.repositoryHelper = repositoryHelper;
        this.lastAttachmentHandler = lastAttachmentHandler;
    }

    private void setElementType(String schemaTypeGUID, String schemaTypeName, SchemaElement bean) {
        ElementType elementType = new ElementType();
        elementType.setElementOrigin(ElementOrigin.LOCAL_COHORT);
        elementType.setElementTypeId(schemaTypeGUID);
        elementType.setElementTypeName(schemaTypeName);
        bean.setType(elementType);
    }

    public ComplexSchemaType getEmptyComplexSchemaType(String schemaTypeGUID, String schemaTypeName) {
        ComplexSchemaType schemaType = new ComplexSchemaType();
        this.setElementType(schemaTypeGUID, schemaTypeName, (SchemaElement)schemaType);
        return schemaType;
    }

    public PrimitiveSchemaType getEmptyPrimitiveSchemaType(String schemaTypeGUID, String schemaTypeName) {
        PrimitiveSchemaType schemaType = new PrimitiveSchemaType();
        this.setElementType(schemaTypeGUID, schemaTypeName, (SchemaElement)schemaType);
        return schemaType;
    }

    public SchemaAttribute getEmptySchemaAttribute() {
        SchemaAttribute schemaAttribute = new SchemaAttribute();
        this.setElementType("1a5e159b-913a-43b1-95fe-04433b25fca9", "SchemaAttribute", (SchemaElement)schemaAttribute);
        return schemaAttribute;
    }

    public SchemaAttribute getEmptyTabularColumn() {
        SchemaAttribute schemaAttribute = new SchemaAttribute();
        this.setElementType("d81a0425-4e9b-4f31-bc1c-e18c3566da10", "TabularColumn", (SchemaElement)schemaAttribute);
        return schemaAttribute;
    }

    public SchemaType getSchemaTypeForAsset(String userId, String anchorGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getSchemaTypeForAnchor(userId, anchorGUID, "Asset", "815b004d-73c6-4728-9dd9-536f4fe803cd", "AssetSchemaType", methodName);
    }

    public SchemaType getSchemaTypeForAttribute(String userId, String anchorGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getSchemaTypeForAnchor(userId, anchorGUID, "SchemaAttribute", "2d955049-e59b-45dd-8e62-cde1add59f9e", "SchemaAttributeType", methodName);
    }

    private SchemaType getSchemaTypeForAnchor(String userId, String anchorGUID, String anchorTypeName, String relationshipTypeGUID, String relationshipTypeName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail schemaTypeEntity = this.repositoryHandler.getEntityForRelationshipType(userId, anchorGUID, anchorTypeName, relationshipTypeGUID, relationshipTypeName, methodName);
        if (schemaTypeEntity != null) {
            int attributeCount = 0;
            if (schemaTypeEntity.getType() != null && this.repositoryHelper.isTypeOf(this.serviceName, schemaTypeEntity.getType().getTypeDefName(), "ComplexSchemaType")) {
                attributeCount = this.countSchemaAttributes(userId, schemaTypeEntity.getGUID(), methodName);
            }
            SchemaTypeConverter converter = new SchemaTypeConverter(schemaTypeEntity, attributeCount, this.repositoryHelper, this.serviceName);
            return converter.getBean();
        }
        return null;
    }

    public SchemaType getTabularSchemaType(String anchorQualifiedName, String anchorDisplayName, String author, String encodingStandard, List<String> columnHeaders) {
        ComplexSchemaType tableSchemaType = this.getEmptyComplexSchemaType("248975ec-8019-4b8a-9caf-084c8b724233", "TabularSchemaType");
        if (columnHeaders != null) {
            tableSchemaType.setAttributeCount(columnHeaders.size());
        }
        tableSchemaType.setQualifiedName(anchorQualifiedName + ":TabularSchema");
        tableSchemaType.setDisplayName(anchorDisplayName + " Tabular Schema");
        tableSchemaType.setAuthor(author);
        tableSchemaType.setVersionNumber("1.0");
        tableSchemaType.setEncodingStandard(encodingStandard);
        return tableSchemaType;
    }

    public List<SchemaAttribute> getTabularSchemaColumns(String parentSchemaQualifiedName, List<String> columnHeaders) {
        ArrayList<SchemaAttribute> tableColumns = new ArrayList<SchemaAttribute>();
        if (columnHeaders != null) {
            int positionCount = 0;
            for (String columnName : columnHeaders) {
                if (columnName == null) continue;
                SchemaAttribute schemaAttribute = this.getEmptySchemaAttribute();
                schemaAttribute.setQualifiedName(parentSchemaQualifiedName + ":Column:" + columnName);
                schemaAttribute.setAttributeName(columnName);
                schemaAttribute.setCardinality("1");
                schemaAttribute.setElementPosition(positionCount);
                tableColumns.add(schemaAttribute);
                ++positionCount;
            }
        }
        if (tableColumns.isEmpty()) {
            return null;
        }
        return tableColumns;
    }

    public int countSchemaAttributes(String userId, String schemaTypeGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "schemaTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", methodName);
        return this.repositoryHandler.countAttachedRelationshipsByType(userId, schemaTypeGUID, "ComplexSchemaType", "86b176a2-015c-44a6-8106-54d5d69ba661", "AttributeForSchema", methodName);
    }

    public List<SchemaAttribute> getSchemaAttributes(String userId, String schemaTypeGUID, int elementStart, int maxElements, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "schemaTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", methodName);
        List entities = this.repositoryHandler.getEntitiesForRelationshipType(userId, schemaTypeGUID, "SchemaType", "86b176a2-015c-44a6-8106-54d5d69ba661", "AttributeForSchema", elementStart, maxElements, methodName);
        ArrayList<SchemaAttribute> results = new ArrayList<SchemaAttribute>();
        if (entities != null) {
            for (EntityDetail schemaAttributeEntity : entities) {
                if (schemaAttributeEntity == null) continue;
                EntityDetail attributeTypeEntity = this.repositoryHandler.getEntityForRelationshipType(userId, schemaAttributeEntity.getGUID(), "SchemaAttribute", "2d955049-e59b-45dd-8e62-cde1add59f9e", "SchemaAttributeType", methodName);
                SchemaType attributeType = null;
                if (attributeTypeEntity != null) {
                    attributeType = this.getSchemaTypeForAttribute(userId, attributeTypeEntity.getGUID(), methodName);
                }
                SchemaAttributeConverter converter = new SchemaAttributeConverter(schemaAttributeEntity, attributeType, null, null, this.repositoryHelper, this.serviceName);
                results.add(converter.getBean());
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public void saveSchemaAttributes(String userId, String schemaTypeGUID, List<SchemaAttribute> schemaAttributes, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (schemaAttributes != null) {
            for (SchemaAttribute schemaAttribute : schemaAttributes) {
                if (schemaAttribute == null) continue;
                String schemaAttributeGUID = this.findSchemaAttribute(userId, schemaAttribute, methodName);
                if (schemaAttributeGUID == null) {
                    schemaAttributeGUID = this.addSchemaAttribute(userId, schemaAttribute);
                    this.repositoryHandler.createRelationship(userId, "86b176a2-015c-44a6-8106-54d5d69ba661", schemaTypeGUID, schemaAttributeGUID, null, methodName);
                    continue;
                }
                this.updateSchemaAttribute(userId, schemaAttributeGUID, schemaAttribute);
            }
        }
    }

    public void saveExternalSchemaAttributes(String userId, String schemaTypeGUID, List<SchemaAttribute> schemaAttributes, String externalSourceGUID, String externalSourceName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (schemaAttributes != null) {
            for (SchemaAttribute schemaAttribute : schemaAttributes) {
                if (schemaAttribute == null) continue;
                String schemaAttributeGUID = this.findSchemaAttribute(userId, schemaAttribute, methodName);
                if (schemaAttributeGUID == null) {
                    schemaAttributeGUID = this.addExternalSchemaAttribute(userId, schemaAttribute, externalSourceGUID, externalSourceName);
                    this.repositoryHandler.createExternalRelationship(userId, "86b176a2-015c-44a6-8106-54d5d69ba661", externalSourceGUID, externalSourceName, schemaTypeGUID, schemaAttributeGUID, null, methodName);
                    continue;
                }
                this.updateSchemaAttribute(userId, schemaAttributeGUID, schemaAttribute);
            }
        }
    }

    private String findSchemaAttribute(String userId, String schemaAttributeGUID, String qualifiedName, String attributeName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "schemaAttributeGUID";
        String qualifiedNameParameter = "qualifiedName";
        if (schemaAttributeGUID != null && this.repositoryHandler.isEntityKnown(userId, schemaAttributeGUID, "SchemaAttribute", methodName, "schemaAttributeGUID") != null) {
            return schemaAttributeGUID;
        }
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        SchemaAttributeBuilder builder = new SchemaAttributeBuilder(qualifiedName, attributeName, this.repositoryHelper, this.serviceName, this.serverName);
        EntityDetail existingSchemaType = this.repositoryHandler.getUniqueEntityByName(userId, qualifiedName, "qualifiedName", builder.getQualifiedNameInstanceProperties(methodName), "1a5e159b-913a-43b1-95fe-04433b25fca9", "SchemaAttribute", methodName);
        if (existingSchemaType != null) {
            return existingSchemaType.getGUID();
        }
        return null;
    }

    private String findSchemaAttribute(String userId, SchemaAttribute schemaAttribute, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (schemaAttribute != null) {
            return this.findSchemaAttribute(userId, schemaAttribute.getGUID(), schemaAttribute.getQualifiedName(), schemaAttribute.getAttributeName(), methodName);
        }
        return null;
    }

    private String addSchemaAttribute(String userId, SchemaAttribute schemaAttribute) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addSchemaAttribute";
        SchemaAttributeBuilder builder = this.getSchemaAttributeBuilder(schemaAttribute);
        return this.repositoryHandler.createEntity(userId, this.getSchemaAttributeTypeGUID(schemaAttribute), this.getSchemaAttributeTypeName(schemaAttribute), builder.getInstanceProperties("addSchemaAttribute"), "addSchemaAttribute");
    }

    private String addExternalSchemaAttribute(String userId, SchemaAttribute schemaAttribute, String externalSourceGUID, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addExternalSchemaAttribute";
        SchemaAttributeBuilder builder = this.getSchemaAttributeBuilder(schemaAttribute);
        return this.repositoryHandler.createExternalEntity(userId, this.getSchemaAttributeTypeGUID(schemaAttribute), this.getSchemaAttributeTypeName(schemaAttribute), externalSourceGUID, externalSourceName, builder.getInstanceProperties("addExternalSchemaAttribute"), "addExternalSchemaAttribute");
    }

    private String updateSchemaAttribute(String userId, String existingSchemaAttributeGUID, SchemaAttribute schemaAttribute) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateSchemaAttribute";
        SchemaAttributeBuilder builder = this.getSchemaAttributeBuilder(schemaAttribute);
        this.repositoryHandler.updateEntity(userId, existingSchemaAttributeGUID, this.getSchemaAttributeTypeGUID(schemaAttribute), this.getSchemaAttributeTypeName(schemaAttribute), builder.getInstanceProperties("updateSchemaAttribute"), "updateSchemaAttribute");
        return existingSchemaAttributeGUID;
    }

    private SchemaAttributeBuilder getSchemaAttributeBuilder(SchemaAttribute schemaAttribute) {
        if (schemaAttribute != null) {
            return new SchemaAttributeBuilder(schemaAttribute.getQualifiedName(), schemaAttribute.getAttributeName(), schemaAttribute.getElementPosition(), schemaAttribute.getCardinality(), schemaAttribute.getDefaultValueOverride(), schemaAttribute.getAdditionalProperties(), schemaAttribute.getExtendedProperties(), this.repositoryHelper, this.serviceName, this.serverName);
        }
        return null;
    }

    private String getSchemaAttributeTypeGUID(SchemaAttribute schemaAttribute) {
        ElementType type = schemaAttribute.getType();
        if (type != null) {
            return type.getElementTypeId();
        }
        return "1a5e159b-913a-43b1-95fe-04433b25fca9";
    }

    private String getSchemaAttributeTypeName(SchemaAttribute schemaAttribute) {
        ElementType type = schemaAttribute.getType();
        if (type != null) {
            return type.getElementTypeName();
        }
        return "SchemaAttribute";
    }

    private String findSchemaType(String userId, String schemaTypeGUID, String qualifiedName, String displayName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "schemaTypeGUID";
        String qualifiedNameParameter = "qualifiedName";
        if (schemaTypeGUID != null && this.repositoryHandler.isEntityKnown(userId, schemaTypeGUID, "SchemaType", methodName, "schemaTypeGUID") != null) {
            return schemaTypeGUID;
        }
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, this.repositoryHelper, this.serviceName, this.serverName);
        EntityDetail existingSchemaType = this.repositoryHandler.getUniqueEntityByName(userId, qualifiedName, "qualifiedName", builder.getQualifiedNameInstanceProperties(methodName), "5bd4a3e7-d22d-4a3d-a115-066ee8e0754f", "SchemaType", methodName);
        if (existingSchemaType != null) {
            return existingSchemaType.getGUID();
        }
        return null;
    }

    private String findSchemaType(String userId, SchemaType schemaType, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (schemaType != null) {
            return this.findSchemaType(userId, schemaType.getGUID(), schemaType.getQualifiedName(), schemaType.getDisplayName(), methodName);
        }
        return null;
    }

    public String saveSchemaType(String userId, SchemaType schemaType, List<SchemaAttribute> schemaAttributes, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String schemaTypeGUID = this.findSchemaType(userId, schemaType, methodName);
        if (schemaTypeGUID == null) {
            schemaTypeGUID = this.addSchemaType(userId, schemaType);
        } else {
            this.updateSchemaType(userId, schemaTypeGUID, schemaType);
        }
        if (schemaAttributes != null) {
            this.saveSchemaAttributes(userId, schemaTypeGUID, schemaAttributes, methodName);
        }
        return schemaTypeGUID;
    }

    public String saveExternalSchemaType(String userId, SchemaType schemaType, List<SchemaAttribute> schemaAttributes, String externalSourceGUID, String externalSourceName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String schemaTypeGUID = this.findSchemaType(userId, schemaType, methodName);
        if (schemaTypeGUID == null) {
            schemaTypeGUID = this.addExternalSchemaType(userId, schemaType, externalSourceGUID, externalSourceName);
        } else {
            this.updateSchemaType(userId, schemaTypeGUID, schemaType);
        }
        if (schemaAttributes != null) {
            this.saveExternalSchemaAttributes(userId, schemaTypeGUID, schemaAttributes, externalSourceGUID, externalSourceName, methodName);
        }
        return schemaTypeGUID;
    }

    private String addSchemaType(String userId, SchemaType schemaType) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addSchemaType";
        SchemaTypeBuilder schemaTypeBuilder = this.getSchemaTypeBuilder(schemaType);
        return this.repositoryHandler.createEntity(userId, this.getSchemaTypeTypeGUID(schemaType), this.getSchemaTypeTypeName(schemaType), schemaTypeBuilder.getInstanceProperties("addSchemaType"), "addSchemaType");
    }

    private String addExternalSchemaType(String userId, SchemaType schemaType, String externalSourceGUID, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addExternalSchemaType";
        SchemaTypeBuilder schemaTypeBuilder = this.getSchemaTypeBuilder(schemaType);
        return this.repositoryHandler.createExternalEntity(userId, this.getSchemaTypeTypeGUID(schemaType), this.getSchemaTypeTypeName(schemaType), externalSourceGUID, externalSourceName, schemaTypeBuilder.getInstanceProperties("addExternalSchemaType"), "addExternalSchemaType");
    }

    private String updateSchemaType(String userId, String existingSchemaTypeGUID, SchemaType schemaType) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateSchemaType";
        SchemaTypeBuilder schemaTypeBuilder = this.getSchemaTypeBuilder(schemaType);
        this.repositoryHandler.updateEntity(userId, existingSchemaTypeGUID, this.getSchemaTypeTypeGUID(schemaType), this.getSchemaTypeTypeName(schemaType), schemaTypeBuilder.getInstanceProperties("updateSchemaType"), "updateSchemaType");
        return existingSchemaTypeGUID;
    }

    private String getSchemaTypeTypeGUID(SchemaType schemaType) {
        ElementType type = schemaType.getType();
        if (type != null) {
            return type.getElementTypeId();
        }
        return "5bd4a3e7-d22d-4a3d-a115-066ee8e0754f";
    }

    private String getSchemaTypeTypeName(SchemaType schemaType) {
        ElementType type = schemaType.getType();
        if (type != null) {
            return type.getElementTypeName();
        }
        return "SchemaType";
    }

    private SchemaTypeBuilder getBoundedSchemaTypeBuilder(BoundedSchemaType schemaType) {
        return new BoundedSchemaTypeBuilder(schemaType.getQualifiedName(), schemaType.getDisplayName(), schemaType.getVersionNumber(), schemaType.getAuthor(), schemaType.getUsage(), schemaType.getEncodingStandard(), schemaType.getMaximumElements(), schemaType.getAdditionalProperties(), schemaType.getExtendedProperties(), this.repositoryHelper, this.serviceName, this.serverName);
    }

    private SchemaTypeBuilder getComplexSchemaTypeBuilder(ComplexSchemaType schemaType) {
        return new ComplexSchemaTypeBuilder(schemaType.getQualifiedName(), schemaType.getDisplayName(), schemaType.getVersionNumber(), schemaType.getAuthor(), schemaType.getUsage(), schemaType.getEncodingStandard(), schemaType.getAdditionalProperties(), schemaType.getExtendedProperties(), this.repositoryHelper, this.serviceName, this.serverName);
    }

    private SchemaTypeBuilder getPrimitiveSchemaTypeBuilder(PrimitiveSchemaType schemaType) {
        return new PrimitiveSchemaTypeBuilder(schemaType.getQualifiedName(), schemaType.getDisplayName(), schemaType.getVersionNumber(), schemaType.getAuthor(), schemaType.getUsage(), schemaType.getEncodingStandard(), schemaType.getDataType(), schemaType.getDefaultValue(), schemaType.getAdditionalProperties(), schemaType.getExtendedProperties(), this.repositoryHelper, this.serviceName, this.serverName);
    }

    private SchemaTypeBuilder getSchemaTypeBuilder(SchemaType schemaType) {
        if (schemaType != null) {
            if (schemaType instanceof PrimitiveSchemaType) {
                return this.getPrimitiveSchemaTypeBuilder((PrimitiveSchemaType)schemaType);
            }
            if (schemaType instanceof BoundedSchemaType) {
                return this.getBoundedSchemaTypeBuilder((BoundedSchemaType)schemaType);
            }
            if (schemaType instanceof ComplexSchemaType) {
                return this.getComplexSchemaTypeBuilder((ComplexSchemaType)schemaType);
            }
            return new SchemaTypeBuilder(schemaType.getQualifiedName(), schemaType.getDisplayName(), schemaType.getVersionNumber(), schemaType.getAuthor(), schemaType.getUsage(), schemaType.getEncodingStandard(), schemaType.getAdditionalProperties(), schemaType.getExtendedProperties(), this.repositoryHelper, this.serviceName, this.serverName);
        }
        return null;
    }

    public void removeSchemaType(String userId, String schemaTypeGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeSchemaType";
        String guidParameterName = "schemaTypeGUID";
        this.repositoryHandler.removeEntityOnLastUse(userId, schemaTypeGUID, "schemaTypeGUID", "5bd4a3e7-d22d-4a3d-a115-066ee8e0754f", "SchemaType", "removeSchemaType");
    }

    public void removeSchemaAttribute(String userId, String schemaAttributeGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeSchemaAttribute";
        String guidParameterName = "schemaAttributeGUID";
        this.repositoryHandler.removeEntityOnLastUse(userId, schemaAttributeGUID, "schemaAttributeGUID", "1a5e159b-913a-43b1-95fe-04433b25fca9", "SchemaAttribute", "removeSchemaAttribute");
    }
}

