/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders;

import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.RootBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.CommentType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class CommentBuilder
extends RootBuilder {
    private CommentType commentType;
    private String commentText;
    private boolean isPublic;
    private String anchorGUID;

    public CommentBuilder(CommentType commentType, String commentText, boolean isPublic, String anchorGUID, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
        this.commentText = commentText;
        this.commentType = commentType;
        this.isPublic = isPublic;
        this.anchorGUID = anchorGUID;
    }

    public InstanceProperties getRelationshipInstanceProperties(String methodName) {
        return this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, null, "isPublic", this.isPublic, methodName);
    }

    public InstanceProperties getEntityInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.commentText != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "text", this.commentText, methodName);
        }
        if (this.anchorGUID != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "anchorGUID", this.anchorGUID, methodName);
        }
        return this.addCommentTypePropertyToInstance(properties, this.commentType, methodName);
    }

    private InstanceProperties addCommentTypePropertyToInstance(InstanceProperties properties, CommentType commentType, String methodName) {
        int ordinal = 99;
        String symbolicName = null;
        String description = null;
        boolean element1Ordinal = false;
        String element1Value = "GeneralComment";
        String element1Description = "General comment.";
        boolean element2Ordinal = true;
        String element2Value = "Question";
        String element2Description = "A question.";
        int element3Ordinal = 2;
        String element3Value = "Answer";
        String element3Description = "An answer to a previously asked question.";
        int element4Ordinal = 3;
        String element4Value = "Suggestion";
        String element4Description = "A suggestion for improvement.";
        int element5Ordinal = 4;
        String element5Value = "Experience";
        String element5Description = "An account of an experience.";
        switch (commentType) {
            case STANDARD_COMMENT: {
                ordinal = 0;
                symbolicName = "GeneralComment";
                description = "General comment.";
                break;
            }
            case QUESTION: {
                ordinal = 1;
                symbolicName = "Question";
                description = "A question.";
                break;
            }
            case ANSWER: {
                ordinal = 2;
                symbolicName = "Answer";
                description = "An answer to a previously asked question.";
                break;
            }
            case SUGGESTION: {
                ordinal = 3;
                symbolicName = "Suggestion";
                description = "A suggestion for improvement.";
                break;
            }
            case USAGE_EXPERIENCE: {
                ordinal = 4;
                symbolicName = "Experience";
                description = "An account of an experience.";
            }
        }
        return this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, "type", ordinal, symbolicName, description, methodName);
    }
}

