/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.AttachmentHandlerBase;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.LastAttachmentHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public abstract class FeedbackHandlerBase
extends AttachmentHandlerBase {
    public FeedbackHandlerBase(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, LastAttachmentHandler lastAttachmentHandler) {
        super(serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, lastAttachmentHandler);
    }

    protected boolean visibleToUser(String userId, Relationship relationship, String methodName) {
        if (userId.equals(relationship.getCreatedBy())) {
            return true;
        }
        return this.repositoryHelper.getBooleanProperty(this.serviceName, "isPublic", relationship.getProperties(), methodName);
    }

    @Override
    protected int countAttachments(String userId, String anchorGUID, String anchorTypeName, String attachmentTypeGUID, String attachmentTypeName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "anchorGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(anchorGUID, "anchorGUID", methodName);
        List relationships = this.repositoryHandler.getRelationshipsByType(userId, anchorGUID, anchorTypeName, attachmentTypeGUID, attachmentTypeName, methodName);
        int count = 0;
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (relationship == null || !this.visibleToUser(userId, relationship, methodName)) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public List<Relationship> getAttachmentLinks(String userId, String anchorGUID, String anchorTypeName, String attachmentTypeGUID, String attachmentTypeName, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<Relationship> relationships = super.getAttachmentLinks(userId, anchorGUID, anchorTypeName, attachmentTypeGUID, attachmentTypeName, startingFrom, pageSize, methodName);
        if (relationships != null) {
            ArrayList<Relationship> visibleRelationships = new ArrayList<Relationship>();
            for (Relationship relationship : relationships) {
                if (!this.visibleToUser(userId, relationship, methodName)) continue;
                visibleRelationships.add(relationship);
            }
            if (!visibleRelationships.isEmpty()) {
                return visibleRelationships;
            }
        }
        return null;
    }

    @Override
    public List<EntityDetail> getAttachments(String userId, String anchorGUID, String anchorTypeName, boolean anchorAtEnd1, String attachmentTypeGUID, String attachmentTypeName, String entityTypeName, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<Relationship> visibleRelationships = this.getAttachmentLinks(userId, anchorGUID, anchorTypeName, attachmentTypeGUID, attachmentTypeName, startingFrom, pageSize, methodName);
        if (visibleRelationships != null) {
            ArrayList<EntityDetail> visibleEntities = new ArrayList<EntityDetail>();
            for (Relationship relationship : visibleRelationships) {
                if (!this.visibleToUser(userId, relationship, methodName)) continue;
                EntityProxy entityProxy = relationship.getEntityTwoProxy();
                if (!anchorAtEnd1) {
                    entityProxy = relationship.getEntityOneProxy();
                }
                String guidParameterName = "entityProxy.getGUID()";
                visibleEntities.add(this.repositoryHandler.getEntityByGUID(userId, entityProxy.getGUID(), "entityProxy.getGUID()", entityTypeName, methodName));
            }
            if (!visibleEntities.isEmpty()) {
                return visibleEntities;
            }
        }
        return null;
    }
}

