/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters;

import java.util.List;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.ReferenceableConverter;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.EmbeddedConnection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Referenceable;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.VirtualConnection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ConnectionConverter
extends ReferenceableConverter {
    private List<EmbeddedConnection> embeddedConnections;
    private Endpoint endpoint;
    private ConnectorType connectorType;

    public ConnectionConverter(EntityDetail connectionEntity, Endpoint endpoint, ConnectorType connectorType, List<EmbeddedConnection> embeddedConnections, OMRSRepositoryHelper repositoryHelper, String serviceName) {
        super(connectionEntity, repositoryHelper, serviceName);
        this.endpoint = endpoint;
        this.connectorType = connectorType;
        this.embeddedConnections = embeddedConnections;
    }

    public Connection getBean() {
        String methodName = "getBean";
        Connection bean = null;
        if (this.entity != null) {
            if (this.embeddedConnections == null) {
                bean = new Connection();
            } else {
                VirtualConnection virtualConnection = new VirtualConnection();
                virtualConnection.setEmbeddedConnections(this.embeddedConnections);
                bean = virtualConnection;
            }
            super.updateBean((Referenceable)bean);
            bean.setEndpoint(this.endpoint);
            bean.setConnectorType(this.connectorType);
            InstanceProperties instanceProperties = this.entity.getProperties();
            if (instanceProperties != null) {
                bean.setQualifiedName(this.repositoryHelper.removeStringProperty(this.serviceName, "qualifiedName", instanceProperties, "getBean"));
                bean.setDisplayName(this.repositoryHelper.removeStringProperty(this.serviceName, "displayName", instanceProperties, "getBean"));
                bean.setDescription(this.repositoryHelper.removeStringProperty(this.serviceName, "description", instanceProperties, "getBean"));
                bean.setUserId(this.repositoryHelper.removeStringProperty(this.serviceName, "userId", instanceProperties, "getBean"));
                bean.setClearPassword(this.repositoryHelper.removeStringProperty(this.serviceName, "clearPassword", instanceProperties, "getBean"));
                bean.setEncryptedPassword(this.repositoryHelper.removeStringProperty(this.serviceName, "encryptedPassword", instanceProperties, "getBean"));
                bean.setSecuredProperties(this.repositoryHelper.removeMapFromProperty(this.serviceName, "securedProperties", instanceProperties, "getBean"));
                bean.setConfigurationProperties(this.repositoryHelper.removeMapFromProperty(this.serviceName, "configurationProperties", instanceProperties, "getBean"));
                bean.setAdditionalProperties(this.repositoryHelper.removeStringMapFromProperty(this.serviceName, "additionalProperties", instanceProperties, "getBean"));
                bean.setExtendedProperties(this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties));
            }
        }
        return bean;
    }
}

