/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters;

import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.ElementHeaderConverter;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.LiteralSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaLink;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SchemaLinkConverter
extends ElementHeaderConverter {
    public SchemaLinkConverter(EntityDetail entity, Relationship linkedTypeRelationship, OMRSRepositoryHelper repositoryHelper, String serviceName) {
        super(entity, linkedTypeRelationship, repositoryHelper, serviceName);
        InstanceType type;
        if (entity != null && (type = entity.getType()) != null) {
            this.typeName = type.getTypeDefName();
        }
    }

    public SchemaLink getBean() {
        String methodName = "getBean";
        SchemaLink bean = null;
        if (this.entity != null) {
            EntityProxy end2;
            bean = new SchemaLink();
            InstanceProperties instanceProperties = this.entity.getProperties();
            if (instanceProperties != null) {
                bean.setQualifiedName(this.repositoryHelper.removeStringProperty(this.serviceName, "qualifiedName", instanceProperties, "getBean"));
                bean.setDisplayName(this.repositoryHelper.removeStringProperty(this.serviceName, "displayName", instanceProperties, "getBean"));
                bean.setDescription(this.repositoryHelper.removeStringProperty(this.serviceName, "description", instanceProperties, "getBean"));
                bean.setDeprecated(this.repositoryHelper.removeBooleanProperty(this.serviceName, "isDeprecated", instanceProperties, "getBean"));
                bean.setLinkName(this.repositoryHelper.removeStringProperty(this.serviceName, "linkName", instanceProperties, "getBean"));
                bean.setLinkProperties(this.repositoryHelper.removeStringMapFromProperty(this.serviceName, "linkProperties", instanceProperties, "getBean"));
                bean.setAdditionalProperties(this.repositoryHelper.removeStringMapFromProperty(this.serviceName, "additionalProperties", instanceProperties, "getBean"));
                bean.setExtendedProperties(this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties));
            }
            bean.setLinkType(this.typeName);
            if (this.relationship != null && (end2 = this.relationship.getEntityTwoProxy()) != null) {
                bean.setLinkedSchemaTypeGUID(end2.getGUID());
                if (end2.getType() != null) {
                    bean.setLinkedSchemaTypeName(end2.getType().getTypeDefName());
                }
            }
        }
        return bean;
    }

    private void updateBasicSchemaTypeProperties(SchemaType bean, InstanceProperties instanceProperties, String methodName) {
        if (instanceProperties != null) {
            bean.setQualifiedName(this.repositoryHelper.removeStringProperty(this.serviceName, "qualifiedName", instanceProperties, methodName));
            bean.setDisplayName(this.repositoryHelper.removeStringProperty(this.serviceName, "displayName", instanceProperties, methodName));
            bean.setVersionNumber(this.repositoryHelper.removeStringProperty(this.serviceName, "versionNumber", instanceProperties, methodName));
            bean.setAuthor(this.repositoryHelper.removeStringProperty(this.serviceName, "author", instanceProperties, methodName));
            bean.setUsage(this.repositoryHelper.removeStringProperty(this.serviceName, "usage", instanceProperties, methodName));
            bean.setEncodingStandard(this.repositoryHelper.removeStringProperty(this.serviceName, "encodingStandard", instanceProperties, methodName));
            bean.setAdditionalProperties(this.repositoryHelper.removeStringMapFromProperty(this.serviceName, "additionalProperties", instanceProperties, methodName));
        }
    }

    private void updateLiteralSchemaTypeProperties(LiteralSchemaType bean, InstanceProperties instanceProperties, String methodName) {
        if (instanceProperties != null) {
            this.updateBasicSchemaTypeProperties((SchemaType)bean, instanceProperties, methodName);
            bean.setDataType(this.repositoryHelper.removeStringProperty(this.serviceName, "dataType", instanceProperties, methodName));
            bean.setFixedValue(this.repositoryHelper.removeStringProperty(this.serviceName, "fixedValue", instanceProperties, methodName));
        }
    }
}

