/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters;

import java.util.Map;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.ReferenceableConverter;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.DataItemSortOrder;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Referenceable;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ValidValue;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ValidValueDefinition;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ValidValueSet;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ValidValuesConverter
extends ReferenceableConverter {
    public ValidValuesConverter(EntityDetail mainEntity, OMRSRepositoryHelper repositoryHelper, String serviceName) {
        super(mainEntity, repositoryHelper, serviceName);
    }

    public ValidValue getBean() {
        String methodName = "getBean";
        Object bean = null;
        if (this.entity != null) {
            bean = this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "ValidValueSet") ? new ValidValueSet() : new ValidValueDefinition();
            super.updateBean((Referenceable)bean);
            InstanceProperties instanceProperties = this.entity.getProperties();
            if (instanceProperties != null) {
                bean.setQualifiedName(this.repositoryHelper.removeStringProperty(this.serviceName, "qualifiedName", instanceProperties, "getBean"));
                bean.setDisplayName(this.repositoryHelper.removeStringProperty(this.serviceName, "name", instanceProperties, "getBean"));
                bean.setDescription(this.repositoryHelper.removeStringProperty(this.serviceName, "description", instanceProperties, "getBean"));
                bean.setDeprecated(this.repositoryHelper.removeBooleanProperty(this.serviceName, "isDeprecated", instanceProperties, "getBean"));
                bean.setScope(this.repositoryHelper.removeStringProperty(this.serviceName, "scope", instanceProperties, "getBean"));
                bean.setUsage(this.repositoryHelper.removeStringProperty(this.serviceName, "usage", instanceProperties, "getBean"));
                bean.setPreferredValue(this.repositoryHelper.removeStringProperty(this.serviceName, "preferredValue", instanceProperties, "getBean"));
                bean.setAdditionalProperties(this.repositoryHelper.removeStringMapFromProperty(this.serviceName, "additionalProperties", instanceProperties, "getBean"));
                bean.setExtendedProperties(this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties));
            }
        }
        return bean;
    }

    private DataItemSortOrder getSortOrderFromProperties(InstanceProperties properties) {
        InstancePropertyValue instancePropertyValue;
        Map instancePropertiesMap;
        DataItemSortOrder sortOrder = DataItemSortOrder.UNKNOWN;
        if (properties != null && (instancePropertiesMap = properties.getInstanceProperties()) != null && (instancePropertyValue = (InstancePropertyValue)instancePropertiesMap.get("sortOrder")) instanceof EnumPropertyValue) {
            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            switch (enumPropertyValue.getOrdinal()) {
                case 0: {
                    sortOrder = DataItemSortOrder.ASCENDING;
                    break;
                }
                case 1: {
                    sortOrder = DataItemSortOrder.DESCENDING;
                    break;
                }
                case 99: {
                    sortOrder = DataItemSortOrder.UNSORTED;
                }
            }
        }
        return sortOrder;
    }

    private DataItemSortOrder removeSortOrderFromProperties(InstanceProperties properties) {
        DataItemSortOrder sortOrder = this.getSortOrderFromProperties(properties);
        if (properties != null) {
            Map instancePropertiesMap = properties.getInstanceProperties();
            if (instancePropertiesMap != null) {
                instancePropertiesMap.remove("sortOrder");
            }
            properties.setInstanceProperties(instancePropertiesMap);
        }
        return sortOrder;
    }
}

