/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers;

import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.LastAttachmentHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public abstract class AttachmentHandlerBase {
    protected String serviceName;
    protected String serverName;
    protected OMRSRepositoryHelper repositoryHelper;
    protected RepositoryHandler repositoryHandler;
    protected InvalidParameterHandler invalidParameterHandler;
    protected LastAttachmentHandler lastAttachmentHandler;

    public AttachmentHandlerBase(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, LastAttachmentHandler lastAttachmentHandler) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHandler = repositoryHandler;
        this.repositoryHelper = repositoryHelper;
        this.lastAttachmentHandler = lastAttachmentHandler;
    }

    protected int countAttachments(String userId, String anchorGUID, String anchorTypeName, String attachmentTypeGUID, String attachmentTypeName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "anchorGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(anchorGUID, "anchorGUID", methodName);
        List relationships = this.repositoryHandler.getRelationshipsByType(userId, anchorGUID, anchorTypeName, attachmentTypeGUID, attachmentTypeName, methodName);
        int count = 0;
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (relationship == null) continue;
                ++count;
            }
        }
        return count;
    }

    public List<Relationship> getAttachmentLinks(String userId, String anchorGUID, String anchorTypeName, String attachmentTypeGUID, String attachmentTypeName, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameter = "anchorGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(anchorGUID, "anchorGUID", methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startingFrom, pageSize, methodName);
        List relationships = this.repositoryHandler.getPagedRelationshipsByType(userId, anchorGUID, anchorTypeName, attachmentTypeGUID, attachmentTypeName, startingFrom, queryPageSize, methodName);
        if (relationships == null || relationships.isEmpty()) {
            return null;
        }
        return relationships;
    }

    public List<EntityDetail> getAttachments(String userId, String anchorGUID, String anchorTypeName, boolean anchorAtEnd1, String attachmentTypeGUID, String attachmentTypeName, String entityTypeName, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameter = "anchorGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(anchorGUID, "anchorGUID", methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startingFrom, pageSize, methodName);
        List entities = this.repositoryHandler.getEntitiesForRelationshipEnd(userId, anchorGUID, anchorTypeName, anchorAtEnd1, attachmentTypeGUID, attachmentTypeName, startingFrom, queryPageSize, methodName);
        if (entities == null || entities.isEmpty()) {
            return null;
        }
        return entities;
    }
}

