/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.LicenseConverter;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.AttachmentHandlerBase;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.LastAttachmentHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.License;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class LicenseHandler
extends AttachmentHandlerBase {
    public LicenseHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, LastAttachmentHandler lastAttachmentHandler) {
        super(serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, lastAttachmentHandler);
    }

    public int countLicenses(String userId, String anchorGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return super.countAttachments(userId, anchorGUID, "Referenceable", "35e53b7f-2312-4d66-ae90-2d4cb47901ee", "License", methodName);
    }

    public List<License> getLicenses(String userId, String anchorGUID, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "anchorGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(anchorGUID, "anchorGUID", methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startingFrom, pageSize, methodName);
        List relationships = this.repositoryHandler.getPagedRelationshipsByType(userId, anchorGUID, "Referenceable", "35e53b7f-2312-4d66-ae90-2d4cb47901ee", "License", startingFrom, queryPageSize, methodName);
        if (relationships != null) {
            ArrayList<License> results = new ArrayList<License>();
            for (Relationship relationship : relationships) {
                EntityProxy entityProxy;
                if (relationship == null || (entityProxy = relationship.getEntityTwoProxy()) == null) continue;
                String entityParameterName = "entityProxyTwo.getGUID";
                EntityDetail entity = this.repositoryHandler.getEntityByGUID(userId, entityProxy.getGUID(), "entityProxyTwo.getGUID", "LicenseType", methodName);
                LicenseConverter converter = new LicenseConverter(entity, relationship, this.repositoryHelper, this.serviceName);
                results.add(converter.getBean());
            }
            if (results.isEmpty()) {
                return null;
            }
            return results;
        }
        return null;
    }
}

