/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.ValidValuesBuilder;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.ValidValuesConverter;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.AssetHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.LastAttachmentHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositorySelectedEntitiesIterator;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ReferenceValueAssignedItem;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ReferenceValueAssignment;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ValidValue;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ValidValueImplementationAsset;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ValidValueImplementationDefinition;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ValidValueMapping;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ValidValuesAssignmentConsumer;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ValidValuesAssignmentDefinition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ValidValuesHandler {
    private String serviceName;
    private String serverName;
    private OMRSRepositoryHelper repositoryHelper;
    private RepositoryHandler repositoryHandler;
    private InvalidParameterHandler invalidParameterHandler;
    private LastAttachmentHandler lastAttachmentHandler;
    private AssetHandler assetHandler = null;

    public ValidValuesHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, LastAttachmentHandler lastAttachmentHandler) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHandler = repositoryHandler;
        this.repositoryHelper = repositoryHelper;
        this.lastAttachmentHandler = lastAttachmentHandler;
    }

    public void setAssetHandler(AssetHandler assetHandler) {
        this.assetHandler = assetHandler;
    }

    public String createValidValueSet(String userId, String qualifiedName, String displayName, String description, String usage, String scope, boolean isDeprecated, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameParameter = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        ValidValuesBuilder builder = new ValidValuesBuilder(qualifiedName, displayName, description, usage, scope, null, isDeprecated, additionalProperties, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        return this.repositoryHandler.createEntity(userId, "7de10805-7c44-40e3-a410-ffc51306801b", "ValidValueSet", builder.getInstanceProperties(methodName), methodName);
    }

    public String createValidValueDefinition(String userId, String setGUID, String qualifiedName, String displayName, String description, String usage, String scope, String preferredValue, boolean isDeprecated, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameParameter = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        ValidValuesBuilder builder = new ValidValuesBuilder(qualifiedName, displayName, description, usage, scope, preferredValue, isDeprecated, additionalProperties, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        String definitionGUID = this.repositoryHandler.createEntity(userId, "09b2133a-f045-42cc-bb00-ee602b74c618", "ValidValueDefinition", builder.getInstanceProperties(methodName), methodName);
        if (definitionGUID != null && setGUID != null) {
            this.repositoryHandler.createRelationship(userId, "6337c9cd-8e5a-461b-97f9-5151bcb97a9e", setGUID, definitionGUID, null, methodName);
        }
        return definitionGUID;
    }

    public String createExternalValidValueSet(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, String usage, String scope, boolean isDeprecated, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameParameter = "qualifiedName";
        String externalSourceGUIDParameter = "externalSourceGUID";
        String externalSourceNameParameter = "externalSourceName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(externalSourceGUID, "externalSourceGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.invalidParameterHandler.validateName(externalSourceName, "externalSourceName", methodName);
        ValidValuesBuilder builder = new ValidValuesBuilder(qualifiedName, displayName, description, usage, scope, null, isDeprecated, additionalProperties, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        return this.repositoryHandler.createExternalEntity(userId, "7de10805-7c44-40e3-a410-ffc51306801b", "ValidValueSet", externalSourceGUID, externalSourceName, builder.getInstanceProperties(methodName), methodName);
    }

    public String createExternalValidValueDefinition(String userId, String externalSourceGUID, String externalSourceName, String setGUID, String qualifiedName, String displayName, String description, String usage, String scope, String preferredValue, boolean isDeprecated, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameParameter = "qualifiedName";
        String externalSourceGUIDParameter = "externalSourceGUID";
        String externalSourceNameParameter = "externalSourceName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(externalSourceGUID, "externalSourceGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.invalidParameterHandler.validateName(externalSourceName, "externalSourceName", methodName);
        ValidValuesBuilder builder = new ValidValuesBuilder(qualifiedName, displayName, description, usage, scope, preferredValue, isDeprecated, additionalProperties, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        String definitionGUID = this.repositoryHandler.createExternalEntity(userId, "09b2133a-f045-42cc-bb00-ee602b74c618", "ValidValueDefinition", externalSourceGUID, externalSourceName, builder.getInstanceProperties(methodName), methodName);
        if (definitionGUID != null && setGUID != null) {
            this.repositoryHandler.createExternalRelationship(userId, "6337c9cd-8e5a-461b-97f9-5151bcb97a9e", externalSourceGUID, externalSourceName, setGUID, definitionGUID, null, methodName);
        }
        return definitionGUID;
    }

    public void updateValidValue(String userId, String validValueGUID, String qualifiedName, String displayName, String description, String usage, String scope, String preferredValue, boolean isDeprecated, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameter = "validValueGUID";
        String nameParameter = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        ValidValuesBuilder builder = new ValidValuesBuilder(qualifiedName, displayName, description, usage, scope, preferredValue, isDeprecated, additionalProperties, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        this.repositoryHandler.updateEntity(userId, validValueGUID, "09b2133a-f045-42cc-bb00-ee602b74c618", "ValidValueDefinition", builder.getInstanceProperties(methodName), methodName);
    }

    public void deleteValidValue(String userId, String validValueGUID, String qualifiedName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameter = "validValueGUID";
        String nameParameter = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.repositoryHandler.removeEntity(userId, validValueGUID, "09b2133a-f045-42cc-bb00-ee602b74c618", "ValidValueDefinition", "qualifiedName", qualifiedName, methodName);
    }

    public void attachValidValueToSet(String userId, String setGUID, String validValueGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String setGUIDParameter = "setGUID";
        String validValueGUIDParameter = "validValueGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(setGUID, "setGUID", methodName);
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", methodName);
        this.repositoryHandler.createRelationship(userId, "6337c9cd-8e5a-461b-97f9-5151bcb97a9e", setGUID, validValueGUID, null, methodName);
    }

    public void detachValidValueFromSet(String userId, String setGUID, String validValueGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String setGUIDParameter = "setGUID";
        String validValueGUIDParameter = "validValueGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(setGUID, "setGUID", methodName);
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", methodName);
        this.repositoryHandler.removeRelationshipBetweenEntities(userId, "6337c9cd-8e5a-461b-97f9-5151bcb97a9e", "ValidValuesMember", setGUID, "ValidValueSet", validValueGUID, methodName);
    }

    public void linkValidValueToImplementation(String userId, String validValueGUID, String assetGUID, String symbolicName, String implementationValue, Map<String, String> additionalValues, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValueGUIDParameter = "validValueGUID";
        String assetGUIDParameter = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", methodName);
        InstanceProperties properties = null;
        if (symbolicName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "symbolicName", symbolicName, methodName);
        }
        if (implementationValue != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "implementationValue", implementationValue, methodName);
        }
        if (additionalValues != null && !additionalValues.isEmpty()) {
            properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, "additionalValues", additionalValues, methodName);
        }
        this.repositoryHandler.createRelationship(userId, "d9a39553-6a47-4477-a217-844300c07cf2", validValueGUID, assetGUID, properties, methodName);
    }

    public void unlinkValidValueFromImplementation(String userId, String validValueGUID, String assetGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValueGUIDParameter = "validValueGUID";
        String assetGUIDParameter = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", methodName);
        this.repositoryHandler.removeRelationshipBetweenEntities(userId, "d9a39553-6a47-4477-a217-844300c07cf2", "ValidValuesImplementation", validValueGUID, "ValidValueDefinition", assetGUID, methodName);
    }

    public void assignValidValueToConsumer(String userId, String validValueGUID, String consumerGUID, boolean strictRequirement, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValueGUIDParameter = "validValueGUID";
        String consumerGUIDParameter = "consumerGUID";
        String attachmentDescription = "Attach valid value(s)";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", methodName);
        this.invalidParameterHandler.validateGUID(consumerGUID, "consumerGUID", methodName);
        InstanceProperties relationshipProperties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, null, "strictRequirement", strictRequirement, methodName);
        this.repositoryHandler.createRelationship(userId, "c5d48b73-eadd-47db-ab64-3be99b2fb32d", consumerGUID, validValueGUID, relationshipProperties, methodName);
        this.lastAttachmentHandler.updateLastAttachment(consumerGUID, "Referenceable", validValueGUID, "ValidValueDefinition", userId, "Attach valid value(s)", methodName);
    }

    public void unassignValidValueFromConsumer(String userId, String validValueGUID, String consumerGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValueGUIDParameter = "validValueGUID";
        String consumerGUIDParameter = "consumerGUID";
        String attachmentDescription = "Detach valid value(s)";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", methodName);
        this.invalidParameterHandler.validateGUID(consumerGUID, "consumerGUID", methodName);
        this.repositoryHandler.removeRelationshipBetweenEntities(userId, "c5d48b73-eadd-47db-ab64-3be99b2fb32d", "ValidValuesAssignment", consumerGUID, "Referenceable", validValueGUID, methodName);
        this.lastAttachmentHandler.updateLastAttachment(consumerGUID, "Referenceable", validValueGUID, "ValidValueDefinition", userId, "Detach valid value(s)", methodName);
    }

    public void assignReferenceValueToItem(String userId, String validValueGUID, String referenceableGUID, int confidence, String steward, String notes, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValueGUIDParameter = "validValueGUID";
        String referenceableGUIDParameter = "referenceableGUID";
        String attachmentDescription = "Attach reference value(s)";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", methodName);
        this.invalidParameterHandler.validateGUID(referenceableGUID, "referenceableGUID", methodName);
        InstanceProperties relationshipProperties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, null, "confidence", confidence, methodName);
        if (steward != null) {
            relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "steward", steward, methodName);
        }
        if (notes != null) {
            relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "notes", notes, methodName);
        }
        this.repositoryHandler.createRelationship(userId, "111e6d2e-94e9-43ed-b4ed-f0d220668cbf", referenceableGUID, validValueGUID, relationshipProperties, methodName);
        this.lastAttachmentHandler.updateLastAttachment(referenceableGUID, "Referenceable", validValueGUID, "ValidValueDefinition", userId, "Attach reference value(s)", methodName);
    }

    public void unassignReferenceValueFromItem(String userId, String validValueGUID, String referenceableGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValueGUIDParameter = "validValueGUID";
        String referenceableGUIDParameter = "referenceableGUID";
        String attachmentDescription = "Detach reference value(s)";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", methodName);
        this.invalidParameterHandler.validateGUID(referenceableGUID, "referenceableGUID", methodName);
        this.repositoryHandler.removeRelationshipBetweenEntities(userId, "111e6d2e-94e9-43ed-b4ed-f0d220668cbf", "ReferenceValueAssignment", referenceableGUID, "Referenceable", validValueGUID, methodName);
        this.lastAttachmentHandler.updateLastAttachment(referenceableGUID, "Referenceable", validValueGUID, "ValidValueDefinition", userId, "Detach reference value(s)", methodName);
    }

    public void mapValidValues(String userId, String validValue1GUID, String validValue2GUID, String associationDescription, int confidence, String steward, String notes, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValue1GUIDParameter = "validValue1GUID";
        String validValue2GUIDParameter = "validValue2GUID";
        String attachmentDescription = "Map valid values";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(validValue1GUID, "validValue1GUID", methodName);
        this.invalidParameterHandler.validateGUID(validValue2GUID, "validValue2GUID", methodName);
        InstanceProperties relationshipProperties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, null, "confidence", confidence, methodName);
        if (associationDescription != null) {
            relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "associationDescription", associationDescription, methodName);
        }
        if (steward != null) {
            relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "steward", steward, methodName);
        }
        if (notes != null) {
            relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "notes", notes, methodName);
        }
        this.repositoryHandler.createRelationship(userId, "203ce62c-3cbf-4542-bf82-81820cba718f", validValue2GUID, validValue1GUID, relationshipProperties, methodName);
        this.lastAttachmentHandler.updateLastAttachment(validValue2GUID, "ValidValueDefinition", validValue1GUID, "ValidValueDefinition", userId, "Map valid values", methodName);
    }

    public void unmapValidValues(String userId, String validValue1GUID, String validValue2GUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValue1GUIDParameter = "validValue1GUID";
        String validValue2GUIDParameter = "validValue2GUID";
        String attachmentDescription = "Unmap valid values";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(validValue1GUID, "validValue1GUID", methodName);
        this.invalidParameterHandler.validateGUID(validValue2GUID, "validValue2GUID", methodName);
        this.repositoryHandler.removeRelationshipBetweenEntities(userId, "203ce62c-3cbf-4542-bf82-81820cba718f", "ValidValuesMapping", validValue2GUID, "ValidValueDefinition", validValue1GUID, methodName);
        this.lastAttachmentHandler.updateLastAttachment(validValue2GUID, "ValidValueDefinition", validValue1GUID, "ValidValueDefinition", userId, "Unmap valid values", methodName);
    }

    public ValidValue getValidValueByGUID(String userId, String validValueGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValueGUIDParameter = "validValueGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", methodName);
        ValidValue validValue = null;
        EntityDetail entity = this.repositoryHandler.getEntityByGUID(userId, validValueGUID, "validValueGUID", "ValidValueDefinition", methodName);
        if (entity != null) {
            ValidValuesConverter converter = new ValidValuesConverter(entity, this.repositoryHelper, this.serviceName);
            validValue = converter.getBean();
        }
        return validValue;
    }

    public List<ValidValue> getValidValueByName(String userId, String validValueName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValueNameParameter = "validValueName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(validValueName, "validValueName", methodName);
        ValidValuesBuilder builder = new ValidValuesBuilder(validValueName, validValueName, this.repositoryHelper, this.serviceName, methodName);
        List entities = this.repositoryHandler.getEntitiesByName(userId, builder.getNameInstanceProperties(methodName), "09b2133a-f045-42cc-bb00-ee602b74c618", 0, this.invalidParameterHandler.getMaxPagingSize(), methodName);
        ArrayList<ValidValue> validValues = null;
        if (entities != null) {
            validValues = new ArrayList<ValidValue>();
            for (EntityDetail entity : entities) {
                if (entity == null) continue;
                ValidValuesConverter converter = new ValidValuesConverter(entity, this.repositoryHelper, this.serviceName);
                validValues.add(converter.getBean());
            }
        }
        return validValues;
    }

    public List<ValidValue> findValidValues(String userId, String searchString, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        ValidValuesBuilder builder = new ValidValuesBuilder(searchString, searchString, this.repositoryHelper, this.serviceName, this.serverName);
        ArrayList<ValidValue> results = new ArrayList<ValidValue>();
        RepositorySelectedEntitiesIterator iterator = new RepositorySelectedEntitiesIterator(this.repositoryHandler, userId, "09b2133a-f045-42cc-bb00-ee602b74c618", builder.getNameInstanceProperties(methodName), MatchCriteria.ANY, startFrom, validatedPageSize, methodName);
        while (iterator.moreToReceive()) {
            EntityDetail validValueEntity = iterator.getNext();
            if (validValueEntity == null) continue;
            ValidValuesConverter converter = new ValidValuesConverter(validValueEntity, this.repositoryHelper, this.serviceName);
            results.add(converter.getBean());
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<ValidValue> getValidValueSetMembers(String userId, String validValueSetGUID, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValueGUIDParameter = "validValueSetGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(validValueSetGUID, "validValueSetGUID", methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        ArrayList<ValidValue> members = null;
        List memberEntities = this.repositoryHandler.getEntitiesForRelationshipType(userId, validValueSetGUID, "ValidValueSet", "6337c9cd-8e5a-461b-97f9-5151bcb97a9e", "ValidValuesMember", startFrom, validatedPageSize, methodName);
        if (memberEntities != null) {
            members = new ArrayList<ValidValue>();
            for (EntityDetail entity : memberEntities) {
                if (entity == null) continue;
                ValidValuesConverter converter = new ValidValuesConverter(entity, this.repositoryHelper, this.serviceName);
                members.add(converter.getBean());
            }
            if (members.isEmpty()) {
                members = null;
            }
        }
        return members;
    }

    public List<ValidValue> getSetsForValidValue(String userId, String validValueGUID, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValueGUIDParameter = "validValueGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        ArrayList<ValidValue> sets = null;
        List setEntities = this.repositoryHandler.getEntitiesForRelationshipType(userId, validValueGUID, "ValidValueDefinition", "6337c9cd-8e5a-461b-97f9-5151bcb97a9e", "ValidValuesMember", startFrom, validatedPageSize, methodName);
        if (setEntities != null) {
            sets = new ArrayList<ValidValue>();
            for (EntityDetail entity : setEntities) {
                if (entity == null) continue;
                ValidValuesConverter converter = new ValidValuesConverter(entity, this.repositoryHelper, this.serviceName);
                sets.add(converter.getBean());
            }
            if (sets.isEmpty()) {
                sets = null;
            }
        }
        return sets;
    }

    public List<ValidValuesAssignmentConsumer> getValidValuesAssignmentConsumers(String userId, String validValueGUID, List<String> supportedZones, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValueGUIDParameter = "validValueGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        ArrayList<ValidValuesAssignmentConsumer> consumers = null;
        List relationships = this.repositoryHandler.getRelationshipsByType(userId, validValueGUID, "ValidValueDefinition", "c5d48b73-eadd-47db-ab64-3be99b2fb32d", "ValidValuesAssignment", startFrom, validatedPageSize, methodName);
        if (relationships != null) {
            consumers = new ArrayList<ValidValuesAssignmentConsumer>();
            for (Relationship relationship : relationships) {
                EntityProxy end1;
                if (relationship == null) continue;
                ValidValuesAssignmentConsumer consumer = new ValidValuesAssignmentConsumer();
                InstanceProperties instanceProperties = relationship.getProperties();
                if (instanceProperties != null) {
                    consumer.setStrictRequirement(this.repositoryHelper.getBooleanProperty(this.serviceName, "strictRequirement", instanceProperties, methodName));
                }
                if ((end1 = relationship.getEntityOneProxy()) == null || end1.getGUID() == null) continue;
                String guidParameterName = "end1.getGUID";
                EntityDetail entity = this.repositoryHandler.getEntityByGUID(userId, end1.getGUID(), "end1.getGUID", "Referenceable", methodName);
                if (entity == null) continue;
                consumer.setConsumer(this.assetHandler.validatedVisibleReferenceable(userId, supportedZones, "end1.getGUID", entity, this.serviceName, methodName));
                consumers.add(consumer);
            }
            if (consumers.isEmpty()) {
                consumers = null;
            }
        }
        return consumers;
    }

    public List<ValidValuesAssignmentDefinition> getValidValuesAssignmentDefinition(String userId, String referenceableGUID, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String referenceableGUIDParameter = "referenceableGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(referenceableGUID, "referenceableGUID", methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        ArrayList<ValidValuesAssignmentDefinition> definitions = null;
        List relationships = this.repositoryHandler.getRelationshipsByType(userId, referenceableGUID, "Referenceable", "c5d48b73-eadd-47db-ab64-3be99b2fb32d", "ValidValuesAssignment", startFrom, validatedPageSize, methodName);
        if (relationships != null) {
            definitions = new ArrayList<ValidValuesAssignmentDefinition>();
            for (Relationship relationship : relationships) {
                EntityProxy end2;
                if (relationship == null) continue;
                ValidValuesAssignmentDefinition definition = new ValidValuesAssignmentDefinition();
                InstanceProperties instanceProperties = relationship.getProperties();
                if (instanceProperties != null) {
                    definition.setStrictRequirement(this.repositoryHelper.getBooleanProperty(this.serviceName, "strictRequirement", instanceProperties, methodName));
                }
                if ((end2 = relationship.getEntityTwoProxy()) != null && end2.getGUID() != null) {
                    String guidParameterName = "end2.getGUID";
                    EntityDetail entity = this.repositoryHandler.getEntityByGUID(userId, end2.getGUID(), "end2.getGUID", "ValidValueDefinition", methodName);
                    if (entity != null) {
                        ValidValuesConverter converter = new ValidValuesConverter(entity, this.repositoryHelper, this.serviceName);
                        definition.setValidValue(converter.getBean());
                    }
                }
                definitions.add(definition);
            }
            if (definitions.isEmpty()) {
                definitions = null;
            }
        }
        return definitions;
    }

    public List<ValidValueImplementationAsset> getValidValuesImplementationAssets(String userId, String validValueGUID, List<String> supportedZones, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValueGUIDParameter = "validValueGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        List implementationRelationships = this.repositoryHandler.getRelationshipsByType(userId, validValueGUID, "ValidValueDefinition", "d9a39553-6a47-4477-a217-844300c07cf2", "ValidValuesImplementation", startFrom, validatedPageSize, methodName);
        ArrayList<ValidValueImplementationAsset> implementationAssets = null;
        if (implementationRelationships != null) {
            implementationAssets = new ArrayList<ValidValueImplementationAsset>();
            for (Relationship relationship : implementationRelationships) {
                if (relationship == null) continue;
                ValidValueImplementationAsset implementationAsset = new ValidValueImplementationAsset();
                implementationAsset.setSymbolicName(this.repositoryHelper.getStringProperty(this.serviceName, "symbolicName", relationship.getProperties(), methodName));
                implementationAsset.setImplementationValue(this.repositoryHelper.getStringProperty(this.serviceName, "implementationValue", relationship.getProperties(), methodName));
                implementationAsset.setAdditionalValues(this.repositoryHelper.getStringMapFromProperty(this.serviceName, "additionalValues", relationship.getProperties(), methodName));
                EntityProxy end2 = relationship.getEntityTwoProxy();
                if (end2 == null || end2.getGUID() == null) continue;
                try {
                    implementationAsset.setReferenceDataAsset(this.assetHandler.getValidatedVisibleAsset(userId, supportedZones, end2.getGUID(), this.serviceName, methodName));
                    implementationAssets.add(implementationAsset);
                }
                catch (InvalidParameterException invalidParameterException) {}
            }
            if (implementationAssets.isEmpty()) {
                implementationAssets = null;
            }
        }
        return implementationAssets;
    }

    List<ValidValueImplementationDefinition> getValidValuesImplementationDefinitions(String userId, String assetGUID, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameter = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        List implementationRelationships = this.repositoryHandler.getRelationshipsByType(userId, assetGUID, "Asset", "d9a39553-6a47-4477-a217-844300c07cf2", "ValidValuesImplementation", startFrom, validatedPageSize, methodName);
        ArrayList<ValidValueImplementationDefinition> definitions = null;
        if (implementationRelationships != null) {
            definitions = new ArrayList<ValidValueImplementationDefinition>();
            for (Relationship relationship : implementationRelationships) {
                if (relationship == null) continue;
                ValidValueImplementationDefinition definition = new ValidValueImplementationDefinition();
                definition.setSymbolicName(this.repositoryHelper.getStringProperty(this.serviceName, "symbolicName", relationship.getProperties(), methodName));
                definition.setImplementationValue(this.repositoryHelper.getStringProperty(this.serviceName, "implementationValue", relationship.getProperties(), methodName));
                definition.setAdditionalValues(this.repositoryHelper.getStringMapFromProperty(this.serviceName, "additionalValues", relationship.getProperties(), methodName));
                EntityProxy end1 = relationship.getEntityOneProxy();
                if (end1 != null && end1.getGUID() != null) {
                    String guidParameterName = "end1.getGUID";
                    EntityDetail entity = this.repositoryHandler.getEntityByGUID(userId, end1.getGUID(), "end1.getGUID", "ValidValueDefinition", methodName);
                    if (entity != null) {
                        ValidValuesConverter converter = new ValidValuesConverter(entity, this.repositoryHelper, this.serviceName);
                        definition.setValidValue(converter.getBean());
                    }
                }
                definitions.add(definition);
            }
            if (definitions.isEmpty()) {
                definitions = null;
            }
        }
        return definitions;
    }

    public List<ValidValueMapping> getValidValueMappings(String userId, String validValueGUID, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValueGUIDParameter = "validValueGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        List mappingRelationships = this.repositoryHandler.getRelationshipsByType(userId, validValueGUID, "ValidValueDefinition", "203ce62c-3cbf-4542-bf82-81820cba718f", "ValidValuesMapping", startFrom, validatedPageSize, methodName);
        ArrayList<ValidValueMapping> mappings = null;
        if (mappingRelationships != null) {
            mappings = new ArrayList<ValidValueMapping>();
            for (Relationship relationship : mappingRelationships) {
                EntityDetail entity;
                if (relationship == null) continue;
                ValidValueMapping mapping = new ValidValueMapping();
                mapping.setAssociationDescription(this.repositoryHelper.getStringProperty(this.serviceName, "associationDescription", relationship.getProperties(), methodName));
                mapping.setConfidence(this.repositoryHelper.getIntProperty(this.serviceName, "confidence", relationship.getProperties(), methodName));
                mapping.setSteward(this.repositoryHelper.getStringProperty(this.serviceName, "steward", relationship.getProperties(), methodName));
                mapping.setNotes(this.repositoryHelper.getStringProperty(this.serviceName, "notes", relationship.getProperties(), methodName));
                String proxyGUIDParameterName = null;
                String otherGUID = null;
                EntityProxy proxy = relationship.getEntityOneProxy();
                if (proxy != null) {
                    proxyGUIDParameterName = "EntityOneProxy.getGUID";
                    otherGUID = proxy.getGUID();
                }
                if (validValueGUID.equals(otherGUID)) {
                    proxyGUIDParameterName = null;
                    otherGUID = null;
                    proxy = relationship.getEntityTwoProxy();
                    if (proxy != null) {
                        proxyGUIDParameterName = "EntityTwoProxy.getGUID";
                        otherGUID = proxy.getGUID();
                    }
                }
                if (otherGUID != null && (entity = this.repositoryHandler.getEntityByGUID(userId, proxy.getGUID(), proxyGUIDParameterName, "ValidValueDefinition", methodName)) != null) {
                    ValidValuesConverter converter = new ValidValuesConverter(entity, this.repositoryHelper, this.serviceName);
                    mapping.setValidValue(converter.getBean());
                }
                mappings.add(mapping);
            }
            if (mappings.isEmpty()) {
                mappings = null;
            }
        }
        return mappings;
    }

    public List<ReferenceValueAssignedItem> getReferenceValueAssignedItems(String userId, String validValueGUID, List<String> supportedZones, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String validValueGUIDParameter = "validValueGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(validValueGUID, "validValueGUID", methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        ArrayList<ReferenceValueAssignedItem> assignedItems = null;
        List relationships = this.repositoryHandler.getRelationshipsByType(userId, validValueGUID, "ValidValueDefinition", "111e6d2e-94e9-43ed-b4ed-f0d220668cbf", "ReferenceValueAssignment", startFrom, validatedPageSize, methodName);
        if (relationships != null) {
            assignedItems = new ArrayList<ReferenceValueAssignedItem>();
            for (Relationship relationship : relationships) {
                EntityProxy end1;
                if (relationship == null) continue;
                ReferenceValueAssignedItem assignedItem = new ReferenceValueAssignedItem();
                InstanceProperties instanceProperties = relationship.getProperties();
                if (instanceProperties != null) {
                    assignedItem.setConfidence(this.repositoryHelper.getIntProperty(this.serviceName, "confidence", relationship.getProperties(), methodName));
                    assignedItem.setSteward(this.repositoryHelper.getStringProperty(this.serviceName, "steward", relationship.getProperties(), methodName));
                    assignedItem.setNotes(this.repositoryHelper.getStringProperty(this.serviceName, "notes", relationship.getProperties(), methodName));
                }
                if ((end1 = relationship.getEntityOneProxy()) != null && end1.getGUID() != null) {
                    String guidParameterName = "end1.getGUID";
                    EntityDetail entity = this.repositoryHandler.getEntityByGUID(userId, end1.getGUID(), "end1.getGUID", "Referenceable", methodName);
                    if (entity != null) {
                        assignedItem.setAssignedItem(this.assetHandler.validatedVisibleReferenceable(userId, supportedZones, "end1.getGUID", entity, this.serviceName, methodName));
                        assignedItems.add(assignedItem);
                    }
                }
                assignedItems.add(assignedItem);
            }
            if (assignedItems.isEmpty()) {
                assignedItems = null;
            }
        }
        return assignedItems;
    }

    public List<ReferenceValueAssignment> getReferenceValueAssignments(String userId, String referenceableGUID, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String referenceableGUIDParameter = "referenceableGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(referenceableGUID, "referenceableGUID", methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        ArrayList<ReferenceValueAssignment> assignments = null;
        List relationships = this.repositoryHandler.getRelationshipsByType(userId, referenceableGUID, "Referenceable", "111e6d2e-94e9-43ed-b4ed-f0d220668cbf", "ReferenceValueAssignment", startFrom, validatedPageSize, methodName);
        if (relationships != null) {
            assignments = new ArrayList<ReferenceValueAssignment>();
            for (Relationship relationship : relationships) {
                EntityProxy end2;
                if (relationship == null) continue;
                ReferenceValueAssignment assignment = new ReferenceValueAssignment();
                InstanceProperties instanceProperties = relationship.getProperties();
                if (instanceProperties != null) {
                    assignment.setConfidence(this.repositoryHelper.getIntProperty(this.serviceName, "confidence", relationship.getProperties(), methodName));
                    assignment.setSteward(this.repositoryHelper.getStringProperty(this.serviceName, "steward", relationship.getProperties(), methodName));
                    assignment.setNotes(this.repositoryHelper.getStringProperty(this.serviceName, "notes", relationship.getProperties(), methodName));
                }
                if ((end2 = relationship.getEntityTwoProxy()) != null && end2.getGUID() != null) {
                    String guidParameterName = "end2.getGUID";
                    EntityDetail entity = this.repositoryHandler.getEntityByGUID(userId, end2.getGUID(), "end2.getGUID", "ValidValueDefinition", methodName);
                    if (entity != null) {
                        ValidValuesConverter converter = new ValidValuesConverter(entity, this.repositoryHelper, this.serviceName);
                        assignment.setValidValue(converter.getBean());
                    }
                }
                assignments.add(assignment);
            }
            if (assignments.isEmpty()) {
                assignments = null;
            }
        }
        return assignments;
    }
}

