/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders;

import java.util.Map;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SoftwareServerCapabilityBuilder
extends ReferenceableBuilder {
    private String displayName;
    private String description;
    private String type;
    private String version;
    private String patchLevel;
    private String source;

    public SoftwareServerCapabilityBuilder(String qualifiedName, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, repositoryHelper, serviceName, serverName);
        this.displayName = null;
        this.description = null;
        this.type = null;
        this.version = null;
        this.patchLevel = null;
        this.source = null;
    }

    public SoftwareServerCapabilityBuilder(String qualifiedName, String displayName, String description, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
    }

    public SoftwareServerCapabilityBuilder(String uniqueName, String displayName, String description, String type, String version, String patchLevel, String source, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(uniqueName, additionalProperties, extendedProperties, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
        this.type = type;
        this.version = version;
        this.patchLevel = patchLevel;
        this.source = source;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.displayName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "name", this.displayName, methodName);
        }
        if (this.description != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", this.description, methodName);
        }
        if (this.type != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "type", this.type, methodName);
        }
        if (this.version != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "version", this.version, methodName);
        }
        if (this.patchLevel != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "patchLevel", this.patchLevel, methodName);
        }
        if (this.source != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "source", this.source, methodName);
        }
        return properties;
    }

    @Override
    public InstanceProperties getNameInstanceProperties(String methodName) {
        InstanceProperties properties = super.getNameInstanceProperties(methodName);
        if (this.displayName != null) {
            String literalName = this.repositoryHelper.getExactMatchRegex(this.displayName);
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "name", literalName, methodName);
        }
        return properties;
    }
}

