/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders;

import java.util.Map;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.DataItemSortOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SchemaLinkBuilder
extends ReferenceableBuilder {
    private String displayName;
    private String description = null;
    private boolean isDeprecated = false;
    private String linkName = null;
    private Map<String, String> linkProperties = null;

    public SchemaLinkBuilder(String qualifiedName, String displayName, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
    }

    public SchemaLinkBuilder(String qualifiedName, String displayName, String description, boolean isDeprecated, String linkName, Map<String, String> linkProperties, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, extendedProperties, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
        this.isDeprecated = isDeprecated;
        this.linkName = linkName;
        this.linkProperties = linkProperties;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.displayName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "displayName", this.displayName, methodName);
        }
        if (this.description != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", this.description, methodName);
        }
        properties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, properties, "isDeprecated", this.isDeprecated, methodName);
        if (this.linkName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "linkName", this.linkName, methodName);
        }
        if (this.linkProperties != null && !this.linkProperties.isEmpty()) {
            properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, "linkProperties", this.linkProperties, methodName);
        }
        return properties;
    }

    @Override
    public InstanceProperties getNameInstanceProperties(String methodName) {
        InstanceProperties properties = super.getNameInstanceProperties(methodName);
        if (this.displayName != null) {
            String literalName = this.repositoryHelper.getExactMatchRegex(this.displayName);
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "displayName", literalName, methodName);
        }
        return properties;
    }

    @Override
    public InstanceProperties getQualifiedNameInstanceProperties(String methodName) {
        return super.getNameInstanceProperties(methodName);
    }

    private InstanceProperties addSortOrderPropertyToInstance(InstanceProperties properties, DataItemSortOrder sortOrder, String methodName) {
        int ordinal = 99;
        String symbolicName = null;
        String description = null;
        boolean element1Ordinal = false;
        String element1Value = "Ascending";
        String element1Description = "Sort the data values so that they increase in value.";
        boolean element2Ordinal = true;
        String element2Value = "Descending";
        String element2Description = "Sort the data values so that they decrease in value.";
        int element3Ordinal = 99;
        String element3Value = "Ignore";
        String element3Description = "No specific sort order.";
        switch (sortOrder) {
            case ASCENDING: {
                ordinal = 0;
                symbolicName = "Ascending";
                description = "Sort the data values so that they increase in value.";
                break;
            }
            case DESCENDING: {
                ordinal = 1;
                symbolicName = "Descending";
                description = "Sort the data values so that they decrease in value.";
                break;
            }
            case UNSORTED: {
                ordinal = 99;
                symbolicName = "Ignore";
                description = "No specific sort order.";
            }
        }
        return this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, "sortOrder", ordinal, symbolicName, description, methodName);
    }
}

