/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders;

import java.util.Map;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SchemaTypeBuilder
extends ReferenceableBuilder {
    private String displayName;
    private String typeName = null;
    private String description = null;
    private boolean isDeprecated = false;
    private String versionNumber = null;
    private String author = null;
    private String usage = null;
    private String encodingStandard = null;
    private String namespace = null;
    private String dataType = null;
    private String defaultValue = null;
    private String fixedValue = null;
    private int maximumElements = 0;

    public SchemaTypeBuilder(String qualifiedName, String displayName, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
    }

    public SchemaTypeBuilder(String typeName, String qualifiedName, String displayName, String description, String versionNumber, boolean isDeprecated, String author, String usage, String encodingStandard, String namespace, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, extendedProperties, repositoryHelper, serviceName, serverName);
        this.typeName = typeName;
        this.displayName = displayName;
        this.description = description;
        this.versionNumber = versionNumber;
        this.isDeprecated = isDeprecated;
        this.author = author;
        this.usage = usage;
        this.encodingStandard = encodingStandard;
        this.namespace = namespace;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setFixedValue(String fixedValue) {
        this.fixedValue = fixedValue;
    }

    @Deprecated
    public void setMaximumElements(int maximumElements) {
        this.maximumElements = maximumElements;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.displayName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "displayName", this.displayName, methodName);
        }
        if (this.description != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", this.description, methodName);
        }
        if (this.versionNumber != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "versionNumber", this.versionNumber, methodName);
        }
        properties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, properties, "isDeprecated", this.isDeprecated, methodName);
        if (this.author != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "author", this.author, methodName);
        }
        if (this.usage != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "usage", this.usage, methodName);
        }
        if (this.encodingStandard != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "encodingStandard", this.encodingStandard, methodName);
        }
        if (this.namespace != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "namespace", this.namespace, methodName);
        }
        if (this.dataType != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "dataType", this.dataType, methodName);
        }
        if (this.defaultValue != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "defaultValue", this.defaultValue, methodName);
        }
        if (this.fixedValue != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "fixedValue", this.fixedValue, methodName);
        }
        if (this.maximumElements != 0) {
            properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, "maximumElements", this.maximumElements, methodName);
        }
        return properties;
    }

    public InstanceProperties getTypeEmbeddedInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = this.getInstanceProperties(methodName);
        if (this.typeName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "typeName", this.typeName, methodName);
        }
        return properties;
    }

    @Override
    public InstanceProperties getNameInstanceProperties(String methodName) {
        InstanceProperties properties = super.getNameInstanceProperties(methodName);
        if (this.displayName != null) {
            String literalName = this.repositoryHelper.getExactMatchRegex(this.displayName);
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "displayName", literalName, methodName);
        }
        return properties;
    }

    @Override
    public InstanceProperties getQualifiedNameInstanceProperties(String methodName) {
        return super.getNameInstanceProperties(methodName);
    }
}

