/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters;

import java.util.Map;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.ElementHeaderConverter;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Rating;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.StarRating;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class RatingConverter
extends ElementHeaderConverter {
    public RatingConverter(EntityDetail entity, Relationship relationship, OMRSRepositoryHelper repositoryHelper, String serviceName) {
        super(entity, relationship, repositoryHelper, serviceName);
    }

    public Rating getBean() {
        String methodName = "getBean";
        Rating bean = null;
        if (this.relationship != null && this.entity != null) {
            bean = new Rating();
            super.updateBean((ElementHeader)bean);
            bean.setUser(this.relationship.getCreatedBy());
            InstanceProperties instanceProperties = this.relationship.getProperties();
            if (instanceProperties != null) {
                bean.setPublic(this.repositoryHelper.getBooleanProperty(this.serviceName, "isPublic", instanceProperties, "getBean"));
            }
            if ((instanceProperties = this.entity.getProperties()) != null) {
                bean.setReview(this.repositoryHelper.removeStringProperty(this.serviceName, "review", instanceProperties, "getBean"));
                bean.setStarRating(this.removeStarRatingFromProperties(instanceProperties));
                bean.setExtendedProperties(this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties));
            }
        }
        return bean;
    }

    private StarRating removeStarRatingFromProperties(InstanceProperties properties) {
        Map instancePropertiesMap;
        InstancePropertyValue instancePropertyValue;
        StarRating starRating = StarRating.NOT_RECOMMENDED;
        if (properties != null && (instancePropertyValue = (InstancePropertyValue)(instancePropertiesMap = properties.getInstanceProperties()).get("stars")) instanceof EnumPropertyValue) {
            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            switch (enumPropertyValue.getOrdinal()) {
                case 0: {
                    starRating = StarRating.NOT_RECOMMENDED;
                    break;
                }
                case 1: {
                    starRating = StarRating.ONE_STAR;
                    break;
                }
                case 2: {
                    starRating = StarRating.TWO_STARS;
                    break;
                }
                case 3: {
                    starRating = StarRating.THREE_STARS;
                    break;
                }
                case 4: {
                    starRating = StarRating.FOUR_STARS;
                    break;
                }
                case 5: {
                    starRating = StarRating.FIVE_STARS;
                }
            }
            instancePropertiesMap.remove("stars");
            properties.setInstanceProperties(instancePropertiesMap);
        }
        return starRating;
    }
}

