/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.ReferenceableConverter;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.DataItemSortOrder;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Referenceable;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttribute;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttributeRelationship;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaLink;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SchemaAttributeConverter
extends ReferenceableConverter {
    private SchemaType attributeType;
    private SchemaLink externalAttributeType;
    private List<SchemaAttributeRelationship> attributeRelationships;

    public SchemaAttributeConverter(EntityDetail mainEntity, SchemaType attributeType, SchemaLink externalAttributeType, List<SchemaAttributeRelationship> attributeRelationships, OMRSRepositoryHelper repositoryHelper, String serviceName) {
        super(mainEntity, repositoryHelper, serviceName);
        this.attributeType = attributeType;
        this.externalAttributeType = externalAttributeType;
        this.attributeRelationships = attributeRelationships;
    }

    public SchemaAttribute getBean() {
        String methodName = "getBean";
        SchemaAttribute bean = null;
        if (this.entity != null) {
            bean = new SchemaAttribute();
            super.updateBean((Referenceable)bean);
            bean.setAttributeType(this.attributeType);
            bean.setExternalAttributeType(this.externalAttributeType);
            bean.setAttributeRelationships(this.attributeRelationships);
            InstanceProperties instanceProperties = this.entity.getProperties();
            if (instanceProperties != null) {
                bean.setQualifiedName(this.repositoryHelper.removeStringProperty(this.serviceName, "qualifiedName", instanceProperties, "getBean"));
                bean.setAttributeName(this.repositoryHelper.removeStringProperty(this.serviceName, "displayName", instanceProperties, "getBean"));
                if (bean.getAttributeName() == null) {
                    bean.setAttributeName(this.repositoryHelper.removeStringProperty(this.serviceName, "name", instanceProperties, "getBean"));
                }
                bean.setElementPosition(this.repositoryHelper.removeIntProperty(this.serviceName, "position", instanceProperties, "getBean"));
                bean.setCardinality(this.repositoryHelper.removeStringProperty(this.serviceName, "cardinality", instanceProperties, "getBean"));
                bean.setMinCardinality(this.repositoryHelper.removeIntProperty(this.serviceName, "minCardinality", instanceProperties, "getBean"));
                bean.setMaxCardinality(this.repositoryHelper.removeIntProperty(this.serviceName, "maxCardinality", instanceProperties, "getBean"));
                bean.setDeprecated(this.repositoryHelper.removeBooleanProperty(this.serviceName, "isDeprecated", instanceProperties, "getBean"));
                bean.setDefaultValueOverride(this.repositoryHelper.removeStringProperty(this.serviceName, "defaultValueOverride", instanceProperties, "getBean"));
                bean.setAllowsDuplicateValues(this.repositoryHelper.removeBooleanProperty(this.serviceName, "allowsDuplicateValues", instanceProperties, "getBean"));
                bean.setOrderedValues(this.repositoryHelper.removeBooleanProperty(this.serviceName, "orderedValues", instanceProperties, "getBean"));
                bean.setSortOrder(this.removeSortOrderFromProperties(instanceProperties));
                bean.setMinimumLength(this.repositoryHelper.removeIntProperty(this.serviceName, "minimumLength", instanceProperties, "getBean"));
                bean.setLength(this.repositoryHelper.removeIntProperty(this.serviceName, "length", instanceProperties, "getBean"));
                bean.setSignificantDigits(this.repositoryHelper.removeIntProperty(this.serviceName, "significantDigits", instanceProperties, "getBean"));
                bean.setNullable(this.repositoryHelper.removeBooleanProperty(this.serviceName, "isNullable", instanceProperties, "getBean"));
                bean.setNativeJavaClass(this.repositoryHelper.removeStringProperty(this.serviceName, "nativeClass", instanceProperties, "getBean"));
                bean.setAliases(this.repositoryHelper.removeStringArrayProperty(this.serviceName, "aliases", instanceProperties, "getBean"));
                bean.setAdditionalProperties(this.repositoryHelper.removeStringMapFromProperty(this.serviceName, "additionalProperties", instanceProperties, "getBean"));
                bean.setExtendedProperties(this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties));
            }
        }
        return bean;
    }

    private DataItemSortOrder getSortOrderFromProperties(InstanceProperties properties) {
        InstancePropertyValue instancePropertyValue;
        Map instancePropertiesMap;
        DataItemSortOrder sortOrder = DataItemSortOrder.UNKNOWN;
        if (properties != null && (instancePropertiesMap = properties.getInstanceProperties()) != null && (instancePropertyValue = (InstancePropertyValue)instancePropertiesMap.get("sortOrder")) instanceof EnumPropertyValue) {
            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            switch (enumPropertyValue.getOrdinal()) {
                case 0: {
                    sortOrder = DataItemSortOrder.ASCENDING;
                    break;
                }
                case 1: {
                    sortOrder = DataItemSortOrder.DESCENDING;
                    break;
                }
                case 99: {
                    sortOrder = DataItemSortOrder.UNSORTED;
                }
            }
        }
        return sortOrder;
    }

    private DataItemSortOrder removeSortOrderFromProperties(InstanceProperties properties) {
        DataItemSortOrder sortOrder = this.getSortOrderFromProperties(properties);
        if (properties != null) {
            Map instancePropertiesMap = properties.getInstanceProperties();
            if (instancePropertiesMap != null) {
                instancePropertiesMap.remove("sortOrder");
            }
            properties.setInstanceProperties(instancePropertiesMap);
        }
        return sortOrder;
    }
}

