/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.odpi.openmetadata.adapters.connectors.datastore.avrofile.AvroFileStoreProvider;
import org.odpi.openmetadata.adapters.connectors.datastore.basicfile.BasicFileStoreProvider;
import org.odpi.openmetadata.adapters.connectors.datastore.csvfile.CSVFileStoreProvider;
import org.odpi.openmetadata.adapters.connectors.datastore.datafolder.DataFolderProvider;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.AssetBuilder;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.AssetConverter;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.AssetHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.SchemaTypeHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.SoftwareServerCapabilityHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Asset;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ComplexSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementOrigin;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.RelatedAsset;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttribute;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SoftwareServerCapability;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class FilesAndFoldersHandler {
    private String serviceName;
    private String serverName;
    private List<String> supportedZones;
    private OMRSRepositoryHelper repositoryHelper;
    private RepositoryHandler repositoryHandler;
    private InvalidParameterHandler invalidParameterHandler;
    private AssetHandler assetHandler;
    private SchemaTypeHandler schemaTypeHandler;
    private SoftwareServerCapabilityHandler softwareServerCapabilityHandler;
    private static final String folderDivider = "/";
    private static final String fileSystemDivider = "://";
    private static final String fileTypeDivider = "\\.";
    private static final String defaultAvroFileType = "avro";
    private static final String defaultCSVFileType = "csv";
    private static final BasicFileStoreProvider basicFileStoreProvider = new BasicFileStoreProvider();
    private static final DataFolderProvider dataFolderProvider = new DataFolderProvider();
    private static final AvroFileStoreProvider avroFileStoreProvider = new AvroFileStoreProvider();
    private static final CSVFileStoreProvider csvFileStoreProvider = new CSVFileStoreProvider();

    public FilesAndFoldersHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, List<String> supportedZones, AssetHandler assetHandler, SchemaTypeHandler schemaTypeHandler, SoftwareServerCapabilityHandler softwareServerCapabilityHandler) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.supportedZones = supportedZones;
        this.assetHandler = assetHandler;
        this.schemaTypeHandler = schemaTypeHandler;
        this.softwareServerCapabilityHandler = softwareServerCapabilityHandler;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHandler = repositoryHandler;
        this.repositoryHelper = repositoryHelper;
    }

    private String getFileSystemName(String pathName) {
        String[] tokens;
        String result = null;
        if (pathName != null && !pathName.isEmpty() && (tokens = pathName.split(fileSystemDivider)).length > 1) {
            result = tokens[0] + fileSystemDivider;
        }
        return result;
    }

    private List<String> getFolderNames(String pathName) {
        String[] tokens;
        ArrayList<String> result = null;
        if (pathName != null && !pathName.isEmpty() && (tokens = pathName.split(folderDivider)).length > 1) {
            int startingToken = 0;
            if (this.getFileSystemName(pathName) != null) {
                startingToken = 2;
            }
            int endingToken = tokens.length;
            if (this.getFileName(pathName) != null) {
                --endingToken;
            }
            if (startingToken != endingToken) {
                result = new ArrayList<String>(Arrays.asList(tokens).subList(startingToken, endingToken));
            }
        }
        return result;
    }

    private String getFileName(String pathName) {
        String result = null;
        if (pathName != null && !pathName.isEmpty()) {
            String[] tokens = pathName.split(folderDivider);
            result = tokens[tokens.length - 1];
        }
        return result;
    }

    private String getFileType(String pathName) {
        String[] tokens;
        String result = null;
        if (pathName != null && !pathName.isEmpty() && (tokens = pathName.split(fileTypeDivider)).length > 1) {
            result = tokens[tokens.length - 1];
        }
        return result;
    }

    private String createFolder(String userId, String pathName, String displayName, String description, String typeName, Connection connection, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        Asset asset = this.assetHandler.createEmptyAsset(typeName, methodName);
        asset.setDisplayName(displayName);
        asset.setDescription(description);
        asset.setQualifiedName(pathName);
        return this.assetHandler.addAsset(userId, asset, connection, methodName);
    }

    private String createFileAsset(String userId, String fileType, String pathName, String displayName, String description, String typeName, Connection connection, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        Asset asset = this.assetHandler.createEmptyAsset(typeName, methodName);
        asset.setDisplayName(displayName);
        asset.setDescription(description);
        asset.setQualifiedName(pathName);
        HashMap<String, String> extendedProperties = new HashMap<String, String>();
        extendedProperties.put("fileType", fileType);
        asset.setExtendedProperties(extendedProperties);
        return this.assetHandler.addAsset(userId, asset, connection, methodName);
    }

    private String createFolderInCatalog(String userId, String anchorGUID, String pathName, String folderName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "anchorGUID";
        String folderGUID = this.createFolder(userId, pathName, folderName, null, "FileFolder", null, methodName);
        if (anchorGUID != null) {
            if (this.repositoryHandler.isEntityATypeOf(userId, anchorGUID, "anchorGUID", "SoftwareServerCapability", methodName)) {
                this.repositoryHandler.createRelationship(userId, "92b75926-8e9a-46c7-9d98-89009f622397", anchorGUID, folderGUID, null, methodName);
            } else {
                this.repositoryHandler.createRelationship(userId, "48ac9028-45dd-495d-b3e1-622685b54a01", anchorGUID, folderGUID, null, methodName);
            }
        }
        return folderGUID;
    }

    private List<String> createFolderStructureInCatalog(String userId, String anchorGUID, String fileSystemName, List<String> folderNames, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> folderGUIDs = new ArrayList<String>();
        if (folderNames != null && !folderNames.isEmpty()) {
            String pathName = null;
            String folderName = null;
            String nextAnchorGUID = anchorGUID;
            for (String folderFragment : folderNames) {
                pathName = pathName == null ? (fileSystemName != null ? fileSystemName + folderFragment : folderFragment) : pathName + folderDivider + folderFragment;
                folderName = folderName != null ? folderName + folderDivider + folderFragment : folderFragment;
                Asset currentFolder = this.getFolderByPathName(userId, pathName, methodName);
                if (currentFolder == null) {
                    String folderGUID = this.createFolderInCatalog(userId, nextAnchorGUID, pathName, folderName, methodName);
                    folderGUIDs.add(folderGUID);
                    nextAnchorGUID = folderGUID;
                    continue;
                }
                folderGUIDs.add(currentFolder.getGUID());
                nextAnchorGUID = currentFolder.getGUID();
            }
        }
        if (folderGUIDs.isEmpty()) {
            return null;
        }
        return folderGUIDs;
    }

    public List<String> createFolderStructureInCatalog(String userId, String anchorGUID, String pathName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createFolderStructureInCatalog(userId, anchorGUID, this.getFileSystemName(pathName), this.getFolderNames(pathName), methodName);
    }

    public List<String> createFolderStructureInCatalog(String userId, String pathName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createFolderStructureInCatalog(userId, null, this.getFileSystemName(pathName), this.getFolderNames(pathName), methodName);
    }

    public void attachFolderToFileSystem(String userId, String fileSystemGUID, String folderGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        SoftwareServerCapability fileSystem = this.softwareServerCapabilityHandler.getSoftwareServerCapabilityByGUID(userId, fileSystemGUID, methodName);
        Asset folder = this.assetHandler.getValidatedVisibleAsset(userId, this.supportedZones, folderGUID, this.serviceName, methodName);
        if (fileSystem != null && folder != null) {
            this.repositoryHandler.createRelationship(userId, "92b75926-8e9a-46c7-9d98-89009f622397", fileSystemGUID, folderGUID, null, methodName);
        } else if (fileSystem == null) {
            this.invalidParameterHandler.throwUnknownElement(userId, fileSystemGUID, "SoftwareServerCapability", this.serviceName, this.serverName, methodName);
        } else {
            this.invalidParameterHandler.throwUnknownElement(userId, folderGUID, "FileFolder", this.serviceName, this.serverName, methodName);
        }
    }

    public void detachFolderFromFileSystem(String userId, String fileSystemGUID, String folderGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        SoftwareServerCapability fileSystem = this.softwareServerCapabilityHandler.getSoftwareServerCapabilityByGUID(userId, fileSystemGUID, methodName);
        Asset folder = this.assetHandler.getValidatedVisibleAsset(userId, this.supportedZones, folderGUID, this.serviceName, methodName);
        if (fileSystem != null && folder != null) {
            this.repositoryHandler.removeRelationshipBetweenEntities(userId, "92b75926-8e9a-46c7-9d98-89009f622397", "ServerAssetUse", fileSystemGUID, "SoftwareServerCapability", folderGUID, methodName);
        } else if (fileSystem == null) {
            this.invalidParameterHandler.throwUnknownElement(userId, fileSystemGUID, "SoftwareServerCapability", this.serviceName, this.serverName, methodName);
        } else {
            this.invalidParameterHandler.throwUnknownElement(userId, folderGUID, "FileFolder", this.serviceName, this.serverName, methodName);
        }
    }

    public void attachDataFileAssetToFolder(String userId, String folderGUID, String fileGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        Asset folder = this.assetHandler.getValidatedVisibleAsset(userId, this.supportedZones, folderGUID, this.serviceName, methodName);
        Asset dataFile = this.assetHandler.getValidatedVisibleAsset(userId, this.supportedZones, fileGUID, this.serviceName, methodName);
        if (dataFile != null && folder != null) {
            this.repositoryHandler.createRelationship(userId, "970a3405-fde1-4039-8249-9aa5f56d5151", folderGUID, fileGUID, null, methodName);
        } else if (dataFile == null) {
            this.invalidParameterHandler.throwUnknownElement(userId, fileGUID, "DataFile", this.serviceName, this.serverName, methodName);
        } else {
            this.invalidParameterHandler.throwUnknownElement(userId, folderGUID, "FileFolder", this.serviceName, this.serverName, methodName);
        }
    }

    public void detachDataFileAssetFromFolder(String userId, String folderGUID, String fileGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        Asset folder = this.assetHandler.getValidatedVisibleAsset(userId, this.supportedZones, folderGUID, this.serviceName, methodName);
        Asset dataFile = this.assetHandler.getValidatedVisibleAsset(userId, this.supportedZones, fileGUID, this.serviceName, methodName);
        if (dataFile != null && folder != null) {
            this.repositoryHandler.removeRelationshipBetweenEntities(userId, "970a3405-fde1-4039-8249-9aa5f56d5151", "LinkedFile", folderGUID, "FileFolder", folderGUID, methodName);
        } else if (dataFile == null) {
            this.invalidParameterHandler.throwUnknownElement(userId, fileGUID, "DataFile", this.serviceName, this.serverName, methodName);
        } else {
            this.invalidParameterHandler.throwUnknownElement(userId, folderGUID, "FileFolder", this.serviceName, this.serverName, methodName);
        }
    }

    public void moveDataFileInCatalog(String userId, String folderGUID, String fileGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String folderGUIDParameterName = "folderGUID";
        String fileGUIDParameterName = "fileGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(folderGUID, "folderGUID", methodName);
        this.invalidParameterHandler.validateGUID(fileGUID, "fileGUID", methodName);
        Asset folder = this.assetHandler.getValidatedVisibleAsset(userId, this.supportedZones, folderGUID, this.serviceName, methodName);
        Asset file = this.assetHandler.getValidatedVisibleAsset(userId, this.supportedZones, fileGUID, this.serviceName, methodName);
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
    }

    public void moveDataFolderInCatalog(String userId, String folderGUID, String dataFolderGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String folderGUIDParameterName = "folderGUID";
        String dataFolderGUIDParameterName = "pathName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(folderGUID, "folderGUID", methodName);
        this.invalidParameterHandler.validateGUID(dataFolderGUID, "pathName", methodName);
        Asset folder = this.assetHandler.getValidatedVisibleAsset(userId, this.supportedZones, folderGUID, this.serviceName, methodName);
        Asset dataFolder = this.assetHandler.getValidatedVisibleAsset(userId, this.supportedZones, dataFolderGUID, this.serviceName, methodName);
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
    }

    private List<String> addFileAssetPath(String userId, String fileAssetGUID, String pathName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String fileSystemName = this.getFileSystemName(pathName);
        String fileSystemGUID = null;
        ArrayList<String> assetGUIDList = new ArrayList<String>();
        if (fileSystemName != null) {
            SoftwareServerCapability fileSystem = this.softwareServerCapabilityHandler.getSoftwareServerCapabilityByUniqueName(userId, fileSystemName, methodName);
            fileSystemGUID = fileSystem == null ? this.softwareServerCapabilityHandler.createFileSystem(userId, fileSystemName, fileSystemName, null, null, null, null, null, null, null, null, null, methodName) : fileSystem.getGUID();
        }
        List<String> folderNames = this.getFolderNames(pathName);
        List<String> folderGUIDs = null;
        String fileAnchorGUID = folderNames == null ? fileSystemGUID : ((folderGUIDs = this.createFolderStructureInCatalog(userId, fileSystemGUID, fileSystemName, folderNames, methodName)) != null && !folderGUIDs.isEmpty() ? folderGUIDs.get(folderGUIDs.size() - 1) : fileSystemGUID);
        if (fileAssetGUID != null && fileAnchorGUID != null) {
            if (folderNames != null) {
                this.repositoryHandler.createRelationship(userId, "4cb88900-1446-4eb6-acea-29cd9da45e63", fileAnchorGUID, fileAssetGUID, null, methodName);
            } else {
                this.repositoryHandler.createRelationship(userId, "92b75926-8e9a-46c7-9d98-89009f622397", fileAnchorGUID, fileAssetGUID, null, methodName);
            }
        }
        if (fileSystemGUID != null) {
            assetGUIDList.add(fileSystemGUID);
        }
        if (folderGUIDs != null) {
            assetGUIDList.addAll(folderGUIDs);
        }
        if (fileAssetGUID != null) {
            assetGUIDList.add(fileAssetGUID);
        }
        if (assetGUIDList.isEmpty()) {
            return null;
        }
        return assetGUIDList;
    }

    public List<String> addDataFileAssetToCatalog(String userId, String displayName, String description, String pathName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String pathParameterName = "pathName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(pathName, "pathName", methodName);
        String fileType = this.getFileType(pathName);
        String fileAssetGUID = this.createFileAsset(userId, fileType, pathName, displayName, description, "DataFile", this.getDataFileConnection(pathName), methodName);
        return this.addFileAssetPath(userId, fileAssetGUID, pathName, methodName);
    }

    public List<String> addDataFolderAssetToCatalog(String userId, String displayName, String description, String pathName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String pathParameterName = "pathName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(pathName, "pathName", methodName);
        String fileAssetGUID = this.createFolder(userId, pathName, displayName, description, "DataFolder", this.getDataFolderConnection(pathName), methodName);
        return this.addFileAssetPath(userId, fileAssetGUID, pathName, methodName);
    }

    public List<String> addFileToCatalog(String userId, String fullPath, String displayName, String description, Map<String, String> additionalProperties, String connectorClassName, String typeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String fileAssetTypeName;
        String pathParameterName = "fullPath";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(fullPath, "fullPath", methodName);
        Map<String, Object> assetExtendedProperties = extendedProperties;
        String fileType = this.getFileType(fullPath);
        if (fileType != null) {
            if (assetExtendedProperties == null) {
                assetExtendedProperties = new HashMap<String, Object>();
            }
            assetExtendedProperties.put("fileType", fileType);
        }
        if ((fileAssetTypeName = typeName) == null) {
            fileAssetTypeName = defaultCSVFileType.equals(fileType) ? "CSVFile" : (defaultAvroFileType.equals(fileType) ? "AvroFile" : "DataFile");
        }
        Connection connection = this.getConnectionForFile(fileType, fullPath, connectorClassName);
        String fileAssetGUID = this.assetHandler.addAsset(userId, fileAssetTypeName, fullPath, displayName, description, additionalProperties, assetExtendedProperties, connection, methodName);
        return this.addFileAssetPath(userId, fileAssetGUID, fullPath, methodName);
    }

    public List<String> addAvroFileToCatalog(String userId, String displayName, String description, String fullPath, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String pathParameterName = "fullPath";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(fullPath, "fullPath", methodName);
        String fileType = this.getFileType(fullPath);
        if (fileType == null) {
            fileType = defaultAvroFileType;
        }
        String fileAssetGUID = this.createFileAsset(userId, fileType, fullPath, displayName, description, "AvroFile", this.getAvroFileConnection(fullPath), methodName);
        return this.addFileAssetPath(userId, fileAssetGUID, fullPath, methodName);
    }

    public List<String> addCSVFileToCatalog(String userId, String displayName, String description, String fullPath, List<String> columnHeaders, Character delimiterCharacter, Character quoteCharacter, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String pathParameterName = "fullPath";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(fullPath, "fullPath", methodName);
        String fileType = this.getFileType(fullPath);
        if (fileType == null) {
            fileType = defaultCSVFileType;
        }
        Asset asset = this.assetHandler.createEmptyAsset("CSVFile", methodName);
        asset.setDisplayName(displayName);
        asset.setDescription(description);
        asset.setQualifiedName(fullPath);
        SchemaType schemaType = null;
        List<SchemaAttribute> schemaAttributes = null;
        if (columnHeaders != null) {
            schemaType = this.getTabularSchemaType(this.schemaTypeHandler, asset.getQualifiedName(), asset.getDisplayName(), userId, "CSVFile", columnHeaders, methodName);
            schemaAttributes = this.getTabularSchemaColumns(this.schemaTypeHandler, schemaType.getQualifiedName(), columnHeaders, null, null, null, methodName);
        }
        if (delimiterCharacter == null) {
            delimiterCharacter = Character.valueOf(',');
        }
        if (quoteCharacter == null) {
            quoteCharacter = Character.valueOf('\"');
        }
        HashMap<String, String> extendedProperties = new HashMap<String, String>();
        extendedProperties.put("delimiterCharacter", delimiterCharacter.toString());
        extendedProperties.put("quoteCharacter", quoteCharacter.toString());
        extendedProperties.put("fileType", fileType);
        asset.setExtendedProperties(extendedProperties);
        String fileAssetGUID = this.assetHandler.addAsset(userId, asset, schemaType, schemaAttributes, this.getCSVFileConnection(fullPath, columnHeaders, delimiterCharacter, quoteCharacter), methodName);
        return this.addFileAssetPath(userId, fileAssetGUID, fullPath, methodName);
    }

    private SchemaType getTabularSchemaType(SchemaTypeHandler schemaTypeHandler, String anchorQualifiedName, String anchorDisplayName, String author, String encodingStandard, List<String> columnHeaders, String methodName) throws InvalidParameterException {
        ComplexSchemaType tableSchemaType = schemaTypeHandler.getEmptyComplexSchemaType("TabularSchemaType", null, null, null, methodName);
        if (columnHeaders != null) {
            tableSchemaType.setAttributeCount(columnHeaders.size());
        }
        tableSchemaType.setQualifiedName(anchorQualifiedName + ":TabularSchema");
        tableSchemaType.setDisplayName(anchorDisplayName + " Tabular Schema");
        tableSchemaType.setAuthor(author);
        tableSchemaType.setVersionNumber("1.0");
        tableSchemaType.setEncodingStandard(encodingStandard);
        return tableSchemaType;
    }

    private List<SchemaAttribute> getTabularSchemaColumns(SchemaTypeHandler schemaTypeHandler, String parentSchemaQualifiedName, List<String> columnHeaders, ElementOrigin elementOrigin, String externalSourceGUID, String externalSourceName, String methodName) throws InvalidParameterException {
        ArrayList<SchemaAttribute> tableColumns = new ArrayList<SchemaAttribute>();
        if (columnHeaders != null) {
            int positionCount = 0;
            for (String columnName : columnHeaders) {
                if (columnName == null) continue;
                SchemaAttribute schemaAttribute = schemaTypeHandler.getEmptySchemaAttribute("TabularColumn", elementOrigin, externalSourceGUID, externalSourceName, methodName);
                schemaAttribute.setQualifiedName(parentSchemaQualifiedName + ":Column:" + columnName);
                schemaAttribute.setAttributeName(columnName);
                schemaAttribute.setMinCardinality(1);
                schemaAttribute.setMaxCardinality(1);
                schemaAttribute.setElementPosition(positionCount);
                tableColumns.add(schemaAttribute);
                ++positionCount;
            }
        }
        if (tableColumns.isEmpty()) {
            return null;
        }
        return tableColumns;
    }

    private Connection getConnectionForFile(String fileType, String fullPath, String connectorClassName) {
        String providerClass = connectorClassName;
        if (providerClass == null) {
            if (defaultCSVFileType.equals(fileType)) {
                providerClass = csvFileStoreProvider.getClass().getName();
            } else if (defaultAvroFileType.equals(fileType)) {
                providerClass = avroFileStoreProvider.getClass().getName();
            }
        }
        String endpointName = "File.Endpoint." + fullPath;
        String connectionDescription = "File connection.";
        String connectionName = fullPath + " File Connection";
        Connection connection = new Connection();
        connection.setType(Connection.getConnectionType());
        connection.setGUID(UUID.randomUUID().toString());
        connection.setQualifiedName(connectionName);
        connection.setDisplayName(connectionName);
        connection.setDescription("File connection." + fullPath);
        connection.setEndpoint(this.getEndpoint(endpointName, fullPath));
        connection.setConnectorType(this.getConnectorType(providerClass));
        return connection;
    }

    public Connection getDataFileConnection(String fileName) {
        String endpointName = "FileStore.Endpoint." + fileName;
        String connectionDescription = "FileStore connection.";
        String connectionName = fileName + " File Store Connection";
        Connection connection = new Connection();
        connection.setType(Connection.getConnectionType());
        connection.setGUID(UUID.randomUUID().toString());
        connection.setQualifiedName(connectionName);
        connection.setDisplayName(connectionName);
        connection.setDescription("FileStore connection." + fileName);
        connection.setEndpoint(this.getEndpoint(endpointName, fileName));
        connection.setConnectorType(basicFileStoreProvider.getConnectorType());
        return connection;
    }

    public Connection getCSVFileConnection(String fileName, List<String> columnHeaders, Character delimiterCharacter, Character quoteCharacter) {
        String endpointName = "CSVFileStore.Endpoint." + fileName;
        String connectionDescription = "CSVFileStore connection.";
        String connectionName = fileName + " CSV File Store Connection";
        Connection connection = new Connection();
        connection.setType(Connection.getConnectionType());
        connection.setQualifiedName(connectionName);
        connection.setDisplayName(connectionName);
        connection.setDescription("CSVFileStore connection.");
        connection.setEndpoint(this.getEndpoint(endpointName, fileName));
        connection.setConnectorType(csvFileStoreProvider.getConnectorType());
        HashMap<String, Object> configurationProperties = new HashMap<String, Object>();
        if (delimiterCharacter != null) {
            configurationProperties.put("delimiterCharacter", delimiterCharacter);
        }
        if (quoteCharacter != null) {
            configurationProperties.put("quoteCharacter", quoteCharacter);
        }
        if (columnHeaders != null) {
            configurationProperties.put("columnNames", columnHeaders);
        }
        if (!configurationProperties.isEmpty()) {
            connection.setConfigurationProperties(configurationProperties);
        }
        return connection;
    }

    public Connection getAvroFileConnection(String fileName) {
        String endpointName = "AvroFileStore.Endpoint." + fileName;
        String connectionDescription = "AvroFileStore connection.";
        String connectionName = fileName + " Avro File Store Connection";
        Connection connection = new Connection();
        connection.setType(Connection.getConnectionType());
        connection.setQualifiedName(connectionName);
        connection.setDisplayName(connectionName);
        connection.setDescription("AvroFileStore connection.");
        connection.setEndpoint(this.getEndpoint(endpointName, fileName));
        connection.setConnectorType(avroFileStoreProvider.getConnectorType());
        return connection;
    }

    public Connection getDataFolderConnection(String folderName) {
        String endpointName = "DataFolder.Endpoint." + folderName;
        String connectionDescription = "DataFolder connection.";
        String connectionName = folderName + " Data Folder Connection";
        Connection connection = new Connection();
        connection.setType(Connection.getConnectionType());
        connection.setQualifiedName(connectionName);
        connection.setDisplayName(connectionName);
        connection.setDescription("DataFolder connection.");
        connection.setEndpoint(this.getEndpoint(endpointName, folderName));
        connection.setConnectorType(dataFolderProvider.getConnectorType());
        return connection;
    }

    private ConnectorType getConnectorType(String connectorProviderClassName) {
        if (connectorProviderClassName == null) {
            return basicFileStoreProvider.getConnectorType();
        }
        if (basicFileStoreProvider.getClass().getName().equals(connectorProviderClassName)) {
            return basicFileStoreProvider.getConnectorType();
        }
        if (dataFolderProvider.getClass().getName().equals(connectorProviderClassName)) {
            return dataFolderProvider.getConnectorType();
        }
        if (avroFileStoreProvider.getClass().getName().equals(connectorProviderClassName)) {
            return avroFileStoreProvider.getConnectorType();
        }
        if (csvFileStoreProvider.getClass().getName().equals(connectorProviderClassName)) {
            return csvFileStoreProvider.getConnectorType();
        }
        ConnectorType connectorType = new ConnectorType();
        connectorType.setConnectorProviderClassName(connectorProviderClassName);
        return connectorType;
    }

    private Endpoint getEndpoint(String endpointName, String fileName) {
        String endpointDescription = "Access information to connect to the actual asset: ";
        Endpoint endpoint = new Endpoint();
        endpoint.setType(Endpoint.getEndpointType());
        endpoint.setQualifiedName(endpointName);
        endpoint.setDisplayName(endpointName);
        endpoint.setDescription("Access information to connect to the actual asset: " + fileName);
        endpoint.setAddress(fileName);
        return endpoint;
    }

    public Asset getFolderByGUID(String userId, String folderGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidName = "folderGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(folderGUID, "folderGUID", methodName);
        EntityDetail entity = this.repositoryHandler.getEntityByGUID(userId, folderGUID, "folderGUID", "FileFolder", methodName);
        if (entity != null) {
            AssetConverter converter = new AssetConverter(entity, null, this.repositoryHelper, this.serviceName);
            return converter.getAssetBean();
        }
        return null;
    }

    public Asset getFolderByPathName(String userId, String pathName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameName = "pathName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(pathName, "pathName", methodName);
        AssetBuilder builder = new AssetBuilder(pathName, null, this.repositoryHelper, this.serviceName, this.serverName);
        EntityDetail entity = this.repositoryHandler.getUniqueEntityByName(userId, pathName, "pathName", builder.getQualifiedNameInstanceProperties(methodName), "229ed5cc-de31-45fc-beb4-9919fd247398", "FileFolder", methodName);
        if (entity != null) {
            AssetConverter converter = new AssetConverter(entity, null, this.repositoryHelper, this.serviceName);
            return converter.getAssetBean();
        }
        return null;
    }

    public List<Asset> findFolderByPathName(String userId, String pathName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameName = "pathName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(pathName, "pathName", methodName);
        AssetBuilder builder = new AssetBuilder(pathName, null, this.repositoryHelper, this.serviceName, this.serverName);
        List entities = this.repositoryHandler.getEntitiesByName(userId, builder.getQualifiedNameInstanceProperties(methodName), "229ed5cc-de31-45fc-beb4-9919fd247398", 0, this.invalidParameterHandler.getMaxPagingSize(), methodName);
        if (entities != null) {
            ArrayList<Asset> assets = new ArrayList<Asset>();
            for (EntityDetail entity : entities) {
                if (entity == null) continue;
                AssetConverter converter = new AssetConverter(entity, null, this.repositoryHelper, this.serviceName);
                assets.add(converter.getAssetBean());
            }
            if (assets.isEmpty()) {
                assets = null;
            }
            return assets;
        }
        return null;
    }

    public List<Asset> findFolderByName(String userId, String name, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameName = "name";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, "name", methodName);
        AssetBuilder builder = new AssetBuilder(name, null, this.repositoryHelper, this.serviceName, this.serverName);
        List entities = this.repositoryHandler.getEntitiesByName(userId, builder.getSearchInstanceProperties(methodName), "229ed5cc-de31-45fc-beb4-9919fd247398", 0, this.invalidParameterHandler.getMaxPagingSize(), methodName);
        if (entities != null) {
            ArrayList<Asset> assets = new ArrayList<Asset>();
            for (EntityDetail entity : entities) {
                if (entity == null) continue;
                AssetConverter converter = new AssetConverter(entity, null, this.repositoryHelper, this.serviceName);
                assets.add(converter.getAssetBean());
            }
            if (assets.isEmpty()) {
                assets = null;
            }
            return assets;
        }
        return null;
    }

    public List<String> getNestedFolders(String userId, String anchorGUID, int startingFrom, int maxPageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "anchorGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(anchorGUID, "anchorGUID", methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startingFrom, maxPageSize, methodName);
        List<RelatedAsset> relatedAssets = this.repositoryHandler.isEntityATypeOf(userId, anchorGUID, "anchorGUID", "FileFolder", methodName) ? this.assetHandler.getRelatedAssets(userId, this.supportedZones, anchorGUID, "229ed5cc-de31-45fc-beb4-9919fd247398", "FileFolder", startingFrom, queryPageSize, this.serviceName, methodName) : this.assetHandler.getRelatedAssets(userId, this.supportedZones, anchorGUID, "48ac9028-45dd-495d-b3e1-622685b54a01", "FolderHierarchy", startingFrom, queryPageSize, this.serviceName, methodName);
        return this.getRelatedAssetGUIDs(relatedAssets);
    }

    private List<String> getRelatedAssetGUIDs(List<RelatedAsset> relatedAssets) {
        if (relatedAssets != null) {
            ArrayList<String> relatedAssetGUIDs = new ArrayList<String>();
            for (RelatedAsset relatedAsset : relatedAssets) {
                Asset asset;
                if (relatedAsset == null || (asset = relatedAsset.getRelatedAsset()) == null || asset.getGUID() == null) continue;
                relatedAssetGUIDs.add(asset.getGUID());
            }
            if (!relatedAssetGUIDs.isEmpty()) {
                return relatedAssetGUIDs;
            }
        }
        return null;
    }

    public List<String> getFolderFiles(String userId, String folderGUID, int startingFrom, int maxPageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "folderGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(folderGUID, "folderGUID", methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startingFrom, maxPageSize, methodName);
        ArrayList<RelatedAsset> files = new ArrayList<RelatedAsset>();
        boolean moreFilesToCome = true;
        int requestPointer = startingFrom;
        while (files.size() < queryPageSize && moreFilesToCome) {
            List<RelatedAsset> relatedAssets = this.assetHandler.getRelatedAssets(userId, this.supportedZones, folderGUID, requestPointer, queryPageSize, this.serviceName, methodName);
            if (relatedAssets == null) {
                moreFilesToCome = false;
                continue;
            }
            if (relatedAssets.size() < maxPageSize) {
                moreFilesToCome = false;
            } else {
                requestPointer += relatedAssets.size();
            }
            for (RelatedAsset relatedAsset : relatedAssets) {
                if (relatedAsset == null || !"NestedFile".equals(relatedAsset.getTypeName()) && !"LinkedFile".equals(relatedAsset.getTypeName())) continue;
                files.add(relatedAsset);
            }
        }
        return this.getRelatedAssetGUIDs(files);
    }

    public Asset getDataFileByGUID(String userId, String dataFileGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidName = "dataFileGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(dataFileGUID, "dataFileGUID", methodName);
        EntityDetail entity = this.repositoryHandler.getEntityByGUID(userId, dataFileGUID, "dataFileGUID", "DataFile", methodName);
        if (entity != null) {
            AssetConverter converter = new AssetConverter(entity, null, this.repositoryHelper, this.serviceName);
            return converter.getAssetBean();
        }
        return null;
    }

    public Asset getDataFileByPathName(String userId, String pathName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameName = "pathName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(pathName, "pathName", methodName);
        AssetBuilder builder = new AssetBuilder(pathName, null, this.repositoryHelper, this.serviceName, this.serverName);
        EntityDetail entity = this.repositoryHandler.getUniqueEntityByName(userId, pathName, "pathName", builder.getQualifiedNameInstanceProperties(methodName), "10752b4a-4b5d-4519-9eae-fdd6d162122f", "DataFile", methodName);
        if (entity != null) {
            AssetConverter converter = new AssetConverter(entity, null, this.repositoryHelper, this.serviceName);
            return converter.getAssetBean();
        }
        return null;
    }

    public List<Asset> findDataFileByPathName(String userId, String pathName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameName = "pathName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(pathName, "pathName", methodName);
        AssetBuilder builder = new AssetBuilder(pathName, null, this.repositoryHelper, this.serviceName, this.serverName);
        List entities = this.repositoryHandler.getEntitiesByName(userId, builder.getQualifiedNameInstanceProperties(methodName), "10752b4a-4b5d-4519-9eae-fdd6d162122f", 0, this.invalidParameterHandler.getMaxPagingSize(), methodName);
        if (entities != null) {
            ArrayList<Asset> assets = new ArrayList<Asset>();
            for (EntityDetail entity : entities) {
                if (entity == null) continue;
                AssetConverter converter = new AssetConverter(entity, null, this.repositoryHelper, this.serviceName);
                assets.add(converter.getAssetBean());
            }
            if (assets.isEmpty()) {
                assets = null;
            }
            return assets;
        }
        return null;
    }

    public List<Asset> findDataFileByName(String userId, String name, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameName = "name";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, "name", methodName);
        AssetBuilder builder = new AssetBuilder(name, null, this.repositoryHelper, this.serviceName, this.serverName);
        List entities = this.repositoryHandler.getEntitiesByName(userId, builder.getSearchInstanceProperties(methodName), "10752b4a-4b5d-4519-9eae-fdd6d162122f", 0, this.invalidParameterHandler.getMaxPagingSize(), methodName);
        if (entities != null) {
            ArrayList<Asset> assets = new ArrayList<Asset>();
            for (EntityDetail entity : entities) {
                if (entity == null) continue;
                AssetConverter converter = new AssetConverter(entity, null, this.repositoryHelper, this.serviceName);
                assets.add(converter.getAssetBean());
            }
            if (assets.isEmpty()) {
                assets = null;
            }
            return assets;
        }
        return null;
    }
}

