/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.LikeBuilder;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.LikeConverter;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.FeedbackHandlerBase;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.LastAttachmentHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Like;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class LikeHandler
extends FeedbackHandlerBase {
    private String serviceName;
    private String serverName;
    private OMRSRepositoryHelper repositoryHelper;
    private RepositoryHandler repositoryHandler;
    private InvalidParameterHandler invalidParameterHandler;
    private LastAttachmentHandler lastAttachmentHandler;

    public LikeHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, LastAttachmentHandler lastAttachmentHandler) {
        super(serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, lastAttachmentHandler);
    }

    int countLikes(String userId, String anchorGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return super.countAttachments(userId, anchorGUID, "Referenceable", "e2509715-a606-415d-a995-61d00503dad4", "AttachedLike", methodName);
    }

    public List<Like> getLikes(String userId, String anchorGUID, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<Relationship> relationships = this.getAttachmentLinks(userId, anchorGUID, "Referenceable", "e2509715-a606-415d-a995-61d00503dad4", "AttachedLike", startingFrom, pageSize, methodName);
        if (relationships == null || relationships.isEmpty()) {
            return null;
        }
        ArrayList<Like> results = new ArrayList<Like>();
        for (Relationship relationship : relationships) {
            Like bean;
            if (relationship == null || (bean = this.getLike(userId, relationship, methodName)) == null) continue;
            results.add(bean);
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    private Like getLike(String userId, Relationship relationship, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityProxy entityProxy;
        String guidParameterName = "referenceableRelationship.end2.guid";
        if (relationship != null && (entityProxy = relationship.getEntityTwoProxy()) != null) {
            EntityDetail entity = this.repositoryHandler.getEntityByGUID(userId, entityProxy.getGUID(), "referenceableRelationship.end2.guid", "Like", methodName);
            LikeConverter converter = new LikeConverter(entity, relationship, this.repositoryHelper, this.serviceName);
            return converter.getBean();
        }
        return null;
    }

    public String saveLike(String userId, String anchorGUID, boolean isPublic, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.removeLike(userId, anchorGUID);
        LikeBuilder builder = new LikeBuilder(isPublic, anchorGUID, this.repositoryHelper, this.serviceName, this.serverName);
        return this.repositoryHandler.addUniqueAttachedEntityToAnchor(userId, anchorGUID, "Referenceable", "e2509715-a606-415d-a995-61d00503dad4", "AttachedLike", builder.getRelationshipInstanceProperties(methodName), "deaa5ca0-47a0-483d-b943-d91c76744e01", "Like", null, methodName);
    }

    private void removeLike(String userId, String anchorGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeLike";
        this.repositoryHandler.removeUniqueEntityTypeFromAnchor(userId, anchorGUID, "Referenceable", "e2509715-a606-415d-a995-61d00503dad4", "AttachedLike", "deaa5ca0-47a0-483d-b943-d91c76744e01", "Like", "removeLike");
    }

    public void addLikeToReferenceable(String userId, String anchorGUID, String anchorType, boolean isPublic, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameter = "anchorGUID";
        String likeDescription = "New like from ";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(anchorGUID, "anchorGUID", methodName);
        String likeGUID = this.saveLike(userId, anchorGUID, isPublic, methodName);
        this.lastAttachmentHandler.updateLastAttachment(anchorGUID, anchorType, likeGUID, "Like", userId, "New like from " + userId, methodName);
    }

    public void removeLikeFromReferenceable(String userId, String anchorGUID, String anchorType, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameter = "likeGUID";
        String likeDescription = "Removed like from ";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(anchorGUID, "likeGUID", methodName);
        this.repositoryHandler.validateEntityGUID(userId, anchorGUID, anchorType, methodName, "likeGUID");
        this.removeLike(userId, anchorGUID);
        this.lastAttachmentHandler.updateLastAttachment(anchorGUID, anchorType, null, "Like", userId, "Removed like from " + userId, methodName);
    }
}

