/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.RatingBuilder;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.RatingConverter;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.FeedbackHandlerBase;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.LastAttachmentHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Rating;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.StarRating;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class RatingHandler
extends FeedbackHandlerBase {
    public RatingHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, LastAttachmentHandler lastAttachmentHandler) {
        super(serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, lastAttachmentHandler);
    }

    int countRatings(String userId, String anchorGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return super.countAttachments(userId, anchorGUID, "Referenceable", "0aaad9e9-9cc5-4ad8-bc2e-c1099bab6344", "AttachedRating", methodName);
    }

    public List<Rating> getRatings(String userId, String anchorGUID, int startingFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "anchorGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(anchorGUID, "anchorGUID", methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startingFrom, pageSize, methodName);
        List<Relationship> relationships = this.getAttachmentLinks(userId, anchorGUID, "Referenceable", "0aaad9e9-9cc5-4ad8-bc2e-c1099bab6344", "AttachedRating", startingFrom, queryPageSize, methodName);
        if (relationships == null || relationships.isEmpty()) {
            return null;
        }
        ArrayList<Rating> results = new ArrayList<Rating>();
        for (Relationship relationship : relationships) {
            Rating bean;
            if (relationship == null || (bean = this.getRating(userId, relationship, methodName)) == null) continue;
            results.add(bean);
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    private Rating getRating(String userId, Relationship relationship, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityProxy entityProxy;
        String guidParameterName = "referenceableRelationship.end2.guid";
        if (relationship != null && (entityProxy = relationship.getEntityTwoProxy()) != null) {
            EntityDetail entity = this.repositoryHandler.getEntityByGUID(userId, entityProxy.getGUID(), "referenceableRelationship.end2.guid", "Rating", methodName);
            RatingConverter converter = new RatingConverter(entity, relationship, this.repositoryHelper, this.serviceName);
            return converter.getBean();
        }
        return null;
    }

    private String saveRating(String userId, String anchorGUID, StarRating starRating, String review, boolean isPublic, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        try {
            this.removeRating(userId, anchorGUID, methodName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        RatingBuilder builder = new RatingBuilder(starRating, review, isPublic, anchorGUID, this.repositoryHelper, this.serviceName, this.serverName);
        return this.repositoryHandler.addUniqueAttachedEntityToAnchor(userId, anchorGUID, "Referenceable", "0aaad9e9-9cc5-4ad8-bc2e-c1099bab6344", "AttachedRating", builder.getRelationshipInstanceProperties(methodName), "7299d721-d17f-4562-8286-bcd451814478", "Rating", builder.getEntityInstanceProperties(methodName), methodName);
    }

    private void removeRating(String userId, String anchorGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.repositoryHandler.removeUniqueEntityTypeFromAnchor(userId, anchorGUID, "Referenceable", "0aaad9e9-9cc5-4ad8-bc2e-c1099bab6344", "AttachedRating", "7299d721-d17f-4562-8286-bcd451814478", "Rating", methodName);
    }

    public void addRatingToReferenceable(String userId, String anchorGUID, String anchorType, StarRating starRating, String review, boolean isPublic, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String anchorGUIDParameter = "anchorGUID";
        String ratingParameter = "starRating";
        String ratingDescription = "New rating from ";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(anchorGUID, "anchorGUID", methodName);
        this.invalidParameterHandler.validateEnum((Object)starRating, "starRating", methodName);
        this.repositoryHandler.validateEntityGUID(userId, anchorGUID, anchorType, methodName, "anchorGUID");
        String ratingGUID = this.saveRating(userId, anchorGUID, starRating, review, isPublic, methodName);
        this.lastAttachmentHandler.updateLastAttachment(anchorGUID, anchorType, ratingGUID, "Rating", userId, "New rating from " + userId, methodName);
    }

    public void removeRatingFromReferencable(String userId, String anchorGUID, String anchorType, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameter = "anchorGUID";
        String ratingDescription = "Removed rating from ";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(anchorGUID, "anchorGUID", methodName);
        this.repositoryHandler.validateEntityGUID(userId, anchorGUID, anchorType, methodName, "anchorGUID");
        this.removeRating(userId, anchorGUID, methodName);
        this.lastAttachmentHandler.updateLastAttachment(anchorGUID, anchorType, null, "Rating", userId, "Removed rating from " + userId, methodName);
    }
}

