/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.FileSystemBuilder;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.SoftwareServerCapabilityBuilder;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.SoftwareServerCapabilityConverter;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.ffdc.OMAGOCFErrorCode;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SoftwareServerCapability;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SoftwareServerCapabilityHandler {
    private String serviceName;
    private String serverName;
    private OMRSRepositoryHelper repositoryHelper;
    private RepositoryHandler repositoryHandler;
    private InvalidParameterHandler invalidParameterHandler;

    public SoftwareServerCapabilityHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHandler = repositoryHandler;
        this.repositoryHelper = repositoryHelper;
    }

    public String createFileSystem(String userId, String uniqueName, String displayName, String description, String type, String version, String patchLevel, String source, String format, String encryption, Map<String, String> additionalProperties, Map<String, String> vendorProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        FileSystemBuilder builder = new FileSystemBuilder(uniqueName, displayName, description, type, version, patchLevel, source, format, encryption, additionalProperties, null, this.repositoryHelper, this.serviceName, this.serverName);
        String fileSystemGUID = this.repositoryHandler.createEntity(userId, "fe30a033-8f86-4d17-8986-e6166fa24177", "fe30a033-8f86-4d17-8986-e6166fa24177", builder.getInstanceProperties(methodName), methodName);
        if (fileSystemGUID != null) {
            this.repositoryHandler.classifyEntity(userId, fileSystemGUID, "cab5ba1d-cfd3-4fca-857d-c07711fc4157", "FileSystem", builder.getClassificationInstanceProperties(methodName), methodName);
        }
        return fileSystemGUID;
    }

    public String createDatabaseManager(String userId, String uniqueName, String displayName, String description, String type, String version, String patchLevel, String source, Map<String, String> additionalProperties, Map<String, String> vendorProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        SoftwareServerCapabilityBuilder builder = new SoftwareServerCapabilityBuilder(uniqueName, displayName, description, type, version, patchLevel, source, additionalProperties, null, this.repositoryHelper, this.serviceName, this.serverName);
        String databasePlatformGUID = this.repositoryHandler.createEntity(userId, "68b35c1e-6c28-4ac3-94f9-2c3dbcbb79e9", "DatabaseManager", builder.getInstanceProperties(methodName), methodName);
        if (databasePlatformGUID != null) {
            this.setVendorPropertiesForCapability(userId, databasePlatformGUID, vendorProperties, methodName);
        }
        return databasePlatformGUID;
    }

    public String createMetadataIntegrator(String userId, String uniqueName, String displayName, String description, String type, String version, String patchLevel, String source, Map<String, String> additionalProperties, Map<String, String> vendorProperties, String classificationGUID, String classificationName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        SoftwareServerCapabilityBuilder builder = new SoftwareServerCapabilityBuilder(uniqueName, displayName, description, type, version, patchLevel, source, additionalProperties, null, this.repositoryHelper, this.serviceName, this.serverName);
        String integratorGUID = this.repositoryHandler.createEntity(userId, "cc6d2d77-626c-4d0d-aa22-0a491b5fee94", "MetadataIntegrationCapability", builder.getInstanceProperties(methodName), methodName);
        if (integratorGUID != null) {
            this.setVendorPropertiesForCapability(userId, integratorGUID, vendorProperties, methodName);
            this.repositoryHandler.classifyEntity(userId, integratorGUID, classificationGUID, classificationName, null, methodName);
        }
        return integratorGUID;
    }

    public SoftwareServerCapability getSoftwareServerCapabilityByGUID(String userId, String softwareServerCapabilityGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidName = "softwareServerCapabilityGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(softwareServerCapabilityGUID, "softwareServerCapabilityGUID", methodName);
        EntityDetail entity = this.repositoryHandler.getEntityByGUID(userId, softwareServerCapabilityGUID, "softwareServerCapabilityGUID", "SoftwareServerCapability", methodName);
        if (entity != null) {
            SoftwareServerCapabilityConverter converter = new SoftwareServerCapabilityConverter(entity, this.repositoryHelper, this.serviceName);
            return converter.getBean();
        }
        return null;
    }

    public SoftwareServerCapability getSoftwareServerCapabilityByUniqueName(String userId, String uniqueName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameName = "uniqueName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(uniqueName, "uniqueName", methodName);
        FileSystemBuilder builder = new FileSystemBuilder(uniqueName, this.repositoryHelper, this.serviceName, this.serverName);
        EntityDetail entity = this.repositoryHandler.getUniqueEntityByName(userId, uniqueName, "uniqueName", builder.getQualifiedNameInstanceProperties(methodName), "fe30a033-8f86-4d17-8986-e6166fa24177", "SoftwareServerCapability", methodName);
        if (entity != null) {
            SoftwareServerCapabilityConverter converter = new SoftwareServerCapabilityConverter(entity, this.repositoryHelper, this.serviceName);
            return converter.getBean();
        }
        return null;
    }

    public List<String> getSoftwareServerCapabilityGUIDsByType(String userId, String typeGUID, String typeName, int startingFrom, int maxPageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startingFrom, maxPageSize, methodName);
        List entities = this.repositoryHandler.getEntitiesForType(userId, typeGUID, typeName, startingFrom, queryPageSize, methodName);
        if (entities != null) {
            ArrayList<String> guids = new ArrayList<String>();
            for (EntityDetail entity : entities) {
                if (entity == null) continue;
                guids.add(entity.getGUID());
            }
            if (!guids.isEmpty()) {
                return guids;
            }
        }
        return null;
    }

    public List<SoftwareServerCapability> getSoftwareServerCapabilitiesByType(String userId, String typeGUID, String typeName, int startingFrom, int maxPageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startingFrom, maxPageSize, methodName);
        List entities = this.repositoryHandler.getEntitiesForType(userId, typeGUID, typeName, startingFrom, queryPageSize, methodName);
        if (entities != null) {
            ArrayList<SoftwareServerCapability> softwareServerCapabilities = new ArrayList<SoftwareServerCapability>();
            for (EntityDetail entity : entities) {
                if (entity == null) continue;
                SoftwareServerCapabilityConverter converter = new SoftwareServerCapabilityConverter(entity, this.repositoryHelper, this.serviceName);
                softwareServerCapabilities.add(converter.getBean());
            }
            if (!softwareServerCapabilities.isEmpty()) {
                return softwareServerCapabilities;
            }
        }
        return null;
    }

    public List<SoftwareServerCapability> getSoftwareServerCapabilitiesByClassification(String userId, String classificationName, int startingFrom, int maxPageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startingFrom, maxPageSize, methodName);
        List entities = this.repositoryHandler.getEntitiesForClassificationType(userId, "fe30a033-8f86-4d17-8986-e6166fa24177", classificationName, startingFrom, queryPageSize, methodName);
        if (entities != null) {
            ArrayList<SoftwareServerCapability> softwareServerCapabilities = new ArrayList<SoftwareServerCapability>();
            for (EntityDetail entity : entities) {
                if (entity == null) continue;
                SoftwareServerCapabilityConverter converter = new SoftwareServerCapabilityConverter(entity, this.repositoryHelper, this.serviceName);
                softwareServerCapabilities.add(converter.getBean());
            }
            if (!softwareServerCapabilities.isEmpty()) {
                return softwareServerCapabilities;
            }
        }
        return null;
    }

    public List<String> getSoftwareServerCapabilityGUIDsByClassification(String userId, String classificationName, int startingFrom, int maxPageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startingFrom, maxPageSize, methodName);
        List entities = this.repositoryHandler.getEntitiesForClassificationType(userId, "fe30a033-8f86-4d17-8986-e6166fa24177", classificationName, startingFrom, queryPageSize, methodName);
        if (entities != null) {
            ArrayList<String> guids = new ArrayList<String>();
            for (EntityDetail entity : entities) {
                if (entity == null) continue;
                guids.add(entity.getGUID());
            }
            if (!guids.isEmpty()) {
                return guids;
            }
        }
        return null;
    }

    public void verifyIntegratorIdentity(String userId, String integratorGUID, String integratorName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (integratorGUID == null && integratorName == null) {
            return;
        }
        try {
            SoftwareServerCapability integrator = this.getSoftwareServerCapabilityByGUID(userId, integratorGUID, methodName);
            if (integrator == null) {
                throw new InvalidParameterException(OMAGOCFErrorCode.INTEGRATOR_NOT_RETURNED.getMessageDefinition(new String[]{this.serviceName, methodName, integratorGUID, integratorName, null}), this.getClass().getName(), methodName, integratorGUID);
            }
            if (!integratorName.equals(integrator.getQualifiedName())) {
                throw new InvalidParameterException(OMAGOCFErrorCode.BAD_INTEGRATOR_NAME.getMessageDefinition(new String[]{this.serviceName, methodName, integratorName, integrator.getQualifiedName(), integratorGUID}), this.getClass().getName(), methodName, integratorGUID);
            }
        }
        catch (InvalidParameterException error) {
            throw new InvalidParameterException(OMAGOCFErrorCode.INTEGRATOR_NOT_RETURNED.getMessageDefinition(new String[]{this.serviceName, methodName, integratorGUID, integratorName, error.getMessage()}), this.getClass().getName(), methodName, (Throwable)error, integratorGUID);
        }
    }

    void setVendorPropertiesForCapability(String userId, String capabilityGUID, Map<String, String> vendorProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }
}

