/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ConnectorTypeBuilder
extends ReferenceableBuilder {
    private String displayName;
    private String description;
    private String connectorProviderClassName = null;
    private List<String> recognizedAdditionalProperties = null;
    private List<String> recognizedSecuredProperties = null;
    private List<String> recognizedConfigurationProperties = null;

    public ConnectorTypeBuilder(String qualifiedName, String displayName, String description, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
    }

    public ConnectorTypeBuilder(String qualifiedName, String displayName, String description, String connectorProviderClassName, List<String> recognizedAdditionalProperties, List<String> recognizedSecuredProperties, List<String> recognizedConfigurationProperties, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, "ConnectorType", "954421eb-33a6-462d-a8ca-b5709a1bd0d4", extendedProperties, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
        this.connectorProviderClassName = connectorProviderClassName;
        this.recognizedAdditionalProperties = recognizedAdditionalProperties;
        this.recognizedSecuredProperties = recognizedSecuredProperties;
        this.recognizedConfigurationProperties = recognizedConfigurationProperties;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.displayName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "displayName", this.displayName, methodName);
        }
        if (this.description != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", this.description, methodName);
        }
        if (this.connectorProviderClassName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "connectorProviderClassName", this.connectorProviderClassName, methodName);
        }
        if (this.recognizedAdditionalProperties != null) {
            properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, "recognizedAdditionalProperties", this.recognizedAdditionalProperties, methodName);
        }
        if (this.recognizedSecuredProperties != null) {
            properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, "recognizedSecuredProperties", this.recognizedSecuredProperties, methodName);
        }
        if (this.recognizedConfigurationProperties != null) {
            properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, "recognizedConfigurationProperties", this.recognizedConfigurationProperties, methodName);
        }
        return properties;
    }

    @Override
    public InstanceProperties getQualifiedNameInstanceProperties(String methodName) {
        return super.getNameInstanceProperties(methodName);
    }

    @Override
    public InstanceProperties getNameInstanceProperties(String methodName) {
        InstanceProperties properties = super.getNameInstanceProperties(methodName);
        if (this.displayName != null) {
            String literalName = this.repositoryHelper.getExactMatchRegex(this.displayName);
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "displayName", literalName, methodName);
        }
        return properties;
    }
}

