/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.DataItemSortOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SchemaAttributeBuilder
extends ReferenceableBuilder {
    private String displayName;
    private String description = null;
    private int elementPosition = 0;
    private int minCardinality = 0;
    private int maxCardinality = 0;
    private boolean isDeprecated = false;
    private String cardinality = null;
    private boolean allowsDuplicateValues = false;
    private boolean orderedValues = false;
    private EnumPropertyValue sortOrder = null;
    private int minimumLength = 0;
    private int length = 0;
    private int significantDigits = 0;
    private boolean isNullable = true;
    private String defaultValueOverride = null;
    private String nativeJavaClass = null;
    private List<String> aliases = null;
    private String formula = null;

    public SchemaAttributeBuilder(String qualifiedName, String displayName, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, "SchemaAttribute", "1a5e159b-913a-43b1-95fe-04433b25fca9", repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
    }

    @Deprecated
    public SchemaAttributeBuilder(String qualifiedName, String displayName, int elementPosition, String cardinality, String defaultValueOverride, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, "SchemaAttribute", "1a5e159b-913a-43b1-95fe-04433b25fca9", extendedProperties, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.elementPosition = elementPosition;
        this.cardinality = cardinality;
        this.minCardinality = 0;
        this.maxCardinality = 0;
        this.defaultValueOverride = defaultValueOverride;
    }

    public SchemaAttributeBuilder(String qualifiedName, String displayName, String description, int elementPosition, int minCardinality, int maxCardinality, boolean isDeprecated, String defaultValueOverride, boolean allowsDuplicateValues, boolean orderedValues, EnumPropertyValue sortOrder, int minimumLength, int length, int significantDigits, boolean isNullable, String nativeJavaClass, List<String> aliases, Map<String, String> additionalProperties, String anchorGUID, String typeName, String typeId, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, typeName, typeId, extendedProperties, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
        this.elementPosition = elementPosition;
        this.cardinality = null;
        this.minCardinality = minCardinality;
        this.maxCardinality = maxCardinality;
        this.isDeprecated = isDeprecated;
        this.defaultValueOverride = defaultValueOverride;
        this.allowsDuplicateValues = allowsDuplicateValues;
        this.orderedValues = orderedValues;
        this.sortOrder = sortOrder;
        this.minimumLength = minimumLength;
        this.length = length;
        this.significantDigits = significantDigits;
        this.isNullable = isNullable;
        this.nativeJavaClass = nativeJavaClass;
        this.aliases = aliases;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.displayName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "displayName", this.displayName, methodName);
        }
        if (this.description != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", this.description, methodName);
        }
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, "position", this.elementPosition, methodName);
        if (this.cardinality != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "cardinality", this.cardinality, methodName);
        }
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, "minCardinality", this.minCardinality, methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, "maxCardinality", this.maxCardinality, methodName);
        properties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, properties, "isDeprecated", this.isDeprecated, methodName);
        if (this.defaultValueOverride != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "defaultValueOverride", this.defaultValueOverride, methodName);
        }
        properties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, properties, "allowsDuplicateValues", this.allowsDuplicateValues, methodName);
        properties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, properties, "orderedValues", this.orderedValues, methodName);
        if (this.sortOrder != null) {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, "sortOrder", this.sortOrder.getOrdinal(), this.sortOrder.getSymbolicName(), this.sortOrder.getDescription(), methodName);
        }
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, "minimumLength", this.minimumLength, methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, "length", this.length, methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, "significantDigits", this.significantDigits, methodName);
        properties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, properties, "isNullable", this.isNullable, methodName);
        if (this.nativeJavaClass != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "nativeClass", this.nativeJavaClass, methodName);
        }
        if (this.aliases != null && !this.aliases.isEmpty()) {
            properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, "aliases", this.aliases, methodName);
        }
        if (this.formula != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "formula", this.formula, methodName);
        }
        return properties;
    }

    @Override
    public InstanceProperties getNameInstanceProperties(String methodName) {
        InstanceProperties properties = super.getNameInstanceProperties(methodName);
        if (this.displayName != null) {
            String literalName = this.repositoryHelper.getExactMatchRegex(this.displayName);
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "displayName", literalName, methodName);
        }
        return properties;
    }

    @Override
    public InstanceProperties getQualifiedNameInstanceProperties(String methodName) {
        return super.getNameInstanceProperties(methodName);
    }

    private InstanceProperties addSortOrderPropertyToInstance(InstanceProperties properties, DataItemSortOrder sortOrder, String methodName) {
        int ordinal = 99;
        String symbolicName = null;
        String description = null;
        boolean element1Ordinal = false;
        String element1Value = "Ascending";
        String element1Description = "Sort the data values so that they increase in value.";
        boolean element2Ordinal = true;
        String element2Value = "Descending";
        String element2Description = "Sort the data values so that they decrease in value.";
        int element3Ordinal = 99;
        String element3Value = "Ignore";
        String element3Description = "No specific sort order.";
        switch (sortOrder) {
            case ASCENDING: {
                ordinal = 0;
                symbolicName = "Ascending";
                description = "Sort the data values so that they increase in value.";
                break;
            }
            case DESCENDING: {
                ordinal = 1;
                symbolicName = "Descending";
                description = "Sort the data values so that they decrease in value.";
                break;
            }
            case UNSORTED: {
                ordinal = 99;
                symbolicName = "Ignore";
                description = "No specific sort order.";
            }
        }
        return this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, "sortOrder", ordinal, symbolicName, description, methodName);
    }
}

