/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.EndpointBuilder;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.EndpointConverter;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.RootHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class EndpointHandler
extends RootHandler {
    public EndpointHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper) {
        super(serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper);
    }

    String findEndpoint(String userId, Endpoint endpoint, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "endpoint.getGUID";
        String qualifiedNameParameter = "endpoint.getQualifiedName";
        if (endpoint != null) {
            if (endpoint.getGUID() != null && this.repositoryHandler.isEntityKnown(userId, endpoint.getGUID(), "Endpoint", methodName, "endpoint.getGUID") != null) {
                return endpoint.getGUID();
            }
            this.invalidParameterHandler.validateName(endpoint.getQualifiedName(), "endpoint.getQualifiedName", methodName);
            EndpointBuilder endpointBuilder = new EndpointBuilder(endpoint.getQualifiedName(), endpoint.getDisplayName(), endpoint.getDescription(), this.repositoryHelper, this.serviceName, this.serverName);
            EntityDetail existingEndpoint = this.repositoryHandler.getUniqueEntityByName(userId, endpoint.getQualifiedName(), "endpoint.getQualifiedName", endpointBuilder.getQualifiedNameInstanceProperties(methodName), "dbc20663-d705-4ff0-8424-80c262c6b8e7", "Endpoint", methodName);
            if (existingEndpoint != null) {
                return existingEndpoint.getGUID();
            }
        }
        return null;
    }

    public String saveEndpoint(String userId, String externalSourceGUID, String externalSourceName, Endpoint endpoint) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "saveEndpoint";
        String existingEndpoint = this.findEndpoint(userId, endpoint, "saveEndpoint");
        if (existingEndpoint == null) {
            return this.addEndpoint(userId, externalSourceGUID, externalSourceName, endpoint);
        }
        return this.updateEndpoint(userId, externalSourceGUID, externalSourceName, existingEndpoint, endpoint);
    }

    String addEndpoint(String userId, String externalSourceGUID, String externalSourceName, Endpoint endpoint) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addEndpoint";
        EndpointBuilder endpointBuilder = new EndpointBuilder(endpoint.getQualifiedName(), endpoint.getDisplayName(), endpoint.getDescription(), endpoint.getAddress(), endpoint.getProtocol(), endpoint.getEncryptionMethod(), endpoint.getAdditionalProperties(), endpoint.getExtendedProperties(), this.repositoryHelper, this.serviceName, this.serverName);
        return this.repositoryHandler.createEntity(userId, externalSourceGUID, externalSourceName, "dbc20663-d705-4ff0-8424-80c262c6b8e7", "Endpoint", endpointBuilder.getInstanceProperties("addEndpoint"), "addEndpoint");
    }

    String updateEndpoint(String userId, String externalSourceGUID, String externalSourceName, String existingEndpointGUID, Endpoint endpoint) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateEndpoint";
        EndpointBuilder endpointBuilder = new EndpointBuilder(endpoint.getQualifiedName(), endpoint.getDisplayName(), endpoint.getDescription(), endpoint.getAddress(), endpoint.getProtocol(), endpoint.getEncryptionMethod(), endpoint.getAdditionalProperties(), endpoint.getExtendedProperties(), this.repositoryHelper, this.serviceName, this.serverName);
        this.repositoryHandler.updateEntityProperties(userId, externalSourceGUID, externalSourceName, existingEndpointGUID, "dbc20663-d705-4ff0-8424-80c262c6b8e7", "Endpoint", endpointBuilder.getInstanceProperties("updateEndpoint"), "updateEndpoint");
        return existingEndpointGUID;
    }

    public void removeEndpoint(String userId, String externalSourceGUID, String externalSourceName, String endpointGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeEndpoint";
        String guidParameterName = "endpointGUID";
        this.repositoryHandler.removeEntityOnLastUse(userId, externalSourceGUID, externalSourceName, endpointGUID, "endpointGUID", "dbc20663-d705-4ff0-8424-80c262c6b8e7", "Endpoint", "removeEndpoint");
    }

    public Endpoint getEndpoint(String userId, String endpointGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getEndpoint";
        String guidParameterName = "endpointGUID";
        EntityDetail endpointEntity = this.repositoryHandler.getEntityByGUID(userId, endpointGUID, "endpointGUID", "Endpoint", "getEndpoint");
        EndpointConverter converter = new EndpointConverter(endpointEntity, this.repositoryHelper, this.serviceName, this.serverName);
        return converter.getBean();
    }

    public List<Endpoint> getEndpointsByNetworkAddress(String userId, String networkAddress, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String addressParameterName = "networkAddress";
        this.invalidParameterHandler.validateName(networkAddress, "networkAddress", methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        EndpointBuilder builder = new EndpointBuilder(null, null, null, networkAddress, null, null, null, null, this.repositoryHelper, this.serviceName, this.serverName);
        ArrayList<Endpoint> results = new ArrayList<Endpoint>();
        List retrievedEntities = this.repositoryHandler.getEntitiesByName(userId, builder.getNetworkAddressInstanceProperties(methodName), "dbc20663-d705-4ff0-8424-80c262c6b8e7", "networkAddress", startFrom, queryPageSize, methodName);
        if (retrievedEntities != null) {
            for (EntityDetail entity : retrievedEntities) {
                if (entity == null) continue;
                EndpointConverter converter = new EndpointConverter(entity, this.repositoryHelper, this.serviceName, this.serverName);
                results.add(converter.getBean());
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }
}

