/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders;

import java.util.Map;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class EndpointBuilder
extends ReferenceableBuilder {
    private String displayName;
    private String description;
    private String networkAddress = null;
    private String protocol = null;
    private String encryptionMethod = null;

    public EndpointBuilder(String qualifiedName, String displayName, String description, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
    }

    public EndpointBuilder(String qualifiedName, String displayName, String description, String networkAddress, String protocol, String encryptionMethod, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, extendedProperties, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
        this.networkAddress = networkAddress;
        this.protocol = protocol;
        this.encryptionMethod = encryptionMethod;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.displayName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "name", this.displayName, methodName);
        }
        if (this.description != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", this.description, methodName);
        }
        if (this.networkAddress != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "networkAddress", this.networkAddress, methodName);
        }
        if (this.protocol != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "protocol", this.protocol, methodName);
        }
        if (this.encryptionMethod != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "encryptionMethod", this.encryptionMethod, methodName);
        }
        return properties;
    }

    @Override
    public InstanceProperties getQualifiedNameInstanceProperties(String methodName) {
        return super.getNameInstanceProperties(methodName);
    }

    @Override
    public InstanceProperties getNameInstanceProperties(String methodName) {
        InstanceProperties properties = super.getNameInstanceProperties(methodName);
        if (this.displayName != null) {
            String literalName = this.repositoryHelper.getExactMatchRegex(this.displayName);
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "name", literalName, methodName);
        }
        return properties;
    }

    public InstanceProperties getNetworkAddressInstanceProperties(String methodName) {
        InstanceProperties properties = null;
        if (this.networkAddress != null) {
            String literalName = this.repositoryHelper.getExactMatchRegex(this.displayName);
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "networkAddress", literalName, methodName);
        }
        return properties;
    }
}

