/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders;

import java.util.Map;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GlossaryTermBuilder
extends ReferenceableBuilder {
    private String displayName;
    private String description;
    private String summary = null;
    private String examples = null;
    private String abbreviation = null;
    private String usage = null;

    public GlossaryTermBuilder(String qualifiedName, String displayName, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
    }

    public GlossaryTermBuilder(String qualifiedName, String displayName, String summary, String description, String examples, String abbreviation, String usage, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, extendedProperties, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.summary = summary;
        this.description = description;
        this.examples = examples;
        this.abbreviation = abbreviation;
        this.usage = usage;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.displayName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "displayName", this.displayName, methodName);
        }
        if (this.summary != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "summary", this.description, methodName);
        }
        if (this.description != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", this.description, methodName);
        }
        if (this.examples != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "examples", this.description, methodName);
        }
        if (this.abbreviation != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "abbreviation", this.description, methodName);
        }
        if (this.usage != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "usage", this.description, methodName);
        }
        return properties;
    }

    @Override
    public InstanceProperties getQualifiedNameInstanceProperties(String methodName) {
        return super.getNameInstanceProperties(methodName);
    }

    @Override
    public InstanceProperties getNameInstanceProperties(String methodName) {
        InstanceProperties properties = super.getNameInstanceProperties(methodName);
        if (this.displayName != null) {
            String literalName = this.repositoryHelper.getExactMatchRegex(this.displayName);
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "displayName", literalName, methodName);
        }
        return properties;
    }

    public InstanceProperties getSearchInstanceProperties(String methodName) {
        InstanceProperties properties = null;
        if (this.qualifiedName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "qualifiedName", this.qualifiedName, methodName);
        }
        if (this.displayName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "displayName", this.displayName, methodName);
        }
        if (this.description != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", this.description, methodName);
        }
        return properties;
    }
}

