/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters;

import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.ReferenceableConverter;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.BoundedSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ComplexSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.EnumSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.LiteralSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.MapSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.PrimitiveSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Referenceable;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaTypeChoice;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SimpleSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.StructSchemaType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SchemaTypeConverter
extends ReferenceableConverter {
    private InstanceProperties schemaTypeProperties;
    private int schemaAttributeCount;

    public SchemaTypeConverter(String typeName, InstanceProperties properties, int schemaAttributeCount, OMRSRepositoryHelper repositoryHelper, String serviceName) {
        super(null, repositoryHelper, serviceName);
        this.typeName = typeName;
        this.schemaTypeProperties = properties;
        this.schemaAttributeCount = schemaAttributeCount;
    }

    public SchemaTypeConverter(EntityDetail entity, int schemaAttributeCount, OMRSRepositoryHelper repositoryHelper, String serviceName) {
        super(entity, repositoryHelper, serviceName);
        if (entity != null) {
            InstanceType type = entity.getType();
            if (type != null) {
                this.typeName = type.getTypeDefName();
            }
            this.schemaTypeProperties = entity.getProperties();
            this.schemaAttributeCount = schemaAttributeCount;
        }
    }

    public SchemaType getBean() {
        if (this.typeName != null && this.schemaTypeProperties != null) {
            if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "PrimitiveSchemaType")) {
                return this.getPrimitiveSchemaTypeBean();
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "EnumSchemaType")) {
                return this.getEnumSchemaTypeBean();
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "SimpleSchemaType")) {
                return this.getSimpleSchemaTypeBean();
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "StructSchemaType")) {
                return this.getStructSchemaTypeBean();
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "ComplexSchemaType")) {
                return this.getComplexSchemaTypeBean();
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "LiteralSchemaType")) {
                return this.getLiteralSchemaTypeBean();
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "MapSchemaType")) {
                return this.getMapSchemaTypeBean();
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "SchemaTypeChoice")) {
                return this.getSchemaTypeChoiceBean();
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, this.typeName, "BoundedSchemaType")) {
                return this.getBoundedSchemaTypeBean();
            }
            return this.getBasicSchemaTypeBean();
        }
        return null;
    }

    private void updateBasicSchemaTypeProperties(SchemaType bean, InstanceProperties instanceProperties, String methodName) {
        if (instanceProperties != null) {
            bean.setQualifiedName(this.repositoryHelper.removeStringProperty(this.serviceName, "qualifiedName", instanceProperties, methodName));
            bean.setDisplayName(this.repositoryHelper.removeStringProperty(this.serviceName, "displayName", instanceProperties, methodName));
            bean.setVersionNumber(this.repositoryHelper.removeStringProperty(this.serviceName, "versionNumber", instanceProperties, methodName));
            bean.setAuthor(this.repositoryHelper.removeStringProperty(this.serviceName, "author", instanceProperties, methodName));
            bean.setUsage(this.repositoryHelper.removeStringProperty(this.serviceName, "usage", instanceProperties, methodName));
            bean.setEncodingStandard(this.repositoryHelper.removeStringProperty(this.serviceName, "encodingStandard", instanceProperties, methodName));
            bean.setAdditionalProperties(this.repositoryHelper.removeStringMapFromProperty(this.serviceName, "additionalProperties", instanceProperties, methodName));
        }
    }

    private void updateLiteralSchemaTypeProperties(LiteralSchemaType bean, InstanceProperties instanceProperties, String methodName) {
        if (instanceProperties != null) {
            this.updateBasicSchemaTypeProperties((SchemaType)bean, instanceProperties, methodName);
            bean.setDataType(this.repositoryHelper.removeStringProperty(this.serviceName, "dataType", instanceProperties, methodName));
            bean.setFixedValue(this.repositoryHelper.removeStringProperty(this.serviceName, "fixedValue", instanceProperties, methodName));
        }
    }

    private void updateSimpleSchemaTypeProperties(SimpleSchemaType bean, InstanceProperties instanceProperties, String methodName) {
        if (instanceProperties != null) {
            this.updateBasicSchemaTypeProperties((SchemaType)bean, instanceProperties, methodName);
            bean.setDataType(this.repositoryHelper.removeStringProperty(this.serviceName, "dataType", instanceProperties, methodName));
            bean.setDefaultValue(this.repositoryHelper.removeStringProperty(this.serviceName, "defaultValue", instanceProperties, methodName));
        }
    }

    private void updateComplexSchemaTypeProperties(ComplexSchemaType bean, InstanceProperties instanceProperties, String methodName) {
        if (instanceProperties != null) {
            this.updateBasicSchemaTypeProperties((SchemaType)bean, instanceProperties, methodName);
        }
        bean.setAttributeCount(this.schemaAttributeCount);
    }

    SchemaType getBasicSchemaTypeBean() {
        String methodName = "getBasicSchemaTypeBean";
        SchemaType bean = new SchemaType();
        super.updateBean((Referenceable)bean);
        InstanceProperties instanceProperties = new InstanceProperties(this.schemaTypeProperties);
        this.updateBasicSchemaTypeProperties(bean, instanceProperties, "getBasicSchemaTypeBean");
        bean.setExtendedProperties(this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties));
        return bean;
    }

    SchemaType getSchemaTypeChoiceBean() {
        String methodName = "getSchemaTypeChoiceBean";
        SchemaTypeChoice bean = new SchemaTypeChoice();
        super.updateBean((Referenceable)bean);
        InstanceProperties instanceProperties = new InstanceProperties(this.schemaTypeProperties);
        this.updateBasicSchemaTypeProperties((SchemaType)bean, instanceProperties, "getSchemaTypeChoiceBean");
        bean.setExtendedProperties(this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties));
        return bean;
    }

    SchemaType getMapSchemaTypeBean() {
        String methodName = "getMapSchemaTypeBean";
        MapSchemaType bean = new MapSchemaType();
        super.updateBean((Referenceable)bean);
        InstanceProperties instanceProperties = new InstanceProperties(this.schemaTypeProperties);
        this.updateBasicSchemaTypeProperties((SchemaType)bean, instanceProperties, "getMapSchemaTypeBean");
        bean.setExtendedProperties(this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties));
        return bean;
    }

    SchemaType getBoundedSchemaTypeBean() {
        String methodName = "getBoundedSchemaTypeBean";
        BoundedSchemaType bean = new BoundedSchemaType();
        super.updateBean((Referenceable)bean);
        InstanceProperties instanceProperties = new InstanceProperties(this.schemaTypeProperties);
        this.updateBasicSchemaTypeProperties((SchemaType)bean, instanceProperties, "getBoundedSchemaTypeBean");
        bean.setExtendedProperties(this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties));
        return bean;
    }

    SchemaType getSimpleSchemaTypeBean() {
        String methodName = "getSimpleSchemaTypeBean";
        SimpleSchemaType bean = new SimpleSchemaType();
        super.updateBean((Referenceable)bean);
        InstanceProperties instanceProperties = new InstanceProperties(this.schemaTypeProperties);
        this.updateSimpleSchemaTypeProperties(bean, instanceProperties, "getSimpleSchemaTypeBean");
        bean.setExtendedProperties(this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties));
        return bean;
    }

    private SchemaType getEnumSchemaTypeBean() {
        String methodName = "getEnumSchemaTypeBean";
        EnumSchemaType bean = new EnumSchemaType();
        super.updateBean((Referenceable)bean);
        InstanceProperties instanceProperties = new InstanceProperties(this.schemaTypeProperties);
        this.updateSimpleSchemaTypeProperties((SimpleSchemaType)bean, instanceProperties, "getEnumSchemaTypeBean");
        bean.setExtendedProperties(this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties));
        return bean;
    }

    private SchemaType getPrimitiveSchemaTypeBean() {
        String methodName = "getPrimitiveSchemaTypeBean";
        PrimitiveSchemaType bean = new PrimitiveSchemaType();
        super.updateBean((Referenceable)bean);
        InstanceProperties instanceProperties = new InstanceProperties(this.schemaTypeProperties);
        this.updateSimpleSchemaTypeProperties((SimpleSchemaType)bean, instanceProperties, "getPrimitiveSchemaTypeBean");
        bean.setExtendedProperties(this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties));
        return bean;
    }

    private SchemaType getLiteralSchemaTypeBean() {
        String methodName = "getLiteralSchemaTypeBean";
        LiteralSchemaType bean = new LiteralSchemaType();
        super.updateBean((Referenceable)bean);
        InstanceProperties instanceProperties = new InstanceProperties(this.schemaTypeProperties);
        this.updateLiteralSchemaTypeProperties(bean, instanceProperties, "getLiteralSchemaTypeBean");
        bean.setExtendedProperties(this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties));
        return bean;
    }

    private SchemaType getComplexSchemaTypeBean() {
        String methodName = "getComplexSchemaTypeBean";
        ComplexSchemaType bean = new ComplexSchemaType();
        super.updateBean((Referenceable)bean);
        InstanceProperties instanceProperties = new InstanceProperties(this.schemaTypeProperties);
        this.updateComplexSchemaTypeProperties(bean, instanceProperties, "getComplexSchemaTypeBean");
        bean.setExtendedProperties(this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties));
        return bean;
    }

    private SchemaType getStructSchemaTypeBean() {
        String methodName = "getStructSchemaTypeBean";
        StructSchemaType bean = new StructSchemaType();
        super.updateBean((Referenceable)bean);
        InstanceProperties instanceProperties = new InstanceProperties(this.schemaTypeProperties);
        this.updateComplexSchemaTypeProperties((ComplexSchemaType)bean, instanceProperties, "getStructSchemaTypeBean");
        bean.setExtendedProperties(this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties));
        return bean;
    }
}

