/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.GlossaryTermBuilder;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.GlossaryTermConverter;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.AttachmentHandlerBase;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.LastAttachmentHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.properties.GlossaryTerm;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GlossaryTermHandler
extends AttachmentHandlerBase {
    public GlossaryTermHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, LastAttachmentHandler lastAttachmentHandler) {
        super(serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, lastAttachmentHandler);
    }

    public List<GlossaryTerm> getMeaningByName(String userId, String name, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nameParameter = "name";
        ArrayList<GlossaryTerm> results = new ArrayList<GlossaryTerm>();
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, "name", methodName);
        GlossaryTermBuilder glossaryTermBuilder = new GlossaryTermBuilder(name, name, this.repositoryHelper, this.serviceName, this.serverName);
        List glossaryTerms = this.repositoryHandler.getEntitiesByName(userId, glossaryTermBuilder.getSearchInstanceProperties(methodName), "0db3e6ec-f5ef-4d75-ae38-b7ee6fd6ec0a", startFrom, pageSize, methodName);
        if (glossaryTerms != null) {
            for (EntityDetail entity : glossaryTerms) {
                if (entity == null) continue;
                GlossaryTermConverter converter = new GlossaryTermConverter(entity, this.repositoryHelper, this.serviceName);
                results.add(converter.getBean());
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<GlossaryTerm> findMeanings(String userId, String name, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nameParameter = "name";
        ArrayList<GlossaryTerm> results = new ArrayList<GlossaryTerm>();
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, "name", methodName);
        GlossaryTermBuilder glossaryTermBuilder = new GlossaryTermBuilder(name, name, this.repositoryHelper, this.serviceName, this.serverName);
        List glossaryTerms = this.repositoryHandler.getEntitiesByName(userId, glossaryTermBuilder.getSearchInstanceProperties(methodName), "0db3e6ec-f5ef-4d75-ae38-b7ee6fd6ec0a", startFrom, pageSize, methodName);
        if (glossaryTerms != null) {
            for (EntityDetail entity : glossaryTerms) {
                if (entity == null) continue;
                GlossaryTermConverter converter = new GlossaryTermConverter(entity, this.repositoryHelper, this.serviceName);
                results.add(converter.getBean());
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public GlossaryTerm getMeaning(String userId, String guid, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameter = "guid";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(guid, "guid", methodName);
        EntityDetail entity = this.repositoryHandler.getEntityByGUID(userId, guid, "guid", "GlossaryTerm", methodName);
        GlossaryTermConverter converter = new GlossaryTermConverter(entity, this.repositoryHelper, this.serviceName);
        return converter.getBean();
    }
}

