/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.AssetBuilder;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.AssetConverter;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.AssetHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.ConnectionHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.ConnectorTypeHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.EndpointHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.GlossaryTermHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.SchemaTypeHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.SoftwareServerCapabilityHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Asset;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ComplexSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.DataItemSortOrder;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementOrigin;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.KeyPattern;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.OwnerType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.RelatedAsset;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttribute;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaImplementationQuery;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class RelationalDataHandler {
    private final String integratorGUIDParameterName = "integratorGUID";
    private final String integratorNameParameterName = "integratorName";
    private String serviceName;
    private String serverName;
    private List<String> defaultZones;
    private List<String> supportedZones;
    private List<String> publishZones;
    private OMRSRepositoryHelper repositoryHelper;
    private RepositoryHandler repositoryHandler;
    private InvalidParameterHandler invalidParameterHandler;
    private AssetHandler assetHandler;
    private ConnectionHandler connectionHandler;
    private ConnectorTypeHandler connectorTypeHandler;
    private EndpointHandler endpointHandler;
    private GlossaryTermHandler glossaryTermHandler;
    private SchemaTypeHandler schemaTypeHandler;
    private SoftwareServerCapabilityHandler softwareServerCapabilityHandler;

    public RelationalDataHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, List<String> defaultZones, List<String> supportedZones, List<String> publishZones, AssetHandler assetHandler, ConnectionHandler connectionHandler, SchemaTypeHandler schemaTypeHandler, SoftwareServerCapabilityHandler softwareServerCapabilityHandler, GlossaryTermHandler glossaryTermHandler) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.defaultZones = defaultZones;
        this.supportedZones = supportedZones;
        this.publishZones = publishZones;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHandler = repositoryHandler;
        this.repositoryHelper = repositoryHelper;
        this.assetHandler = assetHandler;
        this.connectionHandler = connectionHandler;
        this.softwareServerCapabilityHandler = softwareServerCapabilityHandler;
        this.endpointHandler = new EndpointHandler(serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper);
        this.connectorTypeHandler = new ConnectorTypeHandler(serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper);
        this.schemaTypeHandler = schemaTypeHandler;
        this.glossaryTermHandler = glossaryTermHandler;
    }

    public String createDatabase(String userId, String integratorGUID, String integratorName, String qualifiedName, String displayName, String description, String owner, OwnerType ownerType, List<String> zoneMembership, Map<String, String> origin, String latestChange, Date createTime, Date modifiedTime, String encodingType, String encodingLanguage, String encodingDescription, String databaseType, String databaseVersion, String databaseInstance, String databaseImportedFrom, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(integratorGUID, "integratorGUID", methodName);
        this.invalidParameterHandler.validateName(integratorName, "integratorName", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.softwareServerCapabilityHandler.verifyIntegratorIdentity(userId, integratorGUID, integratorName, methodName);
        String assetTypeName = "Database";
        if (typeName != null) {
            assetTypeName = typeName;
        }
        Asset asset = integratorGUID == null ? this.assetHandler.createEmptyAsset(assetTypeName, methodName) : this.assetHandler.createEmptyExternalAsset(assetTypeName, ElementOrigin.EXTERNAL_SOURCE, integratorGUID, integratorName, methodName);
        this.fillDatabaseAsset(asset, qualifiedName, displayName, description, owner, ownerType, zoneMembership, origin, latestChange, createTime, modifiedTime, encodingType, encodingLanguage, encodingDescription, databaseType, databaseVersion, databaseInstance, databaseImportedFrom, additionalProperties, extendedProperties);
        return this.assetHandler.addExternalAsset(userId, asset, null, null, null, integratorGUID, integratorName, methodName);
    }

    public String createDatabaseFromTemplate(String userId, String integratorGUID, String integratorName, String templateGUID, String qualifiedName, String displayName, String description, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(integratorGUID, "integratorGUID", methodName);
        this.invalidParameterHandler.validateName(integratorName, "integratorName", methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
        return this.assetHandler.addExternalAssetFromTemplate(userId, templateGUID, "Database", qualifiedName, displayName, description, integratorGUID, integratorName, methodName);
    }

    public void updateDatabase(String userId, String integratorGUID, String integratorName, String databaseGUID, String qualifiedName, String displayName, String description, String owner, OwnerType ownerType, List<String> zoneMembership, Map<String, String> origin, String latestChange, Date createTime, Date modifiedTime, String encodingType, String encodingLanguage, String encodingDescription, String databaseType, String databaseVersion, String databaseInstance, String databaseImportedFrom, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        AssetConverter converter;
        String elementGUIDParameterName = "databaseGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(databaseGUID, "databaseGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String assetTypeName = "Database";
        if (typeName != null) {
            assetTypeName = typeName;
        }
        if ((converter = this.assetHandler.retrieveAssetConverterFromRepositoryByGUID(userId, databaseGUID, "databaseGUID", assetTypeName, methodName)) != null) {
            Asset originalAsset = converter.getAssetBean();
            this.invalidParameterHandler.validateAssetInSupportedZone(databaseGUID, "databaseGUID", originalAsset.getZoneMembership(), this.supportedZones, this.serviceName, methodName);
            ElementOrigin expectedElementOrigin = ElementOrigin.EXTERNAL_SOURCE;
            if (integratorGUID == null) {
                expectedElementOrigin = ElementOrigin.LOCAL_COHORT;
            }
            this.invalidParameterHandler.validateInstanceProvenanceForUpdate(databaseGUID, "databaseGUID", (ElementHeader)originalAsset, expectedElementOrigin, integratorGUID, integratorName, this.serviceName, methodName);
            Asset updatedAsset = new Asset(originalAsset);
            this.fillDatabaseAsset(updatedAsset, qualifiedName, displayName, description, owner, ownerType, zoneMembership, origin, latestChange, createTime, modifiedTime, encodingType, encodingLanguage, encodingDescription, databaseType, databaseVersion, databaseInstance, databaseImportedFrom, additionalProperties, extendedProperties);
            this.assetHandler.updateAsset(userId, originalAsset, converter.getAssetAuditHeader(), updatedAsset, null, null, null, methodName);
        }
    }

    private void fillDatabaseAsset(Asset asset, String qualifiedName, String displayName, String description, String owner, OwnerType ownerType, List<String> zoneMembership, Map<String, String> origin, String latestChange, Date createTime, Date modifiedTime, String encodingType, String encodingLanguage, String encodingDescription, String databaseType, String databaseVersion, String databaseInstance, String databaseImportedFrom, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        asset.setQualifiedName(qualifiedName);
        asset.setDisplayName(displayName);
        asset.setDescription(description);
        asset.setOwner(owner);
        asset.setOwnerType(ownerType);
        asset.setZoneMembership(zoneMembership);
        asset.setOrigin(origin);
        asset.setLatestChange(latestChange);
        asset.setAdditionalProperties(additionalProperties);
        HashMap<String, Object> assetExtendedProperties = new HashMap<String, Object>();
        if (extendedProperties != null) {
            assetExtendedProperties.putAll(extendedProperties);
        }
        assetExtendedProperties.put("createTime", createTime);
        assetExtendedProperties.put("modifiedTime", modifiedTime);
        assetExtendedProperties.put("encoding", encodingType);
        assetExtendedProperties.put("language", encodingLanguage);
        assetExtendedProperties.put("description", encodingDescription);
        assetExtendedProperties.put("type", databaseType);
        assetExtendedProperties.put("version", databaseVersion);
        assetExtendedProperties.put("instance", databaseInstance);
        assetExtendedProperties.put("importedFrom", databaseImportedFrom);
        asset.setExtendedProperties(assetExtendedProperties);
    }

    public void publishDatabase(String userId, String integratorGUID, String integratorName, String databaseGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "databaseGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(databaseGUID, "databaseGUID", methodName);
        ElementOrigin expectedElementOrigin = ElementOrigin.EXTERNAL_SOURCE;
        if (integratorGUID == null) {
            expectedElementOrigin = ElementOrigin.LOCAL_COHORT;
        }
        this.assetHandler.updateAssetZones(userId, databaseGUID, "databaseGUID", expectedElementOrigin, integratorGUID, integratorName, this.publishZones, methodName);
    }

    public void withdrawDatabase(String userId, String integratorGUID, String integratorName, String databaseGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "databaseGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(databaseGUID, "databaseGUID", methodName);
        ElementOrigin expectedElementOrigin = ElementOrigin.EXTERNAL_SOURCE;
        if (integratorGUID == null) {
            expectedElementOrigin = ElementOrigin.LOCAL_COHORT;
        }
        this.assetHandler.updateAssetZones(userId, databaseGUID, "databaseGUID", expectedElementOrigin, integratorGUID, integratorName, this.defaultZones, methodName);
    }

    public void removeDatabase(String userId, String integratorGUID, String integratorName, String databaseGUID, String qualifiedName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "databaseGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(databaseGUID, "databaseGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        ElementOrigin expectedElementOrigin = ElementOrigin.EXTERNAL_SOURCE;
        if (integratorGUID == null) {
            expectedElementOrigin = ElementOrigin.LOCAL_COHORT;
        }
        this.assetHandler.removeAsset(userId, databaseGUID, qualifiedName, "databaseGUID", expectedElementOrigin, integratorGUID, integratorName, methodName);
    }

    public List<Asset> findDatabases(String userId, String searchString, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.assetHandler.findAssets(userId, "0921c83f-b2db-4086-a52c-0d10e52ca078", searchString, startFrom, pageSize, methodName);
    }

    public List<Asset> getDatabasesByName(String userId, String name, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.assetHandler.getAssetsByName(userId, "0921c83f-b2db-4086-a52c-0d10e52ca078", name, startFrom, pageSize, methodName);
    }

    public List<Asset> getDatabasesByDaemon(String userId, String integratorGUID, String integratorName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(integratorGUID, "integratorGUID", methodName);
        this.invalidParameterHandler.validateName(integratorName, "integratorName", methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
        return null;
    }

    public Asset getDatabaseByGUID(String userId, String guid, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "guid";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(guid, "guid", methodName);
        return this.assetHandler.getValidatedVisibleAsset(userId, this.supportedZones, guid, this.serviceName, methodName);
    }

    public String createDatabaseSchema(String userId, String integratorGUID, String integratorName, String databaseGUID, String qualifiedName, String displayName, String description, String owner, OwnerType ownerType, List<String> zoneMembership, Map<String, String> origin, String latestChange, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentElementGUIDParameterName = "databaseGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(integratorGUID, "integratorGUID", methodName);
        this.invalidParameterHandler.validateName(integratorName, "integratorName", methodName);
        this.invalidParameterHandler.validateGUID(databaseGUID, "databaseGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.softwareServerCapabilityHandler.verifyIntegratorIdentity(userId, integratorGUID, integratorName, methodName);
        String assetTypeName = "DeployedDatabaseSchema";
        if (typeName != null) {
            assetTypeName = typeName;
        }
        Asset asset = integratorGUID == null ? this.assetHandler.createEmptyAsset(assetTypeName, methodName) : this.assetHandler.createEmptyExternalAsset(assetTypeName, ElementOrigin.EXTERNAL_SOURCE, integratorGUID, integratorName, methodName);
        this.fillDatabaseSchemaAsset(asset, qualifiedName, displayName, description, owner, ownerType, zoneMembership, origin, latestChange, additionalProperties, extendedProperties);
        ComplexSchemaType schemaType = new ComplexSchemaType();
        schemaType.setQualifiedName(qualifiedName + "_schemaType");
        schemaType.setDisplayName(displayName);
        String databaseSchemaGUID = this.assetHandler.addExternalAsset(userId, asset, (SchemaType)schemaType, null, null, integratorGUID, integratorName, methodName);
        this.repositoryHandler.createRelationship(userId, "b827683c-2924-4df3-a92d-7be1888e23c0", databaseGUID, databaseSchemaGUID, null, methodName);
        return databaseSchemaGUID;
    }

    private void fillDatabaseSchemaAsset(Asset asset, String qualifiedName, String displayName, String description, String owner, OwnerType ownerType, List<String> zoneMembership, Map<String, String> origin, String latestChange, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        asset.setQualifiedName(qualifiedName);
        asset.setDisplayName(displayName);
        asset.setDescription(description);
        asset.setOwner(owner);
        asset.setOwnerType(ownerType);
        asset.setZoneMembership(zoneMembership);
        asset.setOrigin(origin);
        asset.setLatestChange(latestChange);
        asset.setAdditionalProperties(additionalProperties);
        asset.setExtendedProperties(extendedProperties);
    }

    public String createDatabaseSchemaFromTemplate(String userId, String integratorGUID, String integratorName, String templateGUID, String databaseGUID, String qualifiedName, String displayName, String description, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String parentElementGUIDParameterName = "databaseGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(integratorGUID, "integratorGUID", methodName);
        this.invalidParameterHandler.validateName(integratorName, "integratorName", methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateGUID(databaseGUID, "databaseGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        return this.assetHandler.addExternalAssetFromTemplate(userId, templateGUID, "DeployedDatabaseSchema", qualifiedName, displayName, description, integratorGUID, integratorName, methodName);
    }

    public void updateDatabaseSchema(String userId, String integratorGUID, String integratorName, String databaseSchemaGUID, String qualifiedName, String displayName, String description, String owner, OwnerType ownerType, List<String> zoneMembership, Map<String, String> origin, String latestChange, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        AssetConverter converter;
        String elementGUIDParameterName = "databaseSchemaGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(integratorGUID, "integratorGUID", methodName);
        this.invalidParameterHandler.validateName(integratorName, "integratorName", methodName);
        this.invalidParameterHandler.validateGUID(databaseSchemaGUID, "databaseSchemaGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String assetTypeName = "Database";
        if (typeName != null) {
            assetTypeName = typeName;
        }
        if ((converter = this.assetHandler.retrieveAssetConverterFromRepositoryByGUID(userId, databaseSchemaGUID, "databaseSchemaGUID", assetTypeName, methodName)) != null) {
            Asset originalAsset = converter.getAssetBean();
            this.invalidParameterHandler.validateAssetInSupportedZone(databaseSchemaGUID, "databaseSchemaGUID", originalAsset.getZoneMembership(), this.supportedZones, this.serviceName, methodName);
            Asset updatedAsset = new Asset(originalAsset);
            this.fillDatabaseSchemaAsset(updatedAsset, qualifiedName, displayName, description, owner, ownerType, zoneMembership, origin, latestChange, additionalProperties, extendedProperties);
            this.assetHandler.updateAsset(userId, originalAsset, converter.getAssetAuditHeader(), updatedAsset, null, null, null, methodName);
        }
    }

    public void publishDatabaseSchema(String userId, String integratorGUID, String integratorName, String databaseSchemaGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "databaseSchemaGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(integratorGUID, "integratorGUID", methodName);
        this.invalidParameterHandler.validateName(integratorName, "integratorName", methodName);
        this.invalidParameterHandler.validateGUID(databaseSchemaGUID, "databaseSchemaGUID", methodName);
        this.assetHandler.updateAssetZones(userId, databaseSchemaGUID, this.publishZones, methodName);
    }

    public void withdrawDatabaseSchema(String userId, String integratorGUID, String integratorName, String databaseSchemaGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "databaseSchemaGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(integratorGUID, "integratorGUID", methodName);
        this.invalidParameterHandler.validateName(integratorName, "integratorName", methodName);
        this.invalidParameterHandler.validateGUID(databaseSchemaGUID, "databaseSchemaGUID", methodName);
        this.assetHandler.updateAssetZones(userId, databaseSchemaGUID, this.publishZones, methodName);
    }

    public void removeDatabaseSchema(String userId, String integratorGUID, String integratorName, String databaseSchemaGUID, String qualifiedName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "databaseSchemaGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(integratorGUID, "integratorGUID", methodName);
        this.invalidParameterHandler.validateName(integratorName, "integratorName", methodName);
        this.invalidParameterHandler.validateGUID(databaseSchemaGUID, "databaseSchemaGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        ElementOrigin expectedElementOrigin = ElementOrigin.EXTERNAL_SOURCE;
        if (integratorGUID == null) {
            expectedElementOrigin = ElementOrigin.LOCAL_COHORT;
        }
        this.assetHandler.removeAsset(userId, databaseSchemaGUID, qualifiedName, "databaseSchemaGUID", expectedElementOrigin, integratorGUID, integratorName, methodName);
    }

    public List<Asset> findDatabaseSchemas(String userId, String searchString, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.assetHandler.findAssets(userId, "eab811ec-556a-45f1-9091-bc7ac8face0f", searchString, startFrom, pageSize, methodName);
    }

    public List<Asset> getSchemasForDatabase(String userId, String databaseGUID, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentElementGUIDParameterName = "databaseGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(databaseGUID, "databaseGUID", methodName);
        List<RelatedAsset> schemaAssets = this.assetHandler.getRelatedAssets(userId, this.supportedZones, databaseGUID, "b827683c-2924-4df3-a92d-7be1888e23c0", "DataContentForDataSet", startFrom, pageSize, this.serviceName, methodName);
        ArrayList<Asset> assets = null;
        if (schemaAssets != null) {
            assets = new ArrayList<Asset>();
            for (RelatedAsset relatedAsset : schemaAssets) {
                if (relatedAsset == null || relatedAsset.getRelatedAsset() == null) continue;
                assets.add(relatedAsset.getRelatedAsset());
            }
            if (assets.isEmpty()) {
                assets = null;
            }
        }
        return assets;
    }

    public List<Asset> getDatabaseSchemasByName(String userId, String name, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, "name", methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        AssetBuilder builder = new AssetBuilder(name, null, this.repositoryHelper, this.serviceName, this.serverName);
        List entities = this.repositoryHandler.getEntitiesByName(userId, builder.getNameInstanceProperties(methodName), "eab811ec-556a-45f1-9091-bc7ac8face0f", startFrom, validatedPageSize, methodName);
        if (entities != null) {
            ArrayList<Asset> assets = new ArrayList<Asset>();
            for (EntityDetail entity : entities) {
                if (entity == null) continue;
                AssetConverter converter = new AssetConverter(entity, null, this.repositoryHelper, this.serviceName);
                assets.add(converter.getAssetBean());
            }
            if (assets.isEmpty()) {
                assets = null;
            }
            return assets;
        }
        return null;
    }

    public Asset getDatabaseSchemaByGUID(String userId, String guid, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "guid";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(guid, "guid", methodName);
        Asset asset = this.assetHandler.getValidatedVisibleAsset(userId, this.supportedZones, guid, this.serviceName, methodName);
        this.validateAssetType(guid, methodName, asset, "DeployedDatabaseSchema");
        return asset;
    }

    public String createDatabaseTable(String userId, String integratorGUID, String integratorName, String databaseSchemaGUID, String qualifiedName, String displayName, String description, boolean isDeprecated, List<String> aliases, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String databaseSchemaTypeGUID;
        String parentElementGUIDParameterName = "databaseSchemaGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(integratorGUID, "integratorGUID", methodName);
        this.invalidParameterHandler.validateName(integratorName, "integratorName", methodName);
        this.invalidParameterHandler.validateGUID(databaseSchemaGUID, "databaseSchemaGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        Asset asset = this.assetHandler.getValidatedVisibleAsset(userId, this.supportedZones, databaseSchemaGUID, this.serviceName, methodName);
        if (asset == null) {
            this.invalidParameterHandler.throwUnknownElement(userId, databaseSchemaGUID, "DeployedDatabaseSchema", this.serviceName, this.serverName, methodName);
        }
        int tableCount = 0;
        SchemaType databaseSchemaType = this.schemaTypeHandler.getSchemaTypeForAsset(userId, databaseSchemaGUID, methodName);
        if (databaseSchemaType == null) {
            ComplexSchemaType newSchemaType = this.schemaTypeHandler.getEmptyComplexSchemaType("RelationalDBSchemaType", null, integratorGUID, integratorName, methodName);
            newSchemaType.setQualifiedName("SchemaOf:" + asset.getQualifiedName());
            newSchemaType.setAnchorGUID(databaseSchemaGUID);
            databaseSchemaTypeGUID = this.assetHandler.saveAssociatedSchemaType(userId, asset, (SchemaType)newSchemaType, null, methodName);
        } else {
            databaseSchemaTypeGUID = databaseSchemaType.getGUID();
            tableCount = this.schemaTypeHandler.countSchemaAttributes(userId, databaseSchemaTypeGUID, "databaseSchemaGUID", methodName);
        }
        String schemaAttributeTypeName = "RelationalTable";
        if (typeName != null) {
            schemaAttributeTypeName = typeName;
        }
        SchemaAttribute tableSchemaAttribute = this.schemaTypeHandler.getEmptySchemaAttribute(schemaAttributeTypeName, null, integratorGUID, integratorName, methodName);
        tableSchemaAttribute.setQualifiedName(qualifiedName);
        tableSchemaAttribute.setAttributeName(displayName);
        tableSchemaAttribute.setDescription(description);
        tableSchemaAttribute.setDeprecated(isDeprecated);
        tableSchemaAttribute.setAliases(aliases);
        tableSchemaAttribute.setAdditionalProperties(additionalProperties);
        tableSchemaAttribute.setMinCardinality(1);
        tableSchemaAttribute.setMaxCardinality(1);
        tableSchemaAttribute.setElementPosition(tableCount++);
        tableSchemaAttribute.setAnchorGUID(databaseSchemaGUID);
        ComplexSchemaType tableSchemaType = this.schemaTypeHandler.getEmptyComplexSchemaType("RelationalTableType", null, integratorGUID, integratorName, methodName);
        tableSchemaType.setQualifiedName(qualifiedName + ":tableType");
        tableSchemaAttribute.setAttributeType((SchemaType)tableSchemaType);
        String databaseTableGUID = this.schemaTypeHandler.saveSchemaAttribute(userId, databaseSchemaTypeGUID, tableSchemaAttribute, methodName);
        return databaseTableGUID;
    }

    public String createDatabaseTableFromTemplate(String userId, String integratorGUID, String integratorName, String templateGUID, String databaseSchemaGUID, String qualifiedName, String displayName, String description, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String parentElementGUIDParameterName = "databaseSchemaGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(integratorGUID, "integratorGUID", methodName);
        this.invalidParameterHandler.validateName(integratorName, "integratorName", methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateGUID(databaseSchemaGUID, "databaseSchemaGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
        return null;
    }

    public void updateDatabaseTable(String userId, String integratorGUID, String integratorName, String databaseTableGUID, String qualifiedName, String displayName, String description, boolean isDeprecated, List<String> aliases, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "databaseTableGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(integratorGUID, "integratorGUID", methodName);
        this.invalidParameterHandler.validateName(integratorName, "integratorName", methodName);
        this.invalidParameterHandler.validateGUID(databaseTableGUID, "databaseTableGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
    }

    public void removeDatabaseTable(String userId, String integratorGUID, String integratorName, String databaseTableGUID, String qualifiedName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "databaseTableGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(integratorGUID, "integratorGUID", methodName);
        this.invalidParameterHandler.validateName(integratorName, "integratorName", methodName);
        this.invalidParameterHandler.validateGUID(databaseTableGUID, "databaseTableGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
    }

    public List<SchemaAttribute> findDatabaseTables(String userId, String searchString, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
        return null;
    }

    public List<SchemaAttribute> getTablesForDatabaseSchema(String userId, String databaseSchemaGUID, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentElementGUIDParameterName = "databaseSchemaGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(databaseSchemaGUID, "databaseSchemaGUID", methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
        return null;
    }

    public List<SchemaAttribute> getDatabaseTablesByName(String userId, String name, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, "name", methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
        return null;
    }

    public SchemaAttribute getDatabaseTableByGUID(String userId, String guid, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "guid";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(guid, "guid", methodName);
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
        return null;
    }

    public String createDatabaseView(String userId, String integratorGUID, String integratorName, String databaseSchemaGUID, String qualifiedName, String displayName, String description, boolean isDeprecated, List<String> aliases, String expression, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentElementGUIDParameterName = "databaseSchemaGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(integratorGUID, "integratorGUID", methodName);
        this.invalidParameterHandler.validateName(integratorName, "integratorName", methodName);
        this.invalidParameterHandler.validateGUID(databaseSchemaGUID, "databaseSchemaGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
        return null;
    }

    public String createDatabaseViewFromTemplate(String userId, String integratorGUID, String integratorName, String templateGUID, String databaseSchemaGUID, String qualifiedName, String displayName, String description, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String parentElementGUIDParameterName = "databaseSchemaGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(integratorGUID, "integratorGUID", methodName);
        this.invalidParameterHandler.validateName(integratorName, "integratorName", methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateGUID(databaseSchemaGUID, "databaseSchemaGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
        return null;
    }

    public void updateDatabaseView(String userId, String integratorGUID, String integratorName, String databaseViewGUID, String qualifiedName, String displayName, String description, boolean isDeprecated, List<String> aliases, String expression, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "databaseViewGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(integratorGUID, "integratorGUID", methodName);
        this.invalidParameterHandler.validateName(integratorName, "integratorName", methodName);
        this.invalidParameterHandler.validateGUID(databaseViewGUID, "databaseViewGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
    }

    public void removeDatabaseView(String userId, String integratorGUID, String integratorName, String databaseViewGUID, String qualifiedName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "databaseViewGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(integratorGUID, "integratorGUID", methodName);
        this.invalidParameterHandler.validateName(integratorName, "integratorName", methodName);
        this.invalidParameterHandler.validateGUID(databaseViewGUID, "databaseViewGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
    }

    public List<SchemaAttribute> findDatabaseViews(String userId, String searchString, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
        return null;
    }

    public List<SchemaAttribute> getViewsForDatabaseSchema(String userId, String databaseSchemaGUID, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentElementGUIDParameterName = "databaseSchemaGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(databaseSchemaGUID, "databaseSchemaGUID", methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
        return null;
    }

    public List<SchemaAttribute> getDatabaseViewsByName(String userId, String name, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, "name", methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
        return null;
    }

    public SchemaAttribute getDatabaseViewByGUID(String userId, String guid, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "guid";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(guid, "guid", methodName);
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
        return null;
    }

    public String createDatabaseColumn(String userId, String integratorGUID, String integratorName, String databaseTableGUID, String qualifiedName, String displayName, String description, String dataType, String defaultValue, String formula, List<SchemaImplementationQuery> queries, boolean isDeprecated, int elementPosition, int minCardinality, int maxCardinality, boolean allowsDuplicateValues, boolean orderedValues, String defaultValueOverride, DataItemSortOrder sortOrder, int minimumLength, int length, int significantDigits, boolean isNullable, String nativeJavaClass, List<String> aliases, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentElementGUIDParameterName = "databaseTableGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(integratorGUID, "integratorGUID", methodName);
        this.invalidParameterHandler.validateName(integratorName, "integratorName", methodName);
        this.invalidParameterHandler.validateGUID(databaseTableGUID, "databaseTableGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
        return null;
    }

    public String createDatabaseColumnFromTemplate(String userId, String integratorGUID, String integratorName, String templateGUID, String databaseTableGUID, String qualifiedName, String displayName, String description, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String parentElementGUIDParameterName = "databaseTableGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(integratorGUID, "integratorGUID", methodName);
        this.invalidParameterHandler.validateName(integratorName, "integratorName", methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateGUID(databaseTableGUID, "databaseTableGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
        return null;
    }

    public void updateDatabaseColumn(String userId, String integratorGUID, String integratorName, String databaseColumnGUID, String qualifiedName, String displayName, String description, String dataType, String defaultValue, String formula, List<SchemaImplementationQuery> queries, boolean isDeprecated, int elementPosition, int minCardinality, int maxCardinality, boolean allowsDuplicateValues, boolean orderedValues, String defaultValueOverride, DataItemSortOrder sortOrder, int minimumLength, int length, int significantDigits, boolean isNullable, String nativeJavaClass, List<String> aliases, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "databaseColumnGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(integratorGUID, "integratorGUID", methodName);
        this.invalidParameterHandler.validateName(integratorName, "integratorName", methodName);
        this.invalidParameterHandler.validateGUID(databaseColumnGUID, "databaseColumnGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
    }

    public void updateDatabaseDerivedColumn(String userId, String integratorGUID, String integratorName, String databaseColumnGUID, String qualifiedName, String displayName, String description, boolean isDeprecated, int elementPosition, int minCardinality, int maxCardinality, boolean allowsDuplicateValues, boolean orderedValues, String defaultValueOverride, DataItemSortOrder sortOrder, int minimumLength, int length, int significantDigits, boolean isNullable, String nativeJavaClass, List<String> aliases, String expression, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "databaseColumnGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(integratorGUID, "integratorGUID", methodName);
        this.invalidParameterHandler.validateName(integratorName, "integratorName", methodName);
        this.invalidParameterHandler.validateGUID(databaseColumnGUID, "databaseColumnGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
    }

    public void removeDatabaseColumn(String userId, String integratorGUID, String integratorName, String databaseColumnGUID, String qualifiedName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "databaseColumnGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(integratorGUID, "integratorGUID", methodName);
        this.invalidParameterHandler.validateName(integratorName, "integratorName", methodName);
        this.invalidParameterHandler.validateGUID(databaseColumnGUID, "databaseColumnGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
    }

    public List<SchemaAttribute> findDatabaseColumns(String userId, String searchString, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
        return null;
    }

    public List<SchemaAttribute> getColumnsForDatabaseTable(String userId, String databaseTableGUID, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentElementGUIDParameterName = "databaseTableGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(databaseTableGUID, "databaseTableGUID", methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
        return null;
    }

    public List<SchemaAttribute> getDatabaseColumnsByName(String userId, String name, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, "name", methodName);
        int validatedPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
        return null;
    }

    public SchemaAttribute getDatabaseColumnByGUID(String userId, String guid, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "guid";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(guid, "guid", methodName);
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
        return null;
    }

    public void setPrimaryKeyOnColumn(String userId, String integratorGUID, String integratorName, String databaseColumnGUID, String name, KeyPattern keyPattern, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentElementGUIDParameterName = "databaseColumnGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(integratorGUID, "integratorGUID", methodName);
        this.invalidParameterHandler.validateName(integratorName, "integratorName", methodName);
        this.invalidParameterHandler.validateGUID(databaseColumnGUID, "databaseColumnGUID", methodName);
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
    }

    public void removePrimaryKeyFromColumn(String userId, String integratorGUID, String integratorName, String databaseColumnGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentElementGUIDParameterName = "databaseColumnGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(integratorGUID, "integratorGUID", methodName);
        this.invalidParameterHandler.validateName(integratorName, "integratorName", methodName);
        this.invalidParameterHandler.validateGUID(databaseColumnGUID, "databaseColumnGUID", methodName);
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
    }

    public void addForeignKeyRelationship(String userId, String integratorGUID, String integratorName, String primaryKeyColumnGUID, String foreignKeyColumnGUID, String name, String description, int confidence, String steward, String source, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String primaryElementGUIDParameterName = "primaryKeyColumnGUID";
        String foreignElementGUIDParameterName = "foreignKeyColumnGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(integratorGUID, "integratorGUID", methodName);
        this.invalidParameterHandler.validateName(integratorName, "integratorName", methodName);
        this.invalidParameterHandler.validateGUID(primaryKeyColumnGUID, "primaryKeyColumnGUID", methodName);
        this.invalidParameterHandler.validateGUID(foreignKeyColumnGUID, "foreignKeyColumnGUID", methodName);
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
    }

    public void removeForeignKeyRelationship(String userId, String integratorGUID, String integratorName, String primaryKeyColumnGUID, String foreignKeyColumnGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String primaryElementGUIDParameterName = "primaryKeyColumnGUID";
        String foreignElementGUIDParameterName = "foreignKeyColumnGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(integratorGUID, "integratorGUID", methodName);
        this.invalidParameterHandler.validateName(integratorName, "integratorName", methodName);
        this.invalidParameterHandler.validateGUID(primaryKeyColumnGUID, "primaryKeyColumnGUID", methodName);
        this.invalidParameterHandler.validateGUID(foreignKeyColumnGUID, "foreignKeyColumnGUID", methodName);
        this.invalidParameterHandler.throwMethodNotSupported(userId, this.serviceName, this.serverName, methodName);
    }

    private void validateAssetListType(String guid, String methodName, List<Asset> assets, String expectedType) throws InvalidParameterException {
        if (assets != null) {
            for (Asset asset : assets) {
                this.validateAssetType(guid, methodName, asset, expectedType);
            }
        }
    }

    private void validateAssetType(String guid, String methodName, Asset asset, String expectedType) throws InvalidParameterException {
        String actualType;
        if (asset != null && asset.getType() != null && !this.repositoryHelper.isTypeOf(this.serviceName, actualType = asset.getType().getElementTypeName(), expectedType)) {
            this.invalidParameterHandler.handleWrongTypeForGUIDException(guid, methodName, actualType, expectedType);
        }
    }

    private void validateSchemaAttributeListType(String guid, String methodName, List<SchemaAttribute> schemaAttributes, String expectedType) throws InvalidParameterException {
        if (schemaAttributes != null) {
            for (SchemaAttribute schemaAttribute : schemaAttributes) {
                this.validateSchemaAttributeType(guid, methodName, schemaAttribute, expectedType);
            }
        }
    }

    private void validateSchemaAttributeType(String guid, String methodName, SchemaAttribute schemaAttribute, String expectedType) throws InvalidParameterException {
        String actualType;
        if (schemaAttribute != null && schemaAttribute.getType() != null && !this.repositoryHelper.isTypeOf(this.serviceName, actualType = schemaAttribute.getType().getElementTypeName(), expectedType)) {
            this.invalidParameterHandler.handleWrongTypeForGUIDException(guid, methodName, actualType, expectedType);
        }
    }
}

