/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.SchemaAttributeBuilder;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.SchemaLinkBuilder;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.SchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.SchemaAttributeConverter;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.SchemaTypeConverter;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.LastAttachmentHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.BoundedSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ComplexSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.DerivedSchemaAttribute;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementOrigin;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.EnumSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.LiteralSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.MapSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.PrimitiveSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttribute;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaLink;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaTypeChoice;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SimpleSchemaType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SchemaTypeHandler {
    private String serviceName;
    private String serverName;
    private OMRSRepositoryHelper repositoryHelper;
    private RepositoryHandler repositoryHandler;
    private InvalidParameterHandler invalidParameterHandler;
    private LastAttachmentHandler lastAttachmentHandler;

    public SchemaTypeHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, LastAttachmentHandler lastAttachmentHandler) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHandler = repositoryHandler;
        this.repositoryHelper = repositoryHelper;
        this.lastAttachmentHandler = lastAttachmentHandler;
    }

    private ElementType getElementType(String requestedTypeName, String validSuperTypeName, ElementOrigin elementOrigin, String externalSourceGUID, String externalSourceName, String methodName) throws InvalidParameterException {
        ElementType elementType = new ElementType();
        ElementOrigin origin = elementOrigin;
        if (externalSourceGUID == null) {
            origin = ElementOrigin.LOCAL_COHORT;
        }
        if (origin == null) {
            origin = ElementOrigin.EXTERNAL_SOURCE;
        }
        String schemaTypeGUID = this.invalidParameterHandler.validateTypeName(requestedTypeName, validSuperTypeName, this.serviceName, methodName, this.repositoryHelper);
        elementType.setElementOrigin(origin);
        elementType.setElementTypeId(schemaTypeGUID);
        elementType.setElementTypeName(requestedTypeName);
        elementType.setElementHomeMetadataCollectionId(externalSourceGUID);
        elementType.setElementHomeMetadataCollectionName(externalSourceName);
        return elementType;
    }

    public ComplexSchemaType getEmptyComplexSchemaType(String schemaTypeGUID, String schemaTypeName) {
        ComplexSchemaType schemaType = new ComplexSchemaType();
        ElementType elementType = new ElementType();
        elementType.setElementOrigin(ElementOrigin.LOCAL_COHORT);
        elementType.setElementTypeId(schemaTypeGUID);
        elementType.setElementTypeName(schemaTypeName);
        schemaType.setType(elementType);
        return schemaType;
    }

    public ComplexSchemaType getEmptyComplexSchemaType(String schemaTypeName, ElementOrigin elementOrigin, String externalSourceGUID, String externalSourceName, String methodName) throws InvalidParameterException {
        ComplexSchemaType schemaType = new ComplexSchemaType();
        schemaType.setType(this.getElementType(schemaTypeName, "ComplexSchemaType", elementOrigin, externalSourceGUID, externalSourceName, methodName));
        return schemaType;
    }

    public PrimitiveSchemaType getEmptyPrimitiveSchemaType(String schemaTypeName, ElementOrigin elementOrigin, String externalSourceGUID, String externalSourceName, String methodName) throws InvalidParameterException {
        PrimitiveSchemaType schemaType = new PrimitiveSchemaType();
        schemaType.setType(this.getElementType(schemaTypeName, "PrimitiveSchemaType", elementOrigin, externalSourceGUID, externalSourceName, methodName));
        return schemaType;
    }

    public SchemaAttribute getEmptySchemaAttribute(String schemaTypeName, ElementOrigin elementOrigin, String externalSourceGUID, String externalSourceName, String methodName) throws InvalidParameterException {
        SchemaAttribute schemaAttribute = new SchemaAttribute();
        schemaAttribute.setType(this.getElementType(schemaTypeName, "SchemaAttribute", elementOrigin, externalSourceGUID, externalSourceName, methodName));
        return schemaAttribute;
    }

    public SchemaAttribute getEmptyTabularColumn() {
        SchemaAttribute schemaAttribute = new SchemaAttribute();
        ElementType elementType = new ElementType();
        elementType.setElementOrigin(ElementOrigin.LOCAL_COHORT);
        elementType.setElementTypeId("d81a0425-4e9b-4f31-bc1c-e18c3566da10");
        elementType.setElementTypeName("TabularColumn");
        schemaAttribute.setType(elementType);
        return schemaAttribute;
    }

    SchemaType getSchemaTypeForAsset(String userId, String anchorGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getSchemaTypeForAnchor(userId, anchorGUID, "Asset", "815b004d-73c6-4728-9dd9-536f4fe803cd", "AssetSchemaType", methodName);
    }

    private SchemaType getSchemaTypeForAttribute(String userId, EntityDetail schemaAttributeEntity, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (schemaAttributeEntity != null) {
            List classifications = schemaAttributeEntity.getClassifications();
            if (classifications != null) {
                for (Classification classification : classifications) {
                    if (classification == null || !"TypeEmbeddedAttribute".equals(classification.getName())) continue;
                    return this.getSchemaTypeFromClassification(userId, schemaAttributeEntity.getGUID(), classification, methodName);
                }
            }
            return this.getSchemaTypeForAnchor(userId, schemaAttributeEntity.getGUID(), "SchemaAttribute", "2d955049-e59b-45dd-8e62-cde1add59f9e", "SchemaAttributeType", methodName);
        }
        return null;
    }

    private SchemaType getSchemaTypeForAnchor(String userId, String anchorGUID, String anchorTypeName, String relationshipTypeGUID, String relationshipTypeName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail schemaTypeEntity = this.repositoryHandler.getEntityForRelationshipType(userId, anchorGUID, anchorTypeName, relationshipTypeGUID, relationshipTypeName, methodName);
        return this.getSchemaTypeFromEntity(userId, schemaTypeEntity, methodName);
    }

    private SchemaType getSchemaType(String userId, String schemaTypeGUID, String guidParameterName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail schemaTypeEntity = this.repositoryHandler.getEntityByGUID(userId, schemaTypeGUID, guidParameterName, "SchemaType", methodName);
        return this.getSchemaTypeFromEntity(userId, schemaTypeEntity, methodName);
    }

    private SchemaType getSchemaTypeFromEntity(String userId, EntityDetail schemaTypeEntity, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "schemaTypeEntity.getGUID()";
        if (schemaTypeEntity != null && schemaTypeEntity.getType() != null) {
            InstanceProperties properties = schemaTypeEntity.getProperties();
            String typeName = this.repositoryHelper.removeStringProperty(this.serviceName, "typeName", properties, methodName);
            if (properties != null) {
                int attributeCount = 0;
                if (typeName != null && this.repositoryHelper.isTypeOf(this.serviceName, typeName, "ComplexSchemaType")) {
                    attributeCount = this.countSchemaAttributes(userId, schemaTypeEntity.getGUID(), "schemaTypeEntity.getGUID()", methodName);
                }
                SchemaTypeConverter converter = new SchemaTypeConverter(schemaTypeEntity, attributeCount, this.repositoryHelper, this.serviceName);
                return this.getEmbeddedTypes(userId, schemaTypeEntity.getGUID(), converter.getBean(), methodName);
            }
        }
        return null;
    }

    private SchemaType getSchemaTypeFromClassification(String userId, String schemaAttributeGUID, Classification embeddedSchemaType, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "schemaAttributeGUID";
        if (embeddedSchemaType != null && embeddedSchemaType.getProperties() != null) {
            InstanceProperties properties = embeddedSchemaType.getProperties();
            String typeName = this.repositoryHelper.removeStringProperty(this.serviceName, "typeName", properties, methodName);
            if (properties != null) {
                int attributeCount = 0;
                if (typeName != null && this.repositoryHelper.isTypeOf(this.serviceName, typeName, "ComplexSchemaType")) {
                    attributeCount = this.countSchemaAttributes(userId, schemaAttributeGUID, "schemaAttributeGUID", methodName);
                }
                SchemaTypeConverter converter = new SchemaTypeConverter(typeName, properties, attributeCount, this.repositoryHelper, this.serviceName);
                return this.getEmbeddedTypes(userId, schemaAttributeGUID, converter.getBean(), methodName);
            }
        }
        return null;
    }

    private SchemaType getEmbeddedTypes(String userId, String schemaElementGUID, SchemaType parentSchemaType, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail entity;
        if (parentSchemaType instanceof MapSchemaType) {
            EntityDetail entity2 = this.repositoryHandler.getEntityForRelationshipType(userId, schemaElementGUID, "MapSchemaType", "6189d444-2da4-4cd7-9332-e48a1c340b44", "MapFromElementType", methodName);
            if (entity2 != null) {
                ((MapSchemaType)parentSchemaType).setMapFromElement(this.getSchemaTypeFromEntity(userId, entity2, methodName));
            }
            if ((entity2 = this.repositoryHandler.getEntityForRelationshipType(userId, schemaElementGUID, "MapSchemaType", "8b9856b3-451e-45fc-afc7-fddefd81a73a", "MapToElementType", methodName)) != null) {
                ((MapSchemaType)parentSchemaType).setMapToElement(this.getSchemaTypeFromEntity(userId, entity2, methodName));
            }
        } else if (parentSchemaType instanceof SchemaTypeChoice) {
            List entities = this.repositoryHandler.getEntitiesForRelationshipType(userId, schemaElementGUID, "SchemaTypeChoice", "eb4f1f98-c649-4560-8a46-da17c02764a9", "SchemaTypeOption", 0, this.invalidParameterHandler.getMaxPagingSize(), methodName);
            if (entities != null) {
                ArrayList<SchemaType> schemaTypes = new ArrayList<SchemaType>();
                for (EntityDetail entity3 : entities) {
                    if (entity3 == null) continue;
                    schemaTypes.add(this.getSchemaTypeFromEntity(userId, entity3, methodName));
                }
                if (!schemaTypes.isEmpty()) {
                    ((SchemaTypeChoice)parentSchemaType).setSchemaOptions(schemaTypes);
                }
            }
        } else if (parentSchemaType instanceof BoundedSchemaType && (entity = this.repositoryHandler.getEntityForRelationshipType(userId, schemaElementGUID, "BoundedSchemaType", "3e844049-e59b-45dd-8e62-cde1add59f9e", "BoundedSchemaElementType", methodName)) != null) {
            ((BoundedSchemaType)parentSchemaType).setElementType(this.getSchemaTypeFromEntity(userId, entity, methodName));
        }
        return parentSchemaType;
    }

    int countSchemaAttributes(String userId, String schemaElementGUID, String guidParameterName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(schemaElementGUID, guidParameterName, methodName);
        int count = this.repositoryHandler.countAttachedRelationshipsByType(userId, schemaElementGUID, "SchemaElement", "0ffb9d87-7074-45da-a9b0-ae0859611133", "NestedSchemaAttribute", methodName);
        if (count == 0) {
            count = this.repositoryHandler.countAttachedRelationshipsByType(userId, schemaElementGUID, "ComplexSchemaType", "86b176a2-015c-44a6-8106-54d5d69ba661", "AttributeForSchema", methodName);
        }
        return count;
    }

    public List<SchemaAttribute> getSchemaAttributes(String userId, String schemaTypeGUID, int elementStart, int maxElements, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "schemaTypeGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(schemaTypeGUID, "schemaTypeGUID", methodName);
        List entities = this.repositoryHandler.getEntitiesForRelationshipType(userId, schemaTypeGUID, "SchemaType", "86b176a2-015c-44a6-8106-54d5d69ba661", "AttributeForSchema", elementStart, maxElements, methodName);
        ArrayList<SchemaAttribute> results = new ArrayList<SchemaAttribute>();
        if (entities != null) {
            for (EntityDetail schemaAttributeEntity : entities) {
                if (schemaAttributeEntity == null) continue;
                EntityDetail attributeTypeEntity = this.repositoryHandler.getEntityForRelationshipType(userId, schemaAttributeEntity.getGUID(), "SchemaAttribute", "2d955049-e59b-45dd-8e62-cde1add59f9e", "SchemaAttributeType", methodName);
                SchemaType attributeType = null;
                if (attributeTypeEntity != null) {
                    attributeType = this.getSchemaTypeForAttribute(userId, attributeTypeEntity, methodName);
                }
                SchemaAttributeConverter converter = new SchemaAttributeConverter(schemaAttributeEntity, attributeType, null, null, this.repositoryHelper, this.serviceName);
                results.add(converter.getBean());
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public void saveSchemaAttributes(String userId, String schemaTypeGUID, List<SchemaAttribute> schemaAttributes, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (schemaAttributes != null) {
            for (SchemaAttribute schemaAttribute : schemaAttributes) {
                if (schemaAttribute == null) continue;
                this.saveSchemaTypeAttribute(userId, schemaTypeGUID, schemaAttribute, methodName);
            }
        }
    }

    public String saveSchemaAttribute(String userId, String parentGUID, SchemaAttribute schemaAttribute, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "parentGUID";
        this.invalidParameterHandler.validateGUID(parentGUID, "parentGUID", methodName);
        EntityDetail parentEntity = this.repositoryHandler.getEntityByGUID(userId, parentGUID, "parentGUID", "SchemaElement", methodName);
        if (parentEntity != null) {
            String typeName = null;
            InstanceType type = parentEntity.getType();
            if (type != null) {
                typeName = type.getTypeDefName();
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, typeName, "SchemaType")) {
                return this.saveSchemaTypeAttribute(userId, parentGUID, schemaAttribute, methodName);
            }
            return this.saveNestedSchemaAttribute(userId, parentGUID, schemaAttribute, methodName);
        }
        this.invalidParameterHandler.throwUnknownElement(userId, parentGUID, "SchemaElement", this.serviceName, this.serverName, methodName);
        return null;
    }

    private String saveSchemaTypeAttribute(String userId, String schemaTypeGUID, SchemaAttribute schemaAttribute, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String schemaAttributeGUID = this.findSchemaAttribute(userId, schemaAttribute, methodName);
        if (schemaAttributeGUID == null) {
            schemaAttributeGUID = this.addSchemaAttribute(userId, schemaAttribute);
            if (this.isLocalCohortInstance(schemaAttribute.getType())) {
                this.repositoryHandler.createRelationship(userId, "86b176a2-015c-44a6-8106-54d5d69ba661", schemaTypeGUID, schemaAttributeGUID, null, methodName);
            } else {
                this.repositoryHandler.createExternalRelationship(userId, "86b176a2-015c-44a6-8106-54d5d69ba661", schemaAttribute.getType().getElementHomeMetadataCollectionId(), schemaAttribute.getType().getElementHomeMetadataCollectionName(), schemaTypeGUID, schemaAttributeGUID, null, methodName);
            }
        } else {
            this.updateSchemaAttribute(userId, schemaAttributeGUID, schemaAttribute);
        }
        return schemaAttributeGUID;
    }

    private String saveNestedSchemaAttribute(String userId, String parentSchemaAttributeGUID, SchemaAttribute nestedSchemaAttribute, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String schemaAttributeGUID = this.findSchemaAttribute(userId, nestedSchemaAttribute, methodName);
        if (schemaAttributeGUID == null) {
            schemaAttributeGUID = this.addSchemaAttribute(userId, nestedSchemaAttribute);
            this.repositoryHandler.createRelationship(userId, "0ffb9d87-7074-45da-a9b0-ae0859611133", parentSchemaAttributeGUID, schemaAttributeGUID, null, methodName);
        } else {
            this.updateSchemaAttribute(userId, schemaAttributeGUID, nestedSchemaAttribute);
        }
        return schemaAttributeGUID;
    }

    private String findSchemaAttribute(String userId, String schemaAttributeGUID, String qualifiedName, String attributeName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "schemaAttributeGUID";
        String qualifiedNameParameter = "qualifiedName";
        if (schemaAttributeGUID != null && this.repositoryHandler.isEntityKnown(userId, schemaAttributeGUID, "SchemaAttribute", methodName, "schemaAttributeGUID") != null) {
            return schemaAttributeGUID;
        }
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        SchemaAttributeBuilder builder = new SchemaAttributeBuilder(qualifiedName, attributeName, this.repositoryHelper, this.serviceName, this.serverName);
        EntityDetail existingSchemaType = this.repositoryHandler.getUniqueEntityByName(userId, qualifiedName, "qualifiedName", builder.getQualifiedNameInstanceProperties(methodName), "1a5e159b-913a-43b1-95fe-04433b25fca9", "SchemaAttribute", methodName);
        if (existingSchemaType != null) {
            return existingSchemaType.getGUID();
        }
        return null;
    }

    private String findSchemaAttribute(String userId, SchemaAttribute schemaAttribute, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (schemaAttribute != null) {
            return this.findSchemaAttribute(userId, schemaAttribute.getGUID(), schemaAttribute.getQualifiedName(), schemaAttribute.getAttributeName(), methodName);
        }
        return null;
    }

    private boolean isLocalCohortInstance(ElementType instanceElementType) {
        if (instanceElementType == null) {
            return true;
        }
        return instanceElementType.getElementOrigin() == ElementOrigin.LOCAL_COHORT;
    }

    private String addSchemaAttribute(String userId, SchemaAttribute schemaAttribute) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addSchemaAttribute";
        SchemaAttributeBuilder schemaAttributeBuilder = this.getSchemaAttributeBuilder(schemaAttribute);
        ElementType type = schemaAttribute.getType();
        String schemaAttributeGUID = this.isLocalCohortInstance(type) ? this.repositoryHandler.createEntity(userId, this.getSchemaAttributeTypeGUID(schemaAttribute), this.getSchemaAttributeTypeName(schemaAttribute), schemaAttributeBuilder.getInstanceProperties("addSchemaAttribute"), "addSchemaAttribute") : this.repositoryHandler.createExternalEntity(userId, this.getSchemaAttributeTypeGUID(schemaAttribute), this.getSchemaAttributeTypeName(schemaAttribute), type.getElementHomeMetadataCollectionId(), type.getElementHomeMetadataCollectionName(), schemaAttributeBuilder.getInstanceProperties("addSchemaAttribute"), "addSchemaAttribute");
        SchemaType schemaType = schemaAttribute.getAttributeType();
        if (schemaType != null) {
            if (schemaType.getExtendedProperties() == null && (schemaType instanceof ComplexSchemaType || schemaType instanceof LiteralSchemaType || schemaType instanceof SimpleSchemaType)) {
                SchemaTypeBuilder schemaTypeBuilder = this.getSchemaTypeBuilder(schemaType);
                this.repositoryHandler.classifyEntity(userId, schemaAttributeGUID, "e2bb76bb-774a-43ff-9045-3a05f663d5d9", "TypeEmbeddedAttribute", schemaTypeBuilder.getInstanceProperties("addSchemaAttribute"), "addSchemaAttribute");
            } else {
                String schemaTypeGUID = this.addSchemaType(userId, schemaType);
                if (schemaTypeGUID != null) {
                    if (this.isLocalCohortInstance(type)) {
                        this.repositoryHandler.createRelationship(userId, "2d955049-e59b-45dd-8e62-cde1add59f9e", schemaAttributeGUID, schemaTypeGUID, null, "addSchemaAttribute");
                    } else {
                        this.repositoryHandler.createExternalRelationship(userId, "2d955049-e59b-45dd-8e62-cde1add59f9e", type.getElementHomeMetadataCollectionId(), type.getElementHomeMetadataCollectionName(), schemaAttributeGUID, schemaTypeGUID, null, "addSchemaAttribute");
                    }
                }
            }
        } else if (schemaAttribute.getExternalAttributeType() != null) {
            SchemaLinkBuilder builder;
            String schemaLinkGUID;
            String guidParameterName = "schemaAttribute.getExternalAttributeType().getLinkedSchemaTypeGUID()";
            SchemaLink schemaLink = schemaAttribute.getExternalAttributeType();
            SchemaType linkedType = this.getSchemaType(userId, schemaLink.getLinkedSchemaTypeGUID(), "schemaAttribute.getExternalAttributeType().getLinkedSchemaTypeGUID()", "addSchemaAttribute");
            if (linkedType != null && (schemaLinkGUID = this.repositoryHandler.createEntity(userId, "67e08705-2d2a-4df6-9239-1818161a41e0", "SchemaLinkElement", (builder = new SchemaLinkBuilder(schemaLink.getQualifiedName(), schemaLink.getDisplayName(), this.repositoryHelper, this.serviceName, this.serverName)).getInstanceProperties("addSchemaAttribute"), "addSchemaAttribute")) != null) {
                this.repositoryHandler.createRelationship(userId, "2d955049-e59b-45dd-8e62-cde1add59f9e", schemaLinkGUID, schemaType.getGUID(), null, "addSchemaAttribute");
            }
        }
        return schemaAttributeGUID;
    }

    public String addExternalSchemaAttribute(String userId, SchemaAttribute schemaAttribute, String externalSourceGUID, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addExternalSchemaAttribute";
        SchemaAttributeBuilder schemaAttributeBuilder = this.getSchemaAttributeBuilder(schemaAttribute);
        String schemaAttributeGUID = this.repositoryHandler.createExternalEntity(userId, this.getSchemaAttributeTypeGUID(schemaAttribute), this.getSchemaAttributeTypeName(schemaAttribute), externalSourceGUID, externalSourceName, schemaAttributeBuilder.getInstanceProperties("addExternalSchemaAttribute"), "addExternalSchemaAttribute");
        SchemaType schemaType = schemaAttribute.getAttributeType();
        if (schemaType != null) {
            if (schemaType.getExtendedProperties() == null && (schemaType instanceof ComplexSchemaType || schemaType instanceof LiteralSchemaType || schemaType instanceof SimpleSchemaType)) {
                SchemaTypeBuilder schemaTypeBuilder = this.getSchemaTypeBuilder(schemaType);
                this.repositoryHandler.classifyEntity(userId, schemaAttributeGUID, "e2bb76bb-774a-43ff-9045-3a05f663d5d9", "TypeEmbeddedAttribute", schemaTypeBuilder.getInstanceProperties("addExternalSchemaAttribute"), "addExternalSchemaAttribute");
            } else {
                String schemaTypeGUID = this.addSchemaType(userId, schemaType);
                if (schemaTypeGUID != null) {
                    this.repositoryHandler.createExternalRelationship(userId, "2d955049-e59b-45dd-8e62-cde1add59f9e", externalSourceGUID, externalSourceName, schemaAttributeGUID, schemaTypeGUID, null, "addExternalSchemaAttribute");
                }
            }
        } else if (schemaAttribute.getExternalAttributeType() != null) {
            SchemaLinkBuilder builder;
            String schemaLinkGUID;
            String guidParameterName = "schemaAttribute.getExternalAttributeType().getLinkedSchemaTypeGUID()";
            SchemaLink schemaLink = schemaAttribute.getExternalAttributeType();
            SchemaType linkedType = this.getSchemaType(userId, schemaLink.getLinkedSchemaTypeGUID(), "schemaAttribute.getExternalAttributeType().getLinkedSchemaTypeGUID()", "addExternalSchemaAttribute");
            if (linkedType != null && (schemaLinkGUID = this.repositoryHandler.createExternalEntity(userId, "67e08705-2d2a-4df6-9239-1818161a41e0", "SchemaLinkElement", externalSourceGUID, externalSourceName, (builder = new SchemaLinkBuilder(schemaLink.getQualifiedName(), schemaLink.getDisplayName(), this.repositoryHelper, this.serviceName, this.serverName)).getInstanceProperties("addExternalSchemaAttribute"), "addExternalSchemaAttribute")) != null) {
                this.repositoryHandler.createExternalRelationship(userId, "2d955049-e59b-45dd-8e62-cde1add59f9e", externalSourceGUID, externalSourceName, schemaLinkGUID, schemaType.getGUID(), null, "addExternalSchemaAttribute");
            }
        }
        return schemaAttributeGUID;
    }

    public String updateSchemaAttribute(String userId, String existingSchemaAttributeGUID, SchemaAttribute schemaAttribute) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateSchemaAttribute";
        SchemaAttributeBuilder builder = this.getSchemaAttributeBuilder(schemaAttribute);
        this.repositoryHandler.updateEntity(userId, existingSchemaAttributeGUID, this.getSchemaAttributeTypeGUID(schemaAttribute), this.getSchemaAttributeTypeName(schemaAttribute), builder.getInstanceProperties("updateSchemaAttribute"), "updateSchemaAttribute");
        return existingSchemaAttributeGUID;
    }

    public SchemaAttributeBuilder getSchemaAttributeBuilder(SchemaAttribute schemaAttribute) {
        SchemaAttributeBuilder builder = null;
        if (schemaAttribute != null) {
            builder = new SchemaAttributeBuilder(schemaAttribute.getQualifiedName(), schemaAttribute.getAttributeName(), schemaAttribute.getDescription(), schemaAttribute.getElementPosition(), schemaAttribute.getMinCardinality(), schemaAttribute.getMaxCardinality(), schemaAttribute.isDeprecated(), schemaAttribute.getDefaultValueOverride(), schemaAttribute.isAllowsDuplicateValues(), schemaAttribute.isOrderedValues(), schemaAttribute.getSortOrder(), schemaAttribute.getAnchorGUID(), schemaAttribute.getMinimumLength(), schemaAttribute.getLength(), schemaAttribute.getSignificantDigits(), schemaAttribute.isNullable(), schemaAttribute.getNativeJavaClass(), schemaAttribute.getAliases(), schemaAttribute.getAdditionalProperties(), schemaAttribute.getExtendedProperties(), this.repositoryHelper, this.serviceName, this.serverName);
            if (schemaAttribute instanceof DerivedSchemaAttribute) {
                DerivedSchemaAttribute derivedSchemaAttribute = (DerivedSchemaAttribute)schemaAttribute;
                builder.setFormula(derivedSchemaAttribute.getFormula());
            }
        }
        return builder;
    }

    private String getSchemaAttributeTypeGUID(SchemaAttribute schemaAttribute) {
        ElementType type = schemaAttribute.getType();
        if (type != null) {
            return type.getElementTypeId();
        }
        return "1a5e159b-913a-43b1-95fe-04433b25fca9";
    }

    private String getSchemaAttributeTypeName(SchemaAttribute schemaAttribute) {
        ElementType type = schemaAttribute.getType();
        if (type != null) {
            return type.getElementTypeName();
        }
        return "SchemaAttribute";
    }

    private String findSchemaType(String userId, String schemaTypeGUID, String qualifiedName, String displayName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "schemaTypeGUID";
        String qualifiedNameParameter = "qualifiedName";
        if (schemaTypeGUID != null && this.repositoryHandler.isEntityKnown(userId, schemaTypeGUID, "SchemaType", methodName, "schemaTypeGUID") != null) {
            return schemaTypeGUID;
        }
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, this.repositoryHelper, this.serviceName, this.serverName);
        EntityDetail existingSchemaType = this.repositoryHandler.getUniqueEntityByName(userId, qualifiedName, "qualifiedName", builder.getQualifiedNameInstanceProperties(methodName), "5bd4a3e7-d22d-4a3d-a115-066ee8e0754f", "SchemaType", methodName);
        if (existingSchemaType != null) {
            return existingSchemaType.getGUID();
        }
        return null;
    }

    private String findSchemaType(String userId, SchemaType schemaType, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (schemaType != null) {
            return this.findSchemaType(userId, schemaType.getGUID(), schemaType.getQualifiedName(), schemaType.getDisplayName(), methodName);
        }
        return null;
    }

    public String saveSchemaType(String userId, SchemaType schemaType, List<SchemaAttribute> schemaAttributes, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String schemaTypeGUID = this.saveSchemaType(userId, schemaType, methodName);
        if (schemaAttributes != null) {
            this.saveSchemaAttributes(userId, schemaTypeGUID, schemaAttributes, methodName);
        }
        return schemaTypeGUID;
    }

    public String saveSchemaType(String userId, SchemaType schemaType, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String schemaTypeGUID = this.findSchemaType(userId, schemaType, methodName);
        if (schemaTypeGUID == null) {
            schemaTypeGUID = this.addSchemaType(userId, schemaType);
        } else {
            this.updateSchemaType(userId, schemaTypeGUID, schemaType);
        }
        return schemaTypeGUID;
    }

    public String saveExternalSchemaType(String userId, SchemaType schemaType, String externalSourceGUID, String externalSourceName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String schemaTypeGUID = this.findSchemaType(userId, schemaType, methodName);
        if (schemaTypeGUID == null) {
            schemaTypeGUID = this.addExternalSchemaType(userId, schemaType, externalSourceGUID, externalSourceName);
        } else {
            this.updateSchemaType(userId, schemaTypeGUID, schemaType);
        }
        return schemaTypeGUID;
    }

    private String addSchemaType(String userId, SchemaType schemaType) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addSchemaType";
        SchemaTypeBuilder schemaTypeBuilder = this.getSchemaTypeBuilder(schemaType);
        String schemaTypeGUID = this.repositoryHandler.createEntity(userId, this.getSchemaTypeTypeGUID(schemaType), this.getSchemaTypeTypeName(schemaType), schemaTypeBuilder.getInstanceProperties("addSchemaType"), "addSchemaType");
        return this.addEmbeddedTypes(userId, schemaTypeGUID, schemaType);
    }

    private String addEmbeddedTypes(String userId, String schemaTypeGUID, SchemaType schemaType) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String elementTypeGUID;
        SchemaType elementType;
        String methodName = "addEmbeddedTypes";
        if (schemaType instanceof MapSchemaType) {
            String mapToGUID;
            String mapFromGUID;
            SchemaType mapFrom = ((MapSchemaType)schemaType).getMapFromElement();
            SchemaType mapTo = ((MapSchemaType)schemaType).getMapToElement();
            if (mapFrom != null && (mapFromGUID = this.addSchemaType(userId, mapFrom)) != null) {
                this.repositoryHandler.createRelationship(userId, "MapFromElementType", schemaTypeGUID, mapFromGUID, null, "addEmbeddedTypes");
            }
            if (mapTo != null && (mapToGUID = this.addSchemaType(userId, mapTo)) != null) {
                this.repositoryHandler.createRelationship(userId, "MapToElementType", schemaTypeGUID, mapToGUID, null, "addEmbeddedTypes");
            }
        } else if (schemaType instanceof SchemaTypeChoice) {
            List schemaOptions = ((SchemaTypeChoice)schemaType).getSchemaOptions();
            if (schemaOptions != null) {
                for (SchemaType option : schemaOptions) {
                    String optionGUID;
                    if (option == null || (optionGUID = this.addSchemaType(userId, option)) == null) continue;
                    this.repositoryHandler.createRelationship(userId, "eb4f1f98-c649-4560-8a46-da17c02764a9", schemaTypeGUID, optionGUID, null, "addEmbeddedTypes");
                }
            }
        } else if (schemaType instanceof BoundedSchemaType && (elementType = ((BoundedSchemaType)schemaType).getElementType()) != null && (elementTypeGUID = this.addSchemaType(userId, elementType)) != null) {
            this.repositoryHandler.createRelationship(userId, "3e844049-e59b-45dd-8e62-cde1add59f9e", schemaTypeGUID, elementTypeGUID, null, "addEmbeddedTypes");
        }
        return schemaTypeGUID;
    }

    public String addExternalSchemaType(String userId, SchemaType schemaType, String externalSourceGUID, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addExternalSchemaType";
        SchemaTypeBuilder schemaTypeBuilder = this.getSchemaTypeBuilder(schemaType);
        String schemaTypeGUID = this.repositoryHandler.createExternalEntity(userId, this.getSchemaTypeTypeGUID(schemaType), this.getSchemaTypeTypeName(schemaType), externalSourceGUID, externalSourceName, schemaTypeBuilder.getInstanceProperties("addExternalSchemaType"), "addExternalSchemaType");
        return this.addExternalEmbeddedTypes(userId, schemaTypeGUID, schemaType, externalSourceGUID, externalSourceName);
    }

    private String addExternalEmbeddedTypes(String userId, String schemaTypeGUID, SchemaType schemaType, String externalSourceGUID, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String elementTypeGUID;
        SchemaType elementType;
        String methodName = "addExternalEmbeddedTypes";
        if (schemaType instanceof MapSchemaType) {
            String mapToGUID;
            String mapFromGUID;
            SchemaType mapFrom = ((MapSchemaType)schemaType).getMapFromElement();
            SchemaType mapTo = ((MapSchemaType)schemaType).getMapToElement();
            if (mapFrom != null && (mapFromGUID = this.addExternalSchemaType(userId, mapFrom, externalSourceGUID, externalSourceName)) != null) {
                this.repositoryHandler.createExternalRelationship(userId, "MapFromElementType", externalSourceGUID, externalSourceName, schemaTypeGUID, mapFromGUID, null, "addExternalEmbeddedTypes");
            }
            if (mapTo != null && (mapToGUID = this.addExternalSchemaType(userId, mapTo, externalSourceGUID, externalSourceName)) != null) {
                this.repositoryHandler.createExternalRelationship(userId, "MapToElementType", externalSourceGUID, externalSourceName, schemaTypeGUID, mapToGUID, null, "addExternalEmbeddedTypes");
            }
        } else if (schemaType instanceof SchemaTypeChoice) {
            List schemaOptions = ((SchemaTypeChoice)schemaType).getSchemaOptions();
            if (schemaOptions != null) {
                for (SchemaType option : schemaOptions) {
                    String optionGUID;
                    if (option == null || (optionGUID = this.addExternalSchemaType(userId, option, externalSourceGUID, externalSourceName)) == null) continue;
                    this.repositoryHandler.createExternalRelationship(userId, "eb4f1f98-c649-4560-8a46-da17c02764a9", externalSourceGUID, externalSourceName, schemaTypeGUID, optionGUID, null, "addExternalEmbeddedTypes");
                }
            }
        } else if (schemaType instanceof BoundedSchemaType && (elementType = ((BoundedSchemaType)schemaType).getElementType()) != null && (elementTypeGUID = this.addExternalSchemaType(userId, elementType, externalSourceGUID, externalSourceName)) != null) {
            this.repositoryHandler.createExternalRelationship(userId, "3e844049-e59b-45dd-8e62-cde1add59f9e", externalSourceGUID, externalSourceName, schemaTypeGUID, elementTypeGUID, null, "addExternalEmbeddedTypes");
        }
        return schemaTypeGUID;
    }

    public String updateSchemaType(String userId, String existingSchemaTypeGUID, SchemaType schemaType) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateSchemaType";
        SchemaTypeBuilder schemaTypeBuilder = this.getSchemaTypeBuilder(schemaType);
        this.repositoryHandler.updateEntity(userId, existingSchemaTypeGUID, this.getSchemaTypeTypeGUID(schemaType), this.getSchemaTypeTypeName(schemaType), schemaTypeBuilder.getInstanceProperties("updateSchemaType"), "updateSchemaType");
        return existingSchemaTypeGUID;
    }

    private String getSchemaTypeTypeGUID(SchemaType schemaType) {
        ElementType type = schemaType.getType();
        if (type != null) {
            return type.getElementTypeId();
        }
        return "5bd4a3e7-d22d-4a3d-a115-066ee8e0754f";
    }

    private String getSchemaTypeTypeName(SchemaType schemaType) {
        ElementType type = schemaType.getType();
        if (type != null) {
            return type.getElementTypeName();
        }
        return "SchemaType";
    }

    private SchemaTypeBuilder getSchemaTypeBuilder(SchemaType schemaType) {
        SchemaTypeBuilder builder = null;
        if (schemaType != null) {
            builder = new SchemaTypeBuilder("SchemaType", schemaType.getQualifiedName(), schemaType.getDisplayName(), schemaType.getDescription(), schemaType.getVersionNumber(), schemaType.isDeprecated(), schemaType.getAuthor(), schemaType.getUsage(), schemaType.getEncodingStandard(), schemaType.getNamespace(), schemaType.getAdditionalProperties(), schemaType.getExtendedProperties(), this.repositoryHelper, this.serviceName, this.serverName);
            if (schemaType instanceof SimpleSchemaType) {
                builder.setDataType(((SimpleSchemaType)schemaType).getDataType());
                builder.setDefaultValue(((SimpleSchemaType)schemaType).getDefaultValue());
            } else if (schemaType instanceof LiteralSchemaType) {
                builder.setDataType(((LiteralSchemaType)schemaType).getDataType());
                builder.setFixedValue(((LiteralSchemaType)schemaType).getFixedValue());
            } else if (schemaType instanceof BoundedSchemaType) {
                builder.setMaximumElements(((BoundedSchemaType)schemaType).getMaximumElements());
            }
            String typeName = null;
            if (schemaType.getType() != null) {
                typeName = schemaType.getType().getElementTypeName();
            }
            if (typeName == null) {
                typeName = schemaType instanceof PrimitiveSchemaType ? "PrimitiveSchemaType" : (schemaType instanceof EnumSchemaType ? "EnumSchemaType" : (schemaType instanceof SimpleSchemaType ? "SimpleSchemaType" : (schemaType instanceof LiteralSchemaType ? "LiteralSchemaType" : (schemaType instanceof ComplexSchemaType ? "ComplexSchemaType" : (schemaType instanceof MapSchemaType ? "MapSchemaType" : (schemaType instanceof BoundedSchemaType ? "BoundedSchemaType" : "SchemaType"))))));
            }
            builder.setTypeName(typeName);
        }
        return builder;
    }

    public void removeSchemaType(String userId, String schemaTypeGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeSchemaType";
        String guidParameterName = "schemaTypeGUID";
        this.repositoryHandler.removeEntityOnLastUse(userId, schemaTypeGUID, "schemaTypeGUID", "5bd4a3e7-d22d-4a3d-a115-066ee8e0754f", "SchemaType", "removeSchemaType");
    }

    public void removeSchemaAttribute(String userId, String schemaAttributeGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeSchemaAttribute";
        String guidParameterName = "schemaAttributeGUID";
        this.repositoryHandler.removeEntityOnLastUse(userId, schemaAttributeGUID, "schemaAttributeGUID", "1a5e159b-913a-43b1-95fe-04433b25fca9", "SchemaAttribute", "removeSchemaAttribute");
    }
}

