/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers;

import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.ConnectorTypeBuilder;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.ConnectorTypeConverter;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.RootHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ConnectorTypeHandler
extends RootHandler {
    public ConnectorTypeHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper) {
        super(serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper);
    }

    String findConnectorType(String userId, ConnectorType connectorType, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "connectorType.getGUID";
        String qualifiedNameParameter = "connectorType.getQualifiedName";
        if (connectorType != null) {
            this.invalidParameterHandler.validateName(connectorType.getQualifiedName(), "connectorType.getQualifiedName", methodName);
            if (connectorType.getGUID() != null && this.repositoryHandler.isEntityKnown(userId, connectorType.getGUID(), "ConnectorType", methodName, "connectorType.getGUID") != null) {
                return connectorType.getGUID();
            }
            ConnectorTypeBuilder connectorTypeBuilder = new ConnectorTypeBuilder(connectorType.getQualifiedName(), connectorType.getDisplayName(), connectorType.getDescription(), this.repositoryHelper, this.serviceName, this.serverName);
            EntityDetail existingConnectorType = this.repositoryHandler.getUniqueEntityByName(userId, connectorType.getQualifiedName(), "connectorType.getQualifiedName", connectorTypeBuilder.getQualifiedNameInstanceProperties(methodName), "954421eb-33a6-462d-a8ca-b5709a1bd0d4", "ConnectorType", methodName);
            if (existingConnectorType != null) {
                return existingConnectorType.getGUID();
            }
        }
        return null;
    }

    public String saveConnectorType(String userId, String externalSourceGUID, String externalSourceName, ConnectorType connectorType) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "saveConnectorType";
        String existingConnectorType = this.findConnectorType(userId, connectorType, "saveConnectorType");
        if (existingConnectorType == null) {
            return this.addConnectorType(userId, externalSourceGUID, externalSourceName, connectorType);
        }
        return this.updateConnectorType(userId, externalSourceGUID, externalSourceName, existingConnectorType, connectorType);
    }

    String addConnectorType(String userId, String externalSourceGUID, String externalSourceName, ConnectorType connectorType) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addConnectorType";
        ConnectorTypeBuilder connectorTypeBuilder = new ConnectorTypeBuilder(connectorType.getQualifiedName(), connectorType.getDisplayName(), connectorType.getDescription(), connectorType.getConnectorProviderClassName(), connectorType.getRecognizedAdditionalProperties(), connectorType.getRecognizedSecuredProperties(), connectorType.getRecognizedConfigurationProperties(), connectorType.getAdditionalProperties(), connectorType.getExtendedProperties(), this.repositoryHelper, this.serviceName, this.serverName);
        return this.repositoryHandler.createEntity(userId, externalSourceGUID, externalSourceName, "954421eb-33a6-462d-a8ca-b5709a1bd0d4", "ConnectorType", connectorTypeBuilder.getInstanceProperties("addConnectorType"), "addConnectorType");
    }

    String updateConnectorType(String userId, String externalSourceGUID, String externalSourceName, String existingConnectorTypeGUID, ConnectorType connectorType) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateConnectorType";
        ConnectorTypeBuilder connectorTypeBuilder = new ConnectorTypeBuilder(connectorType.getQualifiedName(), connectorType.getDisplayName(), connectorType.getDescription(), connectorType.getConnectorProviderClassName(), connectorType.getRecognizedAdditionalProperties(), connectorType.getRecognizedSecuredProperties(), connectorType.getRecognizedConfigurationProperties(), connectorType.getAdditionalProperties(), connectorType.getExtendedProperties(), this.repositoryHelper, this.serviceName, this.serverName);
        this.repositoryHandler.updateEntityProperties(userId, externalSourceGUID, externalSourceName, existingConnectorTypeGUID, "954421eb-33a6-462d-a8ca-b5709a1bd0d4", "ConnectorType", connectorTypeBuilder.getInstanceProperties("updateConnectorType"), "updateConnectorType");
        return existingConnectorTypeGUID;
    }

    public void removeConnectorType(String userId, String externalSourceGUID, String externalSourceName, String connectorTypeGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeConnectorType";
        String guidParameterName = "connectorTypeGUID";
        this.repositoryHandler.removeEntityOnLastUse(userId, externalSourceGUID, externalSourceName, connectorTypeGUID, "connectorTypeGUID", "954421eb-33a6-462d-a8ca-b5709a1bd0d4", "ConnectorType", "removeConnectorType");
    }

    public ConnectorType getConnectorType(String userId, String connectorTypeGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getConnectorType";
        String guidParameterName = "connectorTypeGUID";
        EntityDetail connectorTypeEntity = this.repositoryHandler.getEntityByGUID(userId, connectorTypeGUID, "connectorTypeGUID", "ConnectorType", "getConnectorType");
        ConnectorTypeConverter converter = new ConnectorTypeConverter(connectorTypeEntity, this.repositoryHelper, this.serviceName, this.serverName);
        return converter.getBean();
    }
}

