/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.ffdc.OMAGOCFErrorCode;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryErrorHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementClassification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class RootBuilder {
    protected RepositoryErrorHandler errorHandler;
    protected OMRSRepositoryHelper repositoryHelper;
    protected String serviceName;
    protected String serverName;
    protected List<ElementClassification> classifications = null;

    protected RootBuilder(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        this.repositoryHelper = repositoryHelper;
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.errorHandler = new RepositoryErrorHandler(repositoryHelper, serviceName, serverName);
    }

    public void setClassifications(List<ElementClassification> classifications) {
        this.classifications = classifications;
    }

    public List<Classification> getEntityClassifications(String methodName) throws InvalidParameterException {
        if (this.classifications == null) {
            return null;
        }
        if (this.classifications.isEmpty()) {
            return null;
        }
        ArrayList<Classification> entityClassifications = new ArrayList<Classification>();
        for (ElementClassification classification : this.classifications) {
            if (classification == null) continue;
            Classification entityClassification = new Classification();
            if (classification.getClassificationName() == null) {
                throw new InvalidParameterException(OMAGOCFErrorCode.NULL_CLASSIFICATION_NAME.getMessageDefinition(new String[]{this.serviceName, methodName}), this.getClass().getName(), methodName, "Classification name");
            }
            entityClassification.setName(classification.getClassificationName());
            try {
                entityClassification.setProperties(this.repositoryHelper.addPropertyMapToInstance(this.serviceName, null, classification.getClassificationProperties(), methodName));
            }
            catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException error) {
                throw new InvalidParameterException(OMAGOCFErrorCode.BAD_CLASSIFICATION_PROPERTIES.getMessageDefinition(new String[]{this.serviceName, classification.getClassificationName(), error.getMessage()}), this.getClass().getName(), methodName, (Throwable)error, "Properties for classification " + classification.getClassificationName());
            }
        }
        return entityClassifications;
    }

    protected InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        return null;
    }
}

