/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.ConnectionBuilder;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.EmbeddedConnectionBuilder;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.ConnectionConverter;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.ConnectorTypeHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.EndpointHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.RootHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.EmbeddedConnection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.VirtualConnection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ConnectionHandler
extends RootHandler {
    private EndpointHandler endpointHandler;
    private ConnectorTypeHandler connectorTypeHandler;

    public ConnectionHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper) {
        super(serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper);
        this.endpointHandler = new EndpointHandler(serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper);
        this.connectorTypeHandler = new ConnectorTypeHandler(serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper);
    }

    private String findConnection(String userId, String connectionGUID, String qualifiedName, String displayName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "connectionGUID";
        String qualifiedNameParameter = "qualifiedName";
        if (connectionGUID != null && this.repositoryHandler.isEntityKnown(userId, connectionGUID, "Connection", methodName, "connectionGUID") != null) {
            return connectionGUID;
        }
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        ConnectionBuilder connectionBuilder = new ConnectionBuilder(qualifiedName, displayName, null, this.repositoryHelper, this.serviceName, this.serverName);
        EntityDetail existingConnection = this.repositoryHandler.getUniqueEntityByName(userId, qualifiedName, "qualifiedName", connectionBuilder.getQualifiedNameInstanceProperties(methodName), "114e9f8f-5ff3-4c32-bd37-a7eb42712253", "Connection", methodName);
        if (existingConnection != null) {
            return existingConnection.getGUID();
        }
        return null;
    }

    private String findConnectionByName(String userId, String qualifiedName, String displayName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String connectionGUID = this.findConnection(userId, null, qualifiedName, displayName, methodName);
        if (connectionGUID != null) {
            return connectionGUID;
        }
        if (displayName != null) {
            String qualifiedNameParameter = "qualifiedName";
            ConnectionBuilder connectionBuilder = new ConnectionBuilder(qualifiedName, displayName, null, this.repositoryHelper, this.serviceName, this.serverName);
            EntityDetail existingConnection = this.repositoryHandler.getUniqueEntityByName(userId, qualifiedName, "qualifiedName", connectionBuilder.getNameInstanceProperties(methodName), "114e9f8f-5ff3-4c32-bd37-a7eb42712253", "Connection", methodName);
            if (existingConnection != null) {
                return existingConnection.getGUID();
            }
        }
        return null;
    }

    private String findConnection(String userId, Connection connection, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (connection != null) {
            return this.findConnection(userId, connection.getGUID(), connection.getQualifiedName(), connection.getDisplayName(), methodName);
        }
        return null;
    }

    public String saveConnection(String userId, String externalSourceGUID, String externalSourceName, Connection connection) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "saveConnection";
        String connectionParameterName = "connection";
        String connectorTypeParameterName = "connection.connectorType";
        this.invalidParameterHandler.validateObject((Object)connection, "connection", "saveConnection");
        this.invalidParameterHandler.validateObject((Object)connection.getConnectorType(), "connection.connectorType", "saveConnection");
        String existingConnection = this.findConnection(userId, connection, "saveConnection");
        if (existingConnection == null) {
            return this.addConnection(userId, externalSourceGUID, externalSourceName, connection);
        }
        return this.updateConnection(userId, externalSourceGUID, externalSourceName, existingConnection, connection);
    }

    private void saveAssociatedConnectionEntities(String userId, String externalSourceGUID, String externalSourceName, String connectionGUID, Endpoint endpoint, ConnectorType connectorType, List<EmbeddedConnection> embeddedConnections, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (endpoint != null) {
            String endpointGUID = this.endpointHandler.saveEndpoint(userId, externalSourceGUID, externalSourceName, endpoint);
            if (endpointGUID != null) {
                this.repositoryHandler.ensureRelationship(userId, "Endpoint", null, null, endpointGUID, connectionGUID, "887a7132-d6bc-4b92-a483-e80b60c86fb2", "ConnectionEndpoint", null, methodName);
            }
        } else {
            this.repositoryHandler.removeAllRelationshipsOfType(userId, externalSourceGUID, externalSourceName, connectionGUID, "Connection", "887a7132-d6bc-4b92-a483-e80b60c86fb2", "ConnectionEndpoint", methodName);
        }
        if (connectorType != null) {
            String connectorTypeGUID = this.connectorTypeHandler.saveConnectorType(userId, externalSourceGUID, externalSourceName, connectorType);
            if (connectorTypeGUID != null) {
                this.repositoryHandler.ensureRelationship(userId, externalSourceGUID, externalSourceName, "Connection", connectionGUID, connectorTypeGUID, "e542cfc1-0b4b-42b9-9921-f0a5a88aaf96", "ConnectionConnectorType", null, methodName);
            }
        } else {
            this.repositoryHandler.removeAllRelationshipsOfType(userId, externalSourceGUID, externalSourceName, connectionGUID, "Connection", "e542cfc1-0b4b-42b9-9921-f0a5a88aaf96", "ConnectionConnectorType", methodName);
        }
        this.repositoryHandler.removeAllRelationshipsOfType(userId, externalSourceGUID, externalSourceName, connectionGUID, "Connection", "eb6dfdd2-8c6f-4f0d-a17d-f6ce4799f64f", "EmbeddedConnection", methodName);
        if (embeddedConnections != null && !embeddedConnections.isEmpty()) {
            for (EmbeddedConnection embeddedConnection : embeddedConnections) {
                if (embeddedConnection == null) continue;
                Connection realConnection = embeddedConnection.getEmbeddedConnection();
                String realConnectionGUID = this.saveConnection(userId, externalSourceGUID, externalSourceName, realConnection);
                if (realConnection == null) continue;
                EmbeddedConnectionBuilder embeddedConnectionBuilder = new EmbeddedConnectionBuilder(embeddedConnection.getArguments(), embeddedConnection.getDisplayName(), this.repositoryHelper, this.serviceName);
                this.repositoryHandler.createRelationship(userId, "e542cfc1-0b4b-42b9-9921-f0a5a88aaf96", externalSourceGUID, externalSourceName, connectionGUID, realConnectionGUID, embeddedConnectionBuilder.getInstanceProperties(methodName), methodName);
            }
        }
    }

    private String addConnection(String userId, String externalSourceGUID, String externalSourceName, Connection connection) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addConnection";
        String parameterName = "connection.connectorType";
        this.invalidParameterHandler.validateObject((Object)connection.getConnectorType(), "connection.connectorType", "addConnection");
        String connectionTypeGUID = "114e9f8f-5ff3-4c32-bd37-a7eb42712253";
        String connectionTypeName = "Connection";
        List embeddedConnections = null;
        if (connection instanceof VirtualConnection) {
            connectionTypeGUID = "82f9c664-e59d-484c-a8f3-17088c23a2f3";
            connectionTypeName = "VirtualConnection";
            VirtualConnection virtualConnection = (VirtualConnection)connection;
            embeddedConnections = virtualConnection.getEmbeddedConnections();
        }
        ConnectionBuilder connectionBuilder = new ConnectionBuilder(connection.getQualifiedName(), connection.getDisplayName(), connection.getDescription(), connection.getAdditionalProperties(), connection.getSecuredProperties(), connection.getConfigurationProperties(), connection.getUserId(), connection.getClearPassword(), connection.getEncryptedPassword(), connection.getExtendedProperties(), this.repositoryHelper, this.serviceName, this.serverName);
        String connectionGUID = this.repositoryHandler.createEntity(userId, externalSourceGUID, externalSourceName, connectionTypeGUID, connectionTypeName, connectionBuilder.getInstanceProperties("addConnection"), "addConnection");
        this.saveAssociatedConnectionEntities(userId, externalSourceGUID, externalSourceName, connectionGUID, connection.getEndpoint(), connection.getConnectorType(), embeddedConnections, "addConnection");
        return connectionGUID;
    }

    private String updateConnection(String userId, String externalSourceGUID, String externalSourceName, String existingConnectionGUID, Connection connection) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateConnection";
        String parameterName = "connection.connectorType";
        this.invalidParameterHandler.validateObject((Object)connection.getConnectorType(), "connection.connectorType", "updateConnection");
        String connectionTypeGUID = "114e9f8f-5ff3-4c32-bd37-a7eb42712253";
        String connectionTypeName = "Connection";
        List embeddedConnections = null;
        if (connection instanceof VirtualConnection) {
            connectionTypeGUID = "82f9c664-e59d-484c-a8f3-17088c23a2f3";
            connectionTypeName = "VirtualConnection";
            VirtualConnection virtualConnection = (VirtualConnection)connection;
            embeddedConnections = virtualConnection.getEmbeddedConnections();
        }
        ConnectionBuilder connectionBuilder = new ConnectionBuilder(connection.getQualifiedName(), connection.getDisplayName(), connection.getDescription(), connection.getAdditionalProperties(), connection.getSecuredProperties(), connection.getConfigurationProperties(), connection.getUserId(), connection.getClearPassword(), connection.getEncryptedPassword(), connection.getExtendedProperties(), this.repositoryHelper, this.serviceName, this.serverName);
        this.repositoryHandler.updateEntityProperties(userId, externalSourceGUID, externalSourceName, existingConnectionGUID, connectionTypeGUID, connectionTypeName, connectionBuilder.getInstanceProperties("updateConnection"), "updateConnection");
        this.saveAssociatedConnectionEntities(userId, externalSourceGUID, externalSourceName, existingConnectionGUID, connection.getEndpoint(), connection.getConnectorType(), embeddedConnections, "updateConnection");
        return existingConnectionGUID;
    }

    public void removeConnection(String userId, String externalSourceGUID, String externalSourceName, String connectionGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeConnection";
        String guidParameterName = "connectionGUID";
        Connection connection = this.getConnection(userId, connectionGUID);
        if (connection != null) {
            List embeddedConnections;
            ConnectorType connectorType;
            Endpoint endpoint = connection.getEndpoint();
            if (endpoint != null) {
                this.repositoryHandler.removeRelationshipBetweenEntities(userId, externalSourceGUID, externalSourceName, "887a7132-d6bc-4b92-a483-e80b60c86fb2", "ConnectionEndpoint", endpoint.getGUID(), "Endpoint", connectionGUID, "removeConnection");
                this.endpointHandler.removeEndpoint(userId, externalSourceGUID, externalSourceName, endpoint.getGUID());
            }
            if ((connectorType = connection.getConnectorType()) != null) {
                this.repositoryHandler.removeRelationshipBetweenEntities(userId, externalSourceGUID, externalSourceName, "e542cfc1-0b4b-42b9-9921-f0a5a88aaf96", "ConnectionConnectorType", connectionGUID, "Connection", connectorType.getGUID(), "removeConnection");
                this.connectorTypeHandler.removeConnectorType(userId, externalSourceGUID, externalSourceName, connectorType.getGUID());
            }
            if (connection instanceof VirtualConnection && (embeddedConnections = ((VirtualConnection)connection).getEmbeddedConnections()) != null) {
                for (EmbeddedConnection embeddedConnection : embeddedConnections) {
                    Connection realConnection = embeddedConnection.getEmbeddedConnection();
                    this.repositoryHandler.removeRelationshipBetweenEntities(userId, externalSourceGUID, externalSourceName, "eb6dfdd2-8c6f-4f0d-a17d-f6ce4799f64f", "EmbeddedConnection", connectionGUID, "VirtualConnection", realConnection.getGUID(), "removeConnection");
                    if (realConnection == null) continue;
                    this.removeConnection(userId, externalSourceGUID, externalSourceName, realConnection.getGUID());
                }
            }
            this.repositoryHandler.removeEntityOnLastUse(userId, externalSourceGUID, externalSourceName, connectionGUID, "connectionGUID", "114e9f8f-5ff3-4c32-bd37-a7eb42712253", "Connection", "removeConnection");
        }
    }

    public Connection getConnection(String userId, String connectionGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityProxy entityProxy;
        EntityProxy entityProxy2;
        String methodName = "getConnection";
        String guidParameterName = "connectionGUID";
        EntityDetail connectionEntity = this.repositoryHandler.getEntityByGUID(userId, connectionGUID, "connectionGUID", "Connection", "getConnection");
        Endpoint endpoint = null;
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, connectionGUID, "Connection", "887a7132-d6bc-4b92-a483-e80b60c86fb2", "ConnectionEndpoint", "getConnection");
        if (relationship != null && (entityProxy2 = relationship.getEntityOneProxy()) != null) {
            endpoint = this.endpointHandler.getEndpoint(userId, entityProxy2.getGUID());
        }
        ConnectorType connectorType = null;
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, connectionGUID, "Connection", "e542cfc1-0b4b-42b9-9921-f0a5a88aaf96", "ConnectionConnectorType", "getConnection");
        if (relationship != null && (entityProxy = relationship.getEntityTwoProxy()) != null) {
            connectorType = this.connectorTypeHandler.getConnectorType(userId, entityProxy.getGUID());
        }
        ArrayList<EmbeddedConnection> embeddedConnections = new ArrayList<EmbeddedConnection>();
        List relationships = this.repositoryHandler.getRelationshipsByType(userId, connectionGUID, "Connection", "eb6dfdd2-8c6f-4f0d-a17d-f6ce4799f64f", "eb6dfdd2-8c6f-4f0d-a17d-f6ce4799f64f", "getConnection");
        if (relationships != null) {
            for (Relationship embeddedConnectionRelationship : relationships) {
                if (embeddedConnectionRelationship == null) continue;
                EmbeddedConnection embeddedConnection = new EmbeddedConnection();
                embeddedConnection.setArguments(this.repositoryHelper.getMapFromProperty(this.serviceName, "arguments", embeddedConnectionRelationship.getProperties(), "getConnection"));
                EntityProxy entityProxy3 = embeddedConnectionRelationship.getEntityTwoProxy();
                if (entityProxy3 != null) {
                    embeddedConnection.setEmbeddedConnection(this.getConnection(userId, entityProxy3.getGUID()));
                }
                embeddedConnections.add(embeddedConnection);
            }
        }
        if (embeddedConnections.isEmpty()) {
            embeddedConnections = null;
        }
        ConnectionConverter connectionConverter = new ConnectionConverter(connectionEntity, endpoint, connectorType, embeddedConnections, this.repositoryHelper, this.serviceName, this.serverName);
        return connectionConverter.getBean();
    }

    public Connection getConnectionByName(String userId, String name, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nameParameter = "name";
        this.invalidParameterHandler.validateName(name, "name", methodName);
        String connectionGUID = this.findConnectionByName(userId, name, name, methodName);
        if (connectionGUID != null) {
            return this.getConnection(userId, connectionGUID);
        }
        return null;
    }
}

