/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.SchemaAttributeBuilder;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.SchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.SchemaTypeConverter;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.RootHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ComplexSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementOrigin;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.EnumSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.LiteralSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.MapSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.PrimitiveSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttribute;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaTypeChoice;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SimpleSchemaType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SchemaTypeHandler
extends RootHandler {
    public SchemaTypeHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper) {
        super(serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper);
    }

    private String getAnchorGUIDForType(String userId, String schemaTypeGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, "SchemaType", "815b004d-73c6-4728-9dd9-536f4fe803cd", "AssetSchemaType", methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return proxy.getGUID();
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, "SchemaType", "2d955049-e59b-45dd-8e62-cde1add59f9e", "SchemaAttributeType", methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForAttribute(userId, proxy.getGUID(), methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, "SchemaType", "eb4f1f98-c649-4560-8a46-da17c02764a9", "SchemaTypeOption", methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForType(userId, proxy.getGUID(), methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, "SchemaType", "6189d444-2da4-4cd7-9332-e48a1c340b44", "MapFromElementType", methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForType(userId, proxy.getGUID(), methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, "SchemaType", "8b9856b3-451e-45fc-afc7-fddefd81a73a", "MapToElementType", methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForType(userId, proxy.getGUID(), methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, "SchemaType", "03737169-ceb5-45f0-84f0-21c5929945af", "APIOperations", methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForType(userId, proxy.getGUID(), methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, "SchemaType", "e8fb46d1-5f75-481b-aa66-f43ad44e2cc6", "APIHeader", methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForType(userId, proxy.getGUID(), methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, "SchemaType", "4ab3b466-31bd-48ea-8aa2-75623476f2e2", "APIRequest", methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForType(userId, proxy.getGUID(), methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, "SchemaType", "e8001de2-1bb1-442b-a66f-9addc3641eae", "APIResponse", methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForType(userId, proxy.getGUID(), methodName);
        }
        return null;
    }

    private String getAnchorGUIDForAttribute(String userId, String attributeGUID, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, attributeGUID, "SchemaAttribute", "86b176a2-015c-44a6-8106-54d5d69ba661", "AttributeForSchema", methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForType(userId, proxy.getGUID(), methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, attributeGUID, "SchemaAttribute", "0ffb9d87-7074-45da-a9b0-ae0859611133", "NestedSchemaAttribute", methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForAttribute(userId, proxy.getGUID(), methodName);
        }
        return null;
    }

    public ComplexSchemaType getEmptyComplexSchemaType(String schemaTypeGUID, String schemaTypeName) {
        ComplexSchemaType schemaType = new ComplexSchemaType();
        ElementType elementType = new ElementType();
        elementType.setElementOrigin(ElementOrigin.LOCAL_COHORT);
        elementType.setElementTypeId(schemaTypeGUID);
        elementType.setElementTypeName(schemaTypeName);
        schemaType.setType(elementType);
        return schemaType;
    }

    public SchemaAttribute getEmptyTabularColumn() {
        SchemaAttribute schemaAttribute = new SchemaAttribute();
        ElementType elementType = new ElementType();
        elementType.setElementOrigin(ElementOrigin.LOCAL_COHORT);
        elementType.setElementTypeId("d81a0425-4e9b-4f31-bc1c-e18c3566da10");
        elementType.setElementTypeName("TabularColumn");
        schemaAttribute.setType(elementType);
        return schemaAttribute;
    }

    private SchemaType getSchemaTypeFromEntity(String userId, EntityDetail schemaTypeEntity, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "schemaTypeEntity.getGUID()";
        if (schemaTypeEntity != null && schemaTypeEntity.getType() != null) {
            InstanceProperties properties = schemaTypeEntity.getProperties();
            String typeName = this.repositoryHelper.removeStringProperty(this.serviceName, "typeName", properties, methodName);
            if (properties != null) {
                int attributeCount = 0;
                if (typeName != null && this.repositoryHelper.isTypeOf(this.serviceName, typeName, "ComplexSchemaType")) {
                    attributeCount = this.countSchemaAttributes(userId, schemaTypeEntity.getGUID(), "schemaTypeEntity.getGUID()", methodName);
                }
                SchemaTypeConverter converter = new SchemaTypeConverter(schemaTypeEntity, attributeCount, this.repositoryHelper, this.serviceName, this.serverName);
                return this.getEmbeddedTypes(userId, schemaTypeEntity.getGUID(), converter.getBean(), methodName);
            }
        }
        return null;
    }

    private SchemaType getEmbeddedTypes(String userId, String schemaElementGUID, SchemaType parentSchemaType, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List entities;
        if (parentSchemaType instanceof MapSchemaType) {
            EntityDetail entity = this.repositoryHandler.getEntityForRelationshipType(userId, schemaElementGUID, "MapSchemaType", "6189d444-2da4-4cd7-9332-e48a1c340b44", "MapFromElementType", methodName);
            if (entity != null) {
                ((MapSchemaType)parentSchemaType).setMapFromElement(this.getSchemaTypeFromEntity(userId, entity, methodName));
            }
            if ((entity = this.repositoryHandler.getEntityForRelationshipType(userId, schemaElementGUID, "MapSchemaType", "8b9856b3-451e-45fc-afc7-fddefd81a73a", "MapToElementType", methodName)) != null) {
                ((MapSchemaType)parentSchemaType).setMapToElement(this.getSchemaTypeFromEntity(userId, entity, methodName));
            }
        } else if (parentSchemaType instanceof SchemaTypeChoice && (entities = this.repositoryHandler.getEntitiesForRelationshipType(userId, schemaElementGUID, "SchemaTypeChoice", "eb4f1f98-c649-4560-8a46-da17c02764a9", "SchemaTypeOption", 0, this.invalidParameterHandler.getMaxPagingSize(), methodName)) != null) {
            ArrayList<SchemaType> schemaTypes = new ArrayList<SchemaType>();
            for (EntityDetail entity : entities) {
                if (entity == null) continue;
                schemaTypes.add(this.getSchemaTypeFromEntity(userId, entity, methodName));
            }
            if (!schemaTypes.isEmpty()) {
                ((SchemaTypeChoice)parentSchemaType).setSchemaOptions(schemaTypes);
            }
        }
        return parentSchemaType;
    }

    int countSchemaAttributes(String userId, String schemaElementGUID, String guidParameterName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(schemaElementGUID, guidParameterName, methodName);
        int count = this.repositoryHandler.countAttachedRelationshipsByType(userId, schemaElementGUID, "SchemaElement", "0ffb9d87-7074-45da-a9b0-ae0859611133", "NestedSchemaAttribute", methodName);
        if (count == 0) {
            count = this.repositoryHandler.countAttachedRelationshipsByType(userId, schemaElementGUID, "ComplexSchemaType", "86b176a2-015c-44a6-8106-54d5d69ba661", "AttributeForSchema", methodName);
        }
        return count;
    }

    private String findSchemaAttribute(String userId, String schemaAttributeGUID, String qualifiedName, String attributeName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "schemaAttributeGUID";
        String qualifiedNameParameter = "qualifiedName";
        if (schemaAttributeGUID != null && this.repositoryHandler.isEntityKnown(userId, schemaAttributeGUID, "SchemaAttribute", methodName, "schemaAttributeGUID") != null) {
            return schemaAttributeGUID;
        }
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        SchemaAttributeBuilder builder = new SchemaAttributeBuilder(qualifiedName, attributeName, this.repositoryHelper, this.serviceName, this.serverName);
        EntityDetail existingSchemaType = this.repositoryHandler.getUniqueEntityByName(userId, qualifiedName, "qualifiedName", builder.getQualifiedNameInstanceProperties(methodName), "1a5e159b-913a-43b1-95fe-04433b25fca9", "SchemaAttribute", methodName);
        if (existingSchemaType != null) {
            return existingSchemaType.getGUID();
        }
        return null;
    }

    private String addSchemaAttribute(String userId, String externalSourceGUID, String externalSourceName, SchemaAttribute schemaAttribute) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addSchemaAttribute";
        SchemaAttributeBuilder schemaAttributeBuilder = this.getSchemaAttributeBuilder(schemaAttribute);
        String schemaAttributeGUID = this.repositoryHandler.createEntity(userId, this.getSchemaAttributeTypeGUID(schemaAttribute), this.getSchemaAttributeTypeName(schemaAttribute), externalSourceGUID, externalSourceName, schemaAttributeBuilder.getInstanceProperties("addSchemaAttribute"), "addSchemaAttribute");
        SchemaType schemaType = schemaAttribute.getAttributeType();
        if (schemaType != null) {
            if (schemaType.getExtendedProperties() == null && (schemaType instanceof ComplexSchemaType || schemaType instanceof LiteralSchemaType || schemaType instanceof SimpleSchemaType)) {
                SchemaTypeBuilder schemaTypeBuilder = this.getSchemaTypeBuilder(schemaType);
                this.repositoryHandler.classifyEntity(userId, externalSourceGUID, externalSourceName, schemaAttributeGUID, "e2bb76bb-774a-43ff-9045-3a05f663d5d9", "TypeEmbeddedAttribute", null, null, schemaTypeBuilder.getInstanceProperties("addSchemaAttribute"), "addSchemaAttribute");
            } else {
                String schemaTypeGUID = this.addSchemaType(userId, externalSourceGUID, externalSourceName, schemaType);
                if (schemaTypeGUID != null) {
                    this.repositoryHandler.createRelationship(userId, externalSourceGUID, externalSourceName, "2d955049-e59b-45dd-8e62-cde1add59f9e", schemaAttributeGUID, schemaTypeGUID, null, "addSchemaAttribute");
                }
            }
        }
        return schemaAttributeGUID;
    }

    @Deprecated
    public String addExternalSchemaAttribute(String userId, SchemaAttribute schemaAttribute, String externalSourceGUID, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.addSchemaAttribute(userId, externalSourceGUID, externalSourceName, schemaAttribute);
    }

    @Deprecated
    public String updateSchemaAttribute(String userId, String existingSchemaAttributeGUID, SchemaAttribute schemaAttribute) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateSchemaAttribute";
        SchemaAttributeBuilder builder = this.getSchemaAttributeBuilder(schemaAttribute);
        this.repositoryHandler.updateEntity(userId, existingSchemaAttributeGUID, this.getSchemaAttributeTypeGUID(schemaAttribute), this.getSchemaAttributeTypeName(schemaAttribute), builder.getInstanceProperties("updateSchemaAttribute"), "updateSchemaAttribute");
        return existingSchemaAttributeGUID;
    }

    public SchemaAttributeBuilder getSchemaAttributeBuilder(SchemaAttribute schemaAttribute) {
        SchemaAttributeBuilder builder = null;
        if (schemaAttribute != null) {
            String typeName = "SchemaAttribute";
            String typeId = "1a5e159b-913a-43b1-95fe-04433b25fca9";
            ElementType type = schemaAttribute.getType();
            if (type != null) {
                typeName = type.getElementTypeName();
                typeId = type.getElementTypeId();
            }
            EnumPropertyValue sortOrder = null;
            if (schemaAttribute.getSortOrder() != null) {
                sortOrder = new EnumPropertyValue();
                sortOrder.setOrdinal(schemaAttribute.getSortOrder().getOrdinal());
                sortOrder.setSymbolicName(schemaAttribute.getSortOrder().getName());
                sortOrder.setDescription(schemaAttribute.getSortOrder().getDescription());
            }
            builder = new SchemaAttributeBuilder(schemaAttribute.getQualifiedName(), schemaAttribute.getDisplayName(), schemaAttribute.getDescription(), schemaAttribute.getElementPosition(), schemaAttribute.getMinCardinality(), schemaAttribute.getMaxCardinality(), schemaAttribute.getIsDeprecated(), schemaAttribute.getDefaultValueOverride(), schemaAttribute.getAllowsDuplicateValues(), schemaAttribute.getOrderedValues(), sortOrder, schemaAttribute.getMinimumLength(), schemaAttribute.getLength(), schemaAttribute.getPrecision(), schemaAttribute.getIsNullable(), schemaAttribute.getNativeJavaClass(), schemaAttribute.getAliases(), schemaAttribute.getAdditionalProperties(), schemaAttribute.getAnchorGUID(), typeName, typeId, schemaAttribute.getExtendedProperties(), this.repositoryHelper, this.serviceName, this.serverName);
        }
        return builder;
    }

    private String getSchemaAttributeTypeGUID(SchemaAttribute schemaAttribute) {
        ElementType type = schemaAttribute.getType();
        if (type != null) {
            return type.getElementTypeId();
        }
        return "1a5e159b-913a-43b1-95fe-04433b25fca9";
    }

    private String getSchemaAttributeTypeName(SchemaAttribute schemaAttribute) {
        ElementType type = schemaAttribute.getType();
        if (type != null) {
            return type.getElementTypeName();
        }
        return "SchemaAttribute";
    }

    private String findSchemaType(String userId, String schemaTypeGUID, String qualifiedName, String displayName, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "schemaTypeGUID";
        String qualifiedNameParameter = "qualifiedName";
        if (schemaTypeGUID != null && this.repositoryHandler.isEntityKnown(userId, schemaTypeGUID, "SchemaType", methodName, "schemaTypeGUID") != null) {
            return schemaTypeGUID;
        }
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, this.repositoryHelper, this.serviceName, this.serverName);
        EntityDetail existingSchemaType = this.repositoryHandler.getUniqueEntityByName(userId, qualifiedName, "qualifiedName", builder.getQualifiedNameInstanceProperties(methodName), "5bd4a3e7-d22d-4a3d-a115-066ee8e0754f", "SchemaType", methodName);
        if (existingSchemaType != null) {
            return existingSchemaType.getGUID();
        }
        return null;
    }

    private String addSchemaType(String userId, String externalSourceGUID, String externalSourceName, SchemaTypeBuilder schemaTypeBuilder, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String schemaTypeGUID = this.repositoryHandler.createEntity(userId, schemaTypeBuilder.getTypeId(), schemaTypeBuilder.getTypeName(), externalSourceGUID, externalSourceName, schemaTypeBuilder.getInstanceProperties(methodName), schemaTypeBuilder.getEntityClassifications(userId, methodName), methodName);
        this.addEmbeddedTypes(userId, externalSourceGUID, externalSourceName, schemaTypeGUID, schemaTypeBuilder, methodName);
        return schemaTypeGUID;
    }

    private String addSchemaType(String userId, String externalSourceGUID, String externalSourceName, SchemaType schemaType) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addSchemaType";
        SchemaTypeBuilder schemaTypeBuilder = this.getSchemaTypeBuilder(schemaType);
        String schemaTypeGUID = this.repositoryHandler.createEntity(userId, this.getSchemaTypeTypeGUID(schemaType), this.getSchemaTypeTypeName(schemaType), externalSourceGUID, externalSourceName, schemaTypeBuilder.getInstanceProperties("addSchemaType"), "addSchemaType");
        return this.addEmbeddedTypes(userId, externalSourceGUID, externalSourceName, schemaTypeGUID, schemaType);
    }

    private String addEmbeddedTypes(String userId, String externalSourceGUID, String externalSourceName, String schemaTypeGUID, SchemaType schemaType) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List schemaOptions;
        String methodName = "addEmbeddedTypes";
        if (schemaType instanceof MapSchemaType) {
            String mapToGUID;
            String mapFromGUID;
            SchemaType mapFrom = ((MapSchemaType)schemaType).getMapFromElement();
            SchemaType mapTo = ((MapSchemaType)schemaType).getMapToElement();
            if (mapFrom != null && (mapFromGUID = this.addSchemaType(userId, externalSourceGUID, externalSourceName, mapFrom)) != null) {
                this.repositoryHandler.createRelationship(userId, "MapFromElementType", externalSourceGUID, externalSourceName, schemaTypeGUID, mapFromGUID, null, "addEmbeddedTypes");
            }
            if (mapTo != null && (mapToGUID = this.addSchemaType(userId, externalSourceGUID, externalSourceName, mapTo)) != null) {
                this.repositoryHandler.createRelationship(userId, "MapToElementType", externalSourceGUID, externalSourceName, schemaTypeGUID, mapToGUID, null, "addEmbeddedTypes");
            }
        } else if (schemaType instanceof SchemaTypeChoice && (schemaOptions = ((SchemaTypeChoice)schemaType).getSchemaOptions()) != null) {
            for (SchemaType option : schemaOptions) {
                String optionGUID;
                if (option == null || (optionGUID = this.addSchemaType(userId, externalSourceGUID, externalSourceName, option)) == null) continue;
                this.repositoryHandler.createRelationship(userId, "eb4f1f98-c649-4560-8a46-da17c02764a9", externalSourceGUID, externalSourceName, schemaTypeGUID, optionGUID, null, "addEmbeddedTypes");
            }
        }
        return schemaTypeGUID;
    }

    private void addEmbeddedTypes(String userId, String externalSourceGUID, String externalSourceName, String schemaTypeGUID, SchemaTypeBuilder schemaTypeBuilder, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<SchemaTypeBuilder> schemaOptions;
        if ("MapSchemaType".equals(schemaTypeBuilder.getTypeName())) {
            String mapToGUID;
            String mapFromGUID;
            SchemaTypeBuilder mapFrom = schemaTypeBuilder.getMapFrom();
            SchemaTypeBuilder mapTo = schemaTypeBuilder.getMapTo();
            if (mapFrom != null && (mapFromGUID = this.addSchemaType(userId, externalSourceGUID, externalSourceName, mapFrom, methodName)) != null) {
                this.repositoryHandler.createRelationship(userId, "MapFromElementType", externalSourceGUID, externalSourceName, schemaTypeGUID, mapFromGUID, null, methodName);
            }
            if (mapTo != null && (mapToGUID = this.addSchemaType(userId, externalSourceGUID, externalSourceName, mapTo, methodName)) != null) {
                this.repositoryHandler.createRelationship(userId, "MapToElementType", externalSourceGUID, externalSourceName, schemaTypeGUID, mapToGUID, null, methodName);
            }
        } else if ("SchemaTypeChoice".equals(schemaTypeBuilder.getTypeName()) && (schemaOptions = schemaTypeBuilder.getSchemaOptions()) != null) {
            for (SchemaTypeBuilder option : schemaOptions) {
                String optionGUID;
                if (option == null || (optionGUID = this.addSchemaType(userId, externalSourceGUID, externalSourceName, option, methodName)) == null) continue;
                this.repositoryHandler.createRelationship(userId, "eb4f1f98-c649-4560-8a46-da17c02764a9", externalSourceGUID, externalSourceName, schemaTypeGUID, optionGUID, null, methodName);
            }
        }
    }

    public String addExternalSchemaType(String userId, SchemaType schemaType, String externalSourceGUID, String externalSourceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.addSchemaType(userId, externalSourceGUID, externalSourceName, schemaType);
    }

    @Deprecated
    public String updateSchemaType(String userId, String existingSchemaTypeGUID, SchemaType schemaType) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateSchemaType";
        SchemaTypeBuilder schemaTypeBuilder = this.getSchemaTypeBuilder(schemaType);
        this.repositoryHandler.updateEntity(userId, existingSchemaTypeGUID, this.getSchemaTypeTypeGUID(schemaType), this.getSchemaTypeTypeName(schemaType), schemaTypeBuilder.getInstanceProperties("updateSchemaType"), "updateSchemaType");
        return existingSchemaTypeGUID;
    }

    private String getSchemaTypeTypeGUID(SchemaType schemaType) {
        ElementType type = schemaType.getType();
        if (type != null) {
            return type.getElementTypeId();
        }
        return "5bd4a3e7-d22d-4a3d-a115-066ee8e0754f";
    }

    private String getSchemaTypeTypeName(SchemaType schemaType) {
        ElementType type = schemaType.getType();
        if (type != null) {
            return type.getElementTypeName();
        }
        return "SchemaType";
    }

    private SchemaTypeBuilder getSchemaTypeBuilder(SchemaType schemaType) {
        SchemaTypeBuilder builder = null;
        if (schemaType != null) {
            String typeName = null;
            if (schemaType.getType() != null) {
                typeName = schemaType.getType().getElementTypeName();
            }
            if (typeName == null) {
                typeName = schemaType instanceof PrimitiveSchemaType ? "PrimitiveSchemaType" : (schemaType instanceof EnumSchemaType ? "EnumSchemaType" : (schemaType instanceof SimpleSchemaType ? "SimpleSchemaType" : (schemaType instanceof LiteralSchemaType ? "LiteralSchemaType" : (schemaType instanceof ComplexSchemaType ? "ComplexSchemaType" : (schemaType instanceof MapSchemaType ? "MapSchemaType" : "SchemaType")))));
            }
            builder = new SchemaTypeBuilder(schemaType.getQualifiedName(), schemaType.getDisplayName(), schemaType.getDescription(), schemaType.getVersionNumber(), schemaType.getIsDeprecated(), schemaType.getAuthor(), schemaType.getUsage(), schemaType.getEncodingStandard(), schemaType.getNamespace(), schemaType.getAdditionalProperties(), schemaType.getAnchorGUID(), typeName, null, schemaType.getExtendedProperties(), this.repositoryHelper, this.serviceName, this.serverName);
            if (schemaType instanceof SimpleSchemaType) {
                builder.setDataType(((SimpleSchemaType)schemaType).getDataType());
                builder.setDefaultValue(((SimpleSchemaType)schemaType).getDefaultValue());
            } else if (schemaType instanceof LiteralSchemaType) {
                builder.setDataType(((LiteralSchemaType)schemaType).getDataType());
                builder.setFixedValue(((LiteralSchemaType)schemaType).getFixedValue());
            }
        }
        return builder;
    }
}

