/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.RootBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.LatestChange;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Referenceable;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SecurityTags;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class ReferenceableBuilder
extends RootBuilder {
    protected String qualifiedName = null;
    protected String typeId = null;
    protected String typeName = null;
    protected Map<String, String> additionalProperties = null;
    protected Map<String, Object> extendedProperties = null;
    protected LatestChange latestChange = null;
    private SecurityTags securityTags = null;

    protected ReferenceableBuilder(String qualifiedName, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
        this.qualifiedName = qualifiedName;
    }

    protected ReferenceableBuilder(String qualifiedName, String typeName, String typeId, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
        this.qualifiedName = qualifiedName;
        this.typeId = typeId;
        this.typeName = typeName;
    }

    protected ReferenceableBuilder(String qualifiedName, Map<String, String> additionalProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
        this.qualifiedName = qualifiedName;
        this.additionalProperties = additionalProperties;
    }

    protected ReferenceableBuilder(String qualifiedName, Map<String, String> additionalProperties, String typeName, String typeId, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
        this.qualifiedName = qualifiedName;
        this.typeId = typeId;
        this.typeName = typeName;
        this.additionalProperties = additionalProperties;
    }

    @Deprecated
    protected ReferenceableBuilder(String qualifiedName, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
        this.qualifiedName = qualifiedName;
        this.additionalProperties = additionalProperties;
        this.extendedProperties = extendedProperties;
    }

    protected ReferenceableBuilder(String qualifiedName, Map<String, String> additionalProperties, String typeName, String typeId, Map<String, Object> extendedProperties, LatestChange latestChange, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
        this.qualifiedName = qualifiedName;
        this.typeId = typeId;
        this.typeName = typeName;
        this.additionalProperties = additionalProperties;
        this.extendedProperties = extendedProperties;
        this.latestChange = latestChange;
    }

    protected ReferenceableBuilder(String qualifiedName, Map<String, String> additionalProperties, String typeName, String typeId, Map<String, Object> extendedProperties, String actionDescription, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
        this.qualifiedName = qualifiedName;
        this.typeId = typeId;
        this.typeName = typeName;
        this.additionalProperties = additionalProperties;
        this.extendedProperties = extendedProperties;
        this.latestChange = new LatestChange();
        this.latestChange.setActionDescription(actionDescription);
    }

    protected ReferenceableBuilder(String qualifiedName, Map<String, String> additionalProperties, String typeName, String typeId, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
        this.qualifiedName = qualifiedName;
        this.typeId = typeId;
        this.typeName = typeName;
        this.extendedProperties = extendedProperties;
    }

    public ReferenceableBuilder(Referenceable beanProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) throws InvalidParameterException {
        super(repositoryHelper, serviceName, serverName);
        if (beanProperties != null) {
            this.qualifiedName = beanProperties.getQualifiedName();
            this.additionalProperties = beanProperties.getAdditionalProperties();
        }
    }

    public String getTypeId() {
        return this.typeId;
    }

    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.qualifiedName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "qualifiedName", this.qualifiedName, methodName);
        }
        if (this.additionalProperties != null) {
            properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, "additionalProperties", this.additionalProperties, methodName);
        }
        return properties;
    }

    public InstanceProperties getNameInstanceProperties(String methodName) {
        InstanceProperties properties = null;
        if (this.qualifiedName != null) {
            String literalQualifiedName = this.repositoryHelper.getExactMatchRegex(this.qualifiedName);
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "qualifiedName", literalQualifiedName, methodName);
        }
        return properties;
    }

    public InstanceProperties getQualifiedNameInstanceProperties(String methodName) {
        return this.getNameInstanceProperties(methodName);
    }

    public InstanceProperties getSearchInstanceProperties(String methodName) {
        InstanceProperties properties = null;
        if (this.qualifiedName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "qualifiedName", this.qualifiedName, methodName);
        }
        return properties;
    }

    private InstanceProperties getSecurityTagProperties(String methodName) {
        InstanceProperties properties = null;
        if (this.securityTags != null) {
            if (this.securityTags.getSecurityLabels() != null) {
                properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, null, "securityLabels", this.securityTags.getSecurityLabels(), methodName);
            }
            if (this.securityTags.getSecurityProperties() != null) {
                properties = this.repositoryHelper.addMapPropertyToInstance(this.serviceName, properties, "securityLabels", this.securityTags.getSecurityProperties(), methodName);
            }
        }
        return properties;
    }

    public List<Classification> getEntityClassifications(String userId, String methodName) throws InvalidParameterException {
        List entityClassifications = null;
        if (this.securityTags != null) {
            try {
                Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, "SecurityTags", this.typeName, null, null, this.getSecurityTagProperties(methodName));
                entityClassifications = this.repositoryHelper.addClassificationToList(this.serviceName, null, classification, methodName);
            }
            catch (TypeErrorException error) {
                throw new InvalidParameterException((OCFCheckedExceptionBase)error, "classificationName");
            }
        }
        return entityClassifications;
    }
}

