/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Asset;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.OwnerType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Referenceable;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class AssetBuilder
extends ReferenceableBuilder {
    private String displayName;
    private String description;
    private String owner = null;
    private OwnerType ownerType = null;
    private List<String> zoneMembership = null;

    public AssetBuilder(Asset assetProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) throws InvalidParameterException {
        super((Referenceable)assetProperties, repositoryHelper, serviceName, serverName);
        this.displayName = assetProperties.getDisplayName();
        this.description = assetProperties.getDescription();
        this.owner = assetProperties.getOwner();
        this.ownerType = assetProperties.getOwnerType();
        this.zoneMembership = assetProperties.getZoneMembership();
    }

    public AssetBuilder(String qualifiedName, String displayName, String description, String owner, OwnerType ownerType, List<String> zoneMembership, Map<String, String> origin, String latestChange, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, "Asset", "896d14c2-7522-4f6c-8519-757711943fe6", extendedProperties, latestChange, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
        this.owner = owner;
        this.ownerType = ownerType;
        this.zoneMembership = zoneMembership;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.displayName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "name", this.displayName, methodName);
        }
        if (this.description != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", this.description, methodName);
        }
        return properties;
    }

    public InstanceProperties getZoneMembershipProperties(String methodName) {
        InstanceProperties properties = null;
        if (this.zoneMembership != null) {
            properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, null, "zoneMembership", this.zoneMembership, methodName);
        }
        return properties;
    }

    public InstanceProperties getOwnerProperties(String methodName) {
        InstanceProperties properties = null;
        if (this.owner != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "owner", this.owner, methodName);
        }
        if (this.ownerType != null) {
            properties = this.addOwnerTypeToProperties(properties, methodName);
        }
        return properties;
    }

    private InstanceProperties addOwnerTypeToProperties(InstanceProperties properties, String methodName) {
        InstanceProperties resultingProperties = properties;
        switch (this.ownerType) {
            case USER_ID: {
                resultingProperties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, resultingProperties, "ownerType", 0, "UserId", "The owner's userId is specified (default).", methodName);
                break;
            }
            case PROFILE_ID: {
                resultingProperties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, resultingProperties, "ownerType", 1, "ProfileId", "The unique identifier (guid) of the profile of the owner.", methodName);
                break;
            }
            case OTHER: {
                resultingProperties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, resultingProperties, "ownerType", 99, "Other", "Another type of owner identifier, probably not supported by open metadata.", methodName);
            }
        }
        return resultingProperties;
    }
}

