/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementOrigin;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;

class TypeConverter {
    TypeConverter() {
    }

    ElementType getElementType(InstanceType instanceType, InstanceProvenanceType instanceProvenanceType, String metadataCollectionId, String metadataCollectionName, String elementLicense) {
        ElementType elementType = new ElementType();
        if (instanceType != null) {
            elementType.setElementTypeId(instanceType.getTypeDefGUID());
            elementType.setElementTypeName(instanceType.getTypeDefName());
            elementType.setElementTypeVersion(instanceType.getTypeDefVersion());
            elementType.setElementTypeDescription(instanceType.getTypeDefDescription());
            List typeDefSuperTypes = instanceType.getTypeDefSuperTypes();
            if (typeDefSuperTypes != null && !typeDefSuperTypes.isEmpty()) {
                ArrayList<String> superTypes = new ArrayList<String>();
                for (TypeDefLink typeDefLink : typeDefSuperTypes) {
                    if (typeDefLink == null) continue;
                    superTypes.add(typeDefLink.getName());
                }
                if (!superTypes.isEmpty()) {
                    elementType.setElementSuperTypeNames(superTypes);
                }
            }
        }
        elementType.setElementMetadataCollectionId(metadataCollectionId);
        elementType.setElementMetadataCollectionName(metadataCollectionName);
        elementType.setElementOrigin(this.getElementOrigin(instanceProvenanceType));
        elementType.setElementSourceServer(metadataCollectionName);
        elementType.setElementLicense(elementLicense);
        return elementType;
    }

    private ElementOrigin getElementOrigin(InstanceProvenanceType instanceProvenanceType) {
        if (instanceProvenanceType != null) {
            switch (instanceProvenanceType) {
                case DEREGISTERED_REPOSITORY: {
                    return ElementOrigin.DEREGISTERED_REPOSITORY;
                }
                case EXTERNAL_SOURCE: {
                    return ElementOrigin.EXTERNAL_SOURCE;
                }
                case EXPORT_ARCHIVE: {
                    return ElementOrigin.EXPORT_ARCHIVE;
                }
                case LOCAL_COHORT: {
                    return ElementOrigin.LOCAL_COHORT;
                }
                case CONTENT_PACK: {
                    return ElementOrigin.CONTENT_PACK;
                }
                case CONFIGURATION: {
                    return ElementOrigin.CONFIGURATION;
                }
                case UNKNOWN: {
                    return ElementOrigin.UNKNOWN;
                }
            }
        }
        return ElementOrigin.UNKNOWN;
    }
}

