/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.ElementHeaderConverter;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementBase;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementClassification;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Referenceable;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ReferenceableConverter
extends ElementHeaderConverter {
    public ReferenceableConverter(EntityDetail entity, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(entity, repositoryHelper, serviceName, serverName);
    }

    public ReferenceableConverter(EntityDetail entity, Relationship relationship, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(entity, relationship, repositoryHelper, serviceName, serverName);
    }

    protected void updateBean(Referenceable bean) {
        if (this.entity != null) {
            super.updateBean((ElementBase)bean);
            bean.setClassifications(this.getClassificationsFromEntity());
        }
    }

    public Referenceable getBean() {
        Referenceable bean = null;
        if (this.entity != null) {
            bean = new Referenceable();
            this.updateBean(bean);
        }
        return bean;
    }

    private List<ElementClassification> getClassificationsFromEntity() {
        List entityClassifications;
        ArrayList classifications = null;
        if (this.entity != null && (entityClassifications = this.entity.getClassifications()) != null) {
            classifications = new ArrayList();
            for (Classification entityClassification : entityClassifications) {
                if (entityClassification == null) continue;
                ElementClassification beanClassification = new ElementClassification();
                beanClassification.setClassificationName(entityClassification.getName());
                beanClassification.setClassificationProperties(this.repositoryHelper.getInstancePropertiesAsMap(entityClassification.getProperties()));
            }
        }
        return classifications;
    }

    protected InstanceProperties getClassificationProperties(String classificationName) {
        List entityClassifications;
        if (this.entity != null && (entityClassifications = this.entity.getClassifications()) != null) {
            for (Classification entityClassification : entityClassifications) {
                if (entityClassification == null || !classificationName.equals(entityClassification.getName())) continue;
                return entityClassification.getProperties();
            }
        }
        return null;
    }
}

