/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters;

import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.TypeConverter;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ElementHeaderConverter {
    protected EntityDetail entity;
    protected Relationship relationship = null;
    protected OMRSRepositoryHelper repositoryHelper;
    protected String serviceName;
    protected String serverName;
    protected String typeName;

    ElementHeaderConverter(EntityDetail entity, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        this.entity = entity;
        this.repositoryHelper = repositoryHelper;
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.setTypeName();
    }

    public ElementHeaderConverter(EntityDetail entity, Relationship relationship, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        this.entity = entity;
        this.relationship = relationship;
        this.repositoryHelper = repositoryHelper;
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.setTypeName();
    }

    protected void setTypeName() {
        InstanceType type;
        if (this.entity != null && (type = this.entity.getType()) != null) {
            this.typeName = type.getTypeDefName();
        }
    }

    public void updateBean(ElementHeader bean) {
        if (this.entity != null) {
            TypeConverter typeConverter = new TypeConverter();
            bean.setType(typeConverter.getElementType(this.entity.getType(), this.entity.getInstanceProvenanceType(), this.entity.getMetadataCollectionId(), this.entity.getMetadataCollectionName(), this.entity.getInstanceLicense()));
            bean.setGUID(this.entity.getGUID());
            bean.setURL(this.entity.getInstanceURL());
        } else if (this.typeName != null) {
            ElementType type = new ElementType();
            type.setElementTypeName(this.typeName);
            bean.setType(type);
        }
    }
}

