/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters;

import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.ReferenceableConverter;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Asset;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.OwnerType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Referenceable;
import org.odpi.openmetadata.metadatasecurity.properties.AssetAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class AssetConverter
extends ReferenceableConverter {
    public AssetConverter(EntityDetail assetEntity, Relationship connectionToAssetRelationship, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(assetEntity, connectionToAssetRelationship, repositoryHelper, serviceName, serverName);
    }

    public AssetConverter(EntityDetail assetEntity, Relationship connectionToAssetRelationship, OMRSRepositoryHelper repositoryHelper, String serviceName) {
        super(assetEntity, connectionToAssetRelationship, repositoryHelper, serviceName, null);
    }

    protected Asset getNewBean() {
        return new Asset();
    }

    public Asset getAssetBean() {
        Asset bean = null;
        if (this.entity != null) {
            bean = this.getNewBean();
            this.updateBean(bean);
        }
        return bean;
    }

    public AssetAuditHeader getAssetAuditHeader() {
        if (this.entity != null) {
            AssetAuditHeader auditHeader = new AssetAuditHeader();
            auditHeader.setCreatedBy(this.entity.getCreatedBy());
            auditHeader.setCreateTime(this.entity.getCreateTime());
            auditHeader.setMaintainedBy(this.entity.getMaintainedBy());
            auditHeader.setUpdatedBy(this.entity.getUpdatedBy());
            auditHeader.setUpdateTime(this.entity.getUpdateTime());
            auditHeader.setVersion(this.entity.getVersion());
            return auditHeader;
        }
        return null;
    }

    protected void updateBean(Asset bean) {
        String methodName = "getBean";
        if (this.entity != null) {
            super.updateBean((Referenceable)bean);
            InstanceProperties instanceProperties = this.entity.getProperties();
            if (instanceProperties != null) {
                bean.setQualifiedName(this.repositoryHelper.removeStringProperty(this.serviceName, "qualifiedName", instanceProperties, "getBean"));
                bean.setDisplayName(this.repositoryHelper.removeStringProperty(this.serviceName, "name", instanceProperties, "getBean"));
                bean.setDescription(this.repositoryHelper.removeStringProperty(this.serviceName, "description", instanceProperties, "getBean"));
                bean.setOwner(this.repositoryHelper.removeStringProperty(this.serviceName, "owner", instanceProperties, "getBean"));
                bean.setOwnerType(this.removeOwnerTypeFromProperties(instanceProperties));
                bean.setZoneMembership(this.repositoryHelper.removeStringArrayProperty(this.serviceName, "zoneMembership", instanceProperties, "getBean"));
                bean.setAdditionalProperties(this.repositoryHelper.removeStringMapFromProperty(this.serviceName, "additionalProperties", instanceProperties, "getBean"));
                bean.setExtendedProperties(this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties));
            }
            if (this.relationship != null && (instanceProperties = this.relationship.getProperties()) != null) {
                bean.setConnectionDescription(this.repositoryHelper.getStringProperty(this.serviceName, "assetSummary", instanceProperties, "getBean"));
            }
            if ((instanceProperties = super.getClassificationProperties("AssetZoneMembership")) != null) {
                bean.setZoneMembership(this.repositoryHelper.getStringArrayProperty(this.serviceName, "zoneMembership", instanceProperties, "getBean"));
            }
            if ((instanceProperties = super.getClassificationProperties("AssetOwnership")) != null) {
                bean.setOwner(this.repositoryHelper.getStringProperty(this.serviceName, "owner", instanceProperties, "getBean"));
                bean.setOwnerType(this.getOwnerTypeFromProperties(instanceProperties));
            }
            if ((instanceProperties = super.getClassificationProperties("Ownership")) != null) {
                bean.setOwner(this.repositoryHelper.getStringProperty(this.serviceName, "owner", instanceProperties, "getBean"));
                bean.setOwnerTypeName(this.repositoryHelper.getStringProperty(this.serviceName, "ownerTypeName", instanceProperties, "getBean"));
                bean.setOwnerPropertyName(this.repositoryHelper.getStringProperty(this.serviceName, "ownerPropertyName", instanceProperties, "getBean"));
            }
            if ((instanceProperties = super.getClassificationProperties("AssetOrigin")) != null) {
                Map propertyMap;
                HashMap<String, String> origins = new HashMap<String, String>();
                String propertyValue = this.repositoryHelper.getStringProperty(this.serviceName, "organization", instanceProperties, "getBean");
                if (propertyValue != null) {
                    origins.put("organization", propertyValue);
                }
                if ((propertyValue = this.repositoryHelper.getStringProperty(this.serviceName, "businessCapability", instanceProperties, "getBean")) != null) {
                    origins.put("businessCapability", propertyValue);
                }
                if ((propertyMap = this.repositoryHelper.getStringMapFromProperty(this.serviceName, "otherOriginValues", instanceProperties, "getBean")) != null) {
                    for (String propertyName : propertyMap.keySet()) {
                        if (propertyName == null) continue;
                        origins.put(propertyName, (String)propertyMap.get(propertyName));
                    }
                }
                if (!origins.isEmpty()) {
                    bean.setAssetOrigin(origins);
                }
            }
        }
    }

    private OwnerType getOwnerTypeFromProperties(InstanceProperties properties) {
        InstancePropertyValue instancePropertyValue;
        Map instancePropertiesMap;
        OwnerType ownerType = OwnerType.OTHER;
        if (properties != null && (instancePropertiesMap = properties.getInstanceProperties()) != null && (instancePropertyValue = (InstancePropertyValue)instancePropertiesMap.get("ownerType")) instanceof EnumPropertyValue) {
            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            switch (enumPropertyValue.getOrdinal()) {
                case 0: {
                    ownerType = OwnerType.USER_ID;
                    break;
                }
                case 1: {
                    ownerType = OwnerType.PROFILE_ID;
                    break;
                }
                case 99: {
                    ownerType = OwnerType.OTHER;
                }
            }
        }
        return ownerType;
    }

    private OwnerType removeOwnerTypeFromProperties(InstanceProperties properties) {
        OwnerType ownerType = this.getOwnerTypeFromProperties(properties);
        if (properties != null) {
            Map instancePropertiesMap = properties.getInstanceProperties();
            if (instancePropertiesMap != null) {
                instancePropertiesMap.remove("ownerType");
            }
            properties.setInstanceProperties(instancePropertiesMap);
        }
        return ownerType;
    }
}

