/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters;

import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.TypeConverter;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementBase;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementOrigin;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ElementHeaderConverter {
    protected EntityDetail entity;
    protected Relationship relationship = null;
    protected OMRSRepositoryHelper repositoryHelper;
    protected String serviceName;
    protected String serverName;
    protected String typeName;

    ElementHeaderConverter(EntityDetail entity, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        this.entity = entity;
        this.repositoryHelper = repositoryHelper;
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.setTypeName();
    }

    public ElementHeaderConverter(EntityDetail entity, Relationship relationship, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        this.entity = entity;
        this.relationship = relationship;
        this.repositoryHelper = repositoryHelper;
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.setTypeName();
    }

    protected void setTypeName() {
        InstanceType type;
        if (this.entity != null && (type = this.entity.getType()) != null) {
            this.typeName = type.getTypeDefName();
        }
    }

    public void updateBean(ElementBase bean) {
        if (this.entity != null) {
            TypeConverter typeConverter = new TypeConverter(this.repositoryHelper, this.serviceName);
            bean.setType(typeConverter.getElementType(this.entity.getType()));
            ElementOrigin elementOrigin = new ElementOrigin();
            elementOrigin.setHomeMetadataCollectionId(this.entity.getMetadataCollectionId());
            elementOrigin.setHomeMetadataCollectionName(this.entity.getMetadataCollectionName());
            elementOrigin.setOriginCategory(typeConverter.getElementOrigin(this.entity.getInstanceProvenanceType()));
            elementOrigin.setSourceServer(this.serverName);
            elementOrigin.setLicense(this.entity.getInstanceLicense());
            bean.setOrigin(elementOrigin);
            bean.setGUID(this.entity.getGUID());
        } else if (this.typeName != null) {
            ElementType type = new ElementType();
            type.setTypeName(this.typeName);
            bean.setType(type);
        }
    }
}

