/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementOriginCategory;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

class TypeConverter {
    private final OMRSRepositoryHelper repositoryHelper;
    private final String sourceName;

    TypeConverter(OMRSRepositoryHelper repositoryHelper, String sourceName) {
        this.repositoryHelper = repositoryHelper;
        this.sourceName = sourceName;
    }

    ElementType getElementType(InstanceType instanceType) {
        ElementType elementType = new ElementType();
        if (instanceType != null) {
            String typeName = instanceType.getTypeDefName();
            elementType.setTypeId(instanceType.getTypeDefGUID());
            elementType.setTypeName(typeName);
            elementType.setTypeVersion(instanceType.getTypeDefVersion());
            String description = this.repositoryHelper.getTypeDefByName(this.sourceName, typeName).getDescription();
            elementType.setTypeDescription(description);
            List typeDefSuperTypes = this.repositoryHelper.getSuperTypes(this.sourceName, typeName);
            if (typeDefSuperTypes != null && !typeDefSuperTypes.isEmpty()) {
                ArrayList<String> superTypes = new ArrayList<String>();
                for (TypeDefLink typeDefLink : typeDefSuperTypes) {
                    if (typeDefLink == null) continue;
                    superTypes.add(typeDefLink.getName());
                }
                if (!superTypes.isEmpty()) {
                    elementType.setSuperTypeNames(superTypes);
                }
            }
        }
        return elementType;
    }

    public ElementOriginCategory getElementOrigin(InstanceProvenanceType instanceProvenanceType) {
        if (instanceProvenanceType != null) {
            switch (instanceProvenanceType) {
                case DEREGISTERED_REPOSITORY: {
                    return ElementOriginCategory.DEREGISTERED_REPOSITORY;
                }
                case EXTERNAL_SOURCE: {
                    return ElementOriginCategory.EXTERNAL_SOURCE;
                }
                case EXPORT_ARCHIVE: {
                    return ElementOriginCategory.EXPORT_ARCHIVE;
                }
                case LOCAL_COHORT: {
                    return ElementOriginCategory.LOCAL_COHORT;
                }
                case CONTENT_PACK: {
                    return ElementOriginCategory.CONTENT_PACK;
                }
                case CONFIGURATION: {
                    return ElementOriginCategory.CONFIGURATION;
                }
                case UNKNOWN: {
                    return ElementOriginCategory.UNKNOWN;
                }
            }
        }
        return ElementOriginCategory.UNKNOWN;
    }
}

