/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.admin;

import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.auditlog.OCFMetadataAuditCode;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.server.OCFMetadataInstanceHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.server.OCFMetadataServicesInstance;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class OCFMetadataOperationalServices {
    private String serverName;
    private OMRSAuditLog auditLog;

    @Deprecated
    public OCFMetadataOperationalServices(String serverName, OMRSRepositoryConnector repositoryConnector, OMRSAuditLog auditLog) throws NewInstanceException {
        this(serverName, repositoryConnector, auditLog, null, 500);
    }

    public OCFMetadataOperationalServices(String serverName, OMRSRepositoryConnector repositoryConnector, OMRSAuditLog auditLog, String localServerUserId, int maxPageSize) throws NewInstanceException {
        this.serverName = serverName;
        this.auditLog = auditLog;
        String actionDescription = "initialize";
        OCFMetadataAuditCode auditCode = OCFMetadataAuditCode.SERVICE_INITIALIZING;
        auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
        try {
            auditCode = OCFMetadataAuditCode.SERVICE_INITIALIZED;
            auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(serverName), null, auditCode.getSystemAction(), auditCode.getUserAction());
            new OCFMetadataServicesInstance(repositoryConnector, auditLog, localServerUserId, maxPageSize);
        }
        catch (Throwable error) {
            auditCode = OCFMetadataAuditCode.SERVICE_INSTANCE_FAILURE;
            auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(error.getMessage()), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        OCFMetadataAuditCode auditCode = OCFMetadataAuditCode.SERVICE_SHUTDOWN;
        this.auditLog.logRecord("shutdown", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.serverName), null, auditCode.getSystemAction(), auditCode.getUserAction());
        new OCFMetadataInstanceHandler().removeServerServiceInstance(this.serverName);
    }
}

