/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.server;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.AssetHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.CertificationHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.ConnectionHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.ExternalIdentifierHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.ExternalReferenceHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.InformalTagHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.LicenseHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.LikeHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.LocationHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.NoteHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.NoteLogHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.RatingHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.RelatedMediaHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.SchemaTypeHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.AssetResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.CertificationsResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.CommentResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.CommentsResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ConnectionResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ConnectionsResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ExternalIdentifiersResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ExternalReferencesResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.InformalTagsResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.LicensesResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.LikesResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.LocationsResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.MoreInformationResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.NoteLogResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.NoteLogsResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.NotesResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.RatingsResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.RelatedAssetsResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.RelatedMediaReferencesResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.SchemaAttributesResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.server.OCFMetadataInstanceHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Comment;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.NoteLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCFMetadataRESTServices {
    private static OCFMetadataInstanceHandler instanceHandler = new OCFMetadataInstanceHandler();
    private static final Logger log = LoggerFactory.getLogger(OCFMetadataRESTServices.class);
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public ConnectionResponse getConnectionByGUID(String serverName, String serviceURLName, String userId, String guid) {
        String methodName = "getConnectionByGUID";
        log.debug("Calling method: getConnectionByGUID from service " + serviceURLName + " for server " + serverName);
        ConnectionResponse response = new ConnectionResponse();
        AuditLog auditLog = null;
        try {
            ConnectionHandler connectionHandler = instanceHandler.getConnectionHandler(userId, serverName, "getConnectionByGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConnectionByGUID");
            response.setConnection(connectionHandler.getConnection(userId, guid));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getConnectionByGUID", auditLog);
        }
        log.debug("Returning from method: getConnectionByGUID with response: " + response.toString());
        return response;
    }

    public GUIDResponse getAssetForConnectionGUID(String serverName, String serviceURLName, String userId, String connectionGUID) {
        String methodName = "getAssetForConnectionGUID";
        log.debug("Calling method: getAssetForConnectionGUID from service " + serviceURLName + " for server " + serverName);
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetForConnectionGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetForConnectionGUID");
            response.setGUID(handler.getAssetForConnection(userId, connectionGUID));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getAssetForConnectionGUID", auditLog);
        }
        log.debug("Returning from method: getAssetForConnectionGUID with response: " + response.toString());
        return response;
    }

    public ConnectionResponse getConnectionForAsset(String serverName, String serviceURLName, String userId, String assetGUID) {
        String methodName = "getConnectionForAsset";
        log.debug("Calling method: getConnectionForAsset from service " + serviceURLName + " for server " + serverName);
        ConnectionResponse response = new ConnectionResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "getConnectionForAsset");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConnectionForAsset");
            response.setConnection(handler.getConnectionForAsset(userId, assetGUID));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getConnectionForAsset", auditLog);
        }
        log.debug("Returning from method: getConnectionForAsset with response: " + response.toString());
        return response;
    }

    private AssetResponse getAssetResponse(String serverName, String serviceURLName, String userId, String assetGUID, String connectionGUID, String methodName) {
        log.debug("Calling method: " + methodName + " from service " + serviceURLName + " for server " + serverName);
        AssetResponse response = new AssetResponse();
        AuditLog auditLog = null;
        try {
            List supportedZones = instanceHandler.getSupportedZones(userId, serverName, serviceURLName, methodName);
            AssetHandler assetHandler = instanceHandler.getAssetHandler(userId, serverName, methodName);
            auditLog = instanceHandler.getAuditLog(userId, serverName, methodName);
            if (connectionGUID != null) {
                response.setAsset(assetHandler.getValidatedVisibleAsset(userId, supportedZones, assetGUID, connectionGUID, instanceHandler.getServiceName(serviceURLName), methodName));
            } else {
                response.setAsset(assetHandler.getValidatedVisibleAsset(userId, supportedZones, assetGUID, instanceHandler.getServiceName(serviceURLName), methodName));
            }
            response.setCertificationCount(assetHandler.getCertificationCount(userId, assetGUID, methodName));
            response.setCommentCount(assetHandler.getCommentCount(userId, assetGUID, methodName));
            response.setConnectionCount(assetHandler.getConnectionCount(userId, assetGUID, methodName));
            response.setExternalIdentifierCount(assetHandler.getExternalIdentifierCount(userId, assetGUID, methodName));
            response.setExternalReferencesCount(assetHandler.getExternalReferencesCount(userId, assetGUID, methodName));
            response.setInformalTagCount(assetHandler.getInformalTagCount(userId, assetGUID, methodName));
            response.setLicenseCount(assetHandler.getLicenseCount(userId, assetGUID, methodName));
            response.setLikeCount(assetHandler.getLikeCount(userId, assetGUID, methodName));
            response.setKnownLocationsCount(assetHandler.getKnownLocationsCount(userId, assetGUID, methodName));
            response.setNoteLogsCount(assetHandler.getNoteLogsCount(userId, assetGUID, methodName));
            response.setRatingsCount(assetHandler.getRatingsCount(userId, assetGUID, methodName));
            response.setRelatedAssetCount(assetHandler.getRelatedAssetCount(userId, assetGUID, methodName));
            response.setRelatedMediaReferenceCount(assetHandler.getRelatedMediaReferenceCount(userId, assetGUID, methodName));
            response.setSchemaType(assetHandler.getSchemaType(userId, assetGUID, methodName));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, methodName, auditLog);
        }
        log.debug("Returning from method: " + methodName + " for server " + serverName + " with response: " + response.toString());
        return response;
    }

    public AssetResponse getConnectedAssetSummary(String serverName, String serviceURLName, String userId, String assetGUID, String connectionGUID) {
        String methodName = "getConnectedAssetSummary";
        return this.getAssetResponse(serverName, serviceURLName, userId, assetGUID, connectionGUID, "getConnectedAssetSummary");
    }

    public AssetResponse getAssetSummary(String serverName, String serviceURLName, String userId, String assetGUID) {
        String methodName = "getAssetSummary";
        return this.getAssetResponse(serverName, serviceURLName, userId, assetGUID, null, "getAssetSummary");
    }

    public CertificationsResponse getCertifications(String serverName, String serviceURLName, String userId, String assetGUID, int elementStart, int maxElements) {
        String methodName = "getCertifications";
        log.debug("Calling method: getCertifications for server " + serverName);
        CertificationsResponse response = new CertificationsResponse();
        AuditLog auditLog = null;
        try {
            CertificationHandler handler = instanceHandler.getCertificationHandler(userId, serverName, "getCertifications");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCertifications");
            response.setList(handler.getCertifications(userId, assetGUID, elementStart, maxElements, "getCertifications"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getCertifications", auditLog);
        }
        log.debug("Returning from method: getCertifications for server " + serverName + " with response: " + response.toString());
        return response;
    }

    private CommentsResponse getAttachedComments(String serverName, String serviceURLName, String userId, String assetGUID, String anchorGUID, int elementStart, int maxElements, String methodName) {
        log.debug("Calling method: " + methodName + " for server " + serverName);
        CommentsResponse response = new CommentsResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, methodName);
            auditLog = instanceHandler.getAuditLog(userId, serverName, methodName);
            List attachedComments = handler.getAssetComments(userId, instanceHandler.getSupportedZones(userId, serverName, serviceURLName, methodName), assetGUID, anchorGUID, elementStart, maxElements, methodName);
            ArrayList<CommentResponse> results = new ArrayList<CommentResponse>();
            if (attachedComments != null) {
                for (Comment comment : attachedComments) {
                    if (comment == null) continue;
                    CommentResponse commentResponse = new CommentResponse();
                    commentResponse.setComment(comment);
                    commentResponse.setReplyCount(handler.getCommentCount(userId, comment.getGUID(), methodName));
                    results.add(commentResponse);
                }
            }
            if (results.isEmpty()) {
                response.setList(null);
            } else {
                response.setList(results);
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, methodName, auditLog);
        }
        log.debug("Returning from method: " + methodName + " for server " + serverName + " with response: " + response.toString());
        return response;
    }

    public CommentsResponse getAssetComments(String serverName, String serviceURLName, String userId, String assetGUID, int elementStart, int maxElements) {
        String methodName = "getAssetComments";
        return this.getAttachedComments(serverName, serviceURLName, userId, assetGUID, assetGUID, elementStart, maxElements, "getAssetComments");
    }

    public CommentsResponse getAssetCommentReplies(String serverName, String serviceURLName, String userId, String assetGUID, String commentGUID, int elementStart, int maxElements) {
        String methodName = "getAssetCommentReplies";
        return this.getAttachedComments(serverName, serviceURLName, userId, assetGUID, commentGUID, elementStart, maxElements, "getAssetCommentReplies");
    }

    public ConnectionsResponse getConnections(String serverName, String serviceURLName, String userId, String assetGUID, int elementStart, int maxElements) {
        String methodName = "getConnections";
        log.debug("Calling method: getConnections for server " + serverName);
        ConnectionsResponse response = new ConnectionsResponse();
        AuditLog auditLog = null;
        try {
            ConnectionHandler handler = instanceHandler.getConnectionHandler(userId, serverName, "getConnections");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConnections");
            response.setList(handler.getConnections(userId, assetGUID, elementStart, maxElements, "getConnections"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getConnections", auditLog);
        }
        log.debug("Returning from method: getConnections for server " + serverName + " with response: " + response.toString());
        return response;
    }

    public ExternalIdentifiersResponse getExternalIdentifiers(String serverName, String serviceURLName, String userId, String assetGUID, int elementStart, int maxElements) {
        String methodName = "getExternalIdentifiers";
        log.debug("Calling method: getExternalIdentifiers for server " + serverName);
        ExternalIdentifiersResponse response = new ExternalIdentifiersResponse();
        AuditLog auditLog = null;
        try {
            ExternalIdentifierHandler handler = instanceHandler.getExternalIdentifierHandler(userId, serverName, "getExternalIdentifiers");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getExternalIdentifiers");
            response.setList(handler.getExternalIdentifiers(userId, assetGUID, elementStart, maxElements, "getExternalIdentifiers"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getExternalIdentifiers", auditLog);
        }
        log.debug("Returning from method: getExternalIdentifiers for server " + serverName + " with response: " + response.toString());
        return response;
    }

    public ExternalReferencesResponse getExternalReferences(String serverName, String serviceURLName, String userId, String assetGUID, int elementStart, int maxElements) {
        String methodName = "getExternalReferences";
        log.debug("Calling method: getExternalReferences for server " + serverName);
        ExternalReferencesResponse response = new ExternalReferencesResponse();
        AuditLog auditLog = null;
        try {
            ExternalReferenceHandler handler = instanceHandler.getExternalReferenceHandler(userId, serverName, "getExternalReferences");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getExternalReferences");
            response.setList(handler.getExternalReferences(userId, assetGUID, elementStart, maxElements, "getExternalReferences"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getExternalReferences", auditLog);
        }
        log.debug("Returning from method: getExternalReferences for server " + serverName + " with response: " + response.toString());
        return response;
    }

    public InformalTagsResponse getInformalTags(String serverName, String serviceURLName, String userId, String assetGUID, int elementStart, int maxElements) {
        String methodName = "getInformalTags";
        log.debug("Calling method: getInformalTags for server " + serverName);
        InformalTagsResponse response = new InformalTagsResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler handler = instanceHandler.getInformalTagHandler(userId, serverName, "getInformalTags");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getInformalTags");
            response.setList(handler.getAttachedTags(userId, assetGUID, "Asset", elementStart, maxElements, "getInformalTags"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getInformalTags", auditLog);
        }
        log.debug("Returning from method: getInformalTags for server " + serverName + " with response: " + response.toString());
        return response;
    }

    public LicensesResponse getLicenses(String serverName, String serviceURLName, String userId, String assetGUID, int elementStart, int maxElements) {
        String methodName = "getLicenses";
        log.debug("Calling method: getLicenses for server " + serverName);
        LicensesResponse response = new LicensesResponse();
        AuditLog auditLog = null;
        try {
            LicenseHandler handler = instanceHandler.getLicenseHandler(userId, serverName, "getLicenses");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getLicenses");
            response.setList(handler.getLicenses(userId, assetGUID, elementStart, maxElements, "getLicenses"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getLicenses", auditLog);
        }
        log.debug("Returning from method: getLicenses for server " + serverName + " with response: " + response.toString());
        return response;
    }

    public LikesResponse getLikes(String serverName, String serviceURLName, String userId, String assetGUID, int elementStart, int maxElements) {
        String methodName = "getLikes";
        log.debug("Calling method: getLikes for server " + serverName);
        LikesResponse response = new LikesResponse();
        AuditLog auditLog = null;
        try {
            LikeHandler handler = instanceHandler.getLikeHandler(userId, serverName, "getLikes");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getLikes");
            response.setList(handler.getLikes(userId, assetGUID, elementStart, maxElements, "getLikes"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getLikes", auditLog);
        }
        log.debug("Returning from method: getLikes for server " + serverName + " with response: " + response.toString());
        return response;
    }

    public LocationsResponse getKnownLocations(String serverName, String serviceURLName, String userId, String assetGUID, int elementStart, int maxElements) {
        String methodName = "getKnownLocations";
        log.debug("Calling method: getKnownLocations for server " + serverName);
        LocationsResponse response = new LocationsResponse();
        AuditLog auditLog = null;
        try {
            LocationHandler handler = instanceHandler.getLocationHandler(userId, serverName, "getKnownLocations");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getKnownLocations");
            response.setList(handler.getLocations(userId, assetGUID, elementStart, maxElements, "getKnownLocations"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getKnownLocations", auditLog);
        }
        log.debug("Returning from method: getKnownLocations for server " + serverName + " with response: " + response.toString());
        return response;
    }

    public NoteLogsResponse getNoteLogs(String serverName, String serviceURLName, String userId, String assetGUID, int elementStart, int maxElements) {
        String methodName = "getNoteLogs";
        log.debug("Calling method: getNoteLogs for server " + serverName);
        NoteLogsResponse response = new NoteLogsResponse();
        AuditLog auditLog = null;
        try {
            NoteLogHandler handler = instanceHandler.getNoteLogHandler(userId, serverName, "getNoteLogs");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNoteLogs");
            List noteLogs = handler.getAttachedNoteLogs(userId, assetGUID, elementStart, maxElements, "getNoteLogs");
            ArrayList<NoteLogResponse> results = new ArrayList<NoteLogResponse>();
            for (NoteLog noteLog : noteLogs) {
                if (noteLog == null) continue;
                NoteLogResponse noteLogResponse = new NoteLogResponse();
                noteLogResponse.setNoteLog(noteLog);
                noteLogResponse.setNoteCount(handler.countAttachedNoteLogs(userId, noteLog.getGUID(), "getNoteLogs"));
                results.add(noteLogResponse);
            }
            if (results.isEmpty()) {
                response.setList(null);
            } else {
                response.setList(results);
            }
            response.setList(results);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getNoteLogs", auditLog);
        }
        log.debug("Returning from method: getNoteLogs for server " + serverName + " with response: " + response.toString());
        return response;
    }

    public NotesResponse getNotes(String serverName, String serviceURLName, String userId, String noteLogGUID, int elementStart, int maxElements) {
        String methodName = "getNotes";
        log.debug("Calling method: getNotes for server " + serverName);
        NotesResponse response = new NotesResponse();
        AuditLog auditLog = null;
        try {
            NoteHandler handler = instanceHandler.getNoteHandler(userId, serverName, "getNotes");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNotes");
            response.setList(handler.getNotes(userId, noteLogGUID, elementStart, maxElements, "getNotes"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getNotes", auditLog);
        }
        log.debug("Returning from method: getNotes for server " + serverName + " with response: " + response.toString());
        return response;
    }

    public RatingsResponse getRatings(String serverName, String serviceURLName, String userId, String assetGUID, int elementStart, int maxElements) {
        String methodName = "getRatings";
        log.debug("Calling method: getRatings for server " + serverName);
        RatingsResponse response = new RatingsResponse();
        AuditLog auditLog = null;
        try {
            RatingHandler handler = instanceHandler.getRatingHandler(userId, serverName, "getRatings");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRatings");
            response.setList(handler.getRatings(userId, assetGUID, elementStart, maxElements, "getRatings"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getRatings", auditLog);
        }
        log.debug("Returning from method: getRatings for server " + serverName + " with response: " + response.toString());
        return response;
    }

    public RelatedAssetsResponse getRelatedAssets(String serverName, String serviceURLName, String userId, String assetGUID, int elementStart, int maxElements) {
        String methodName = "getRelatedAssets";
        log.debug("Calling method: getRelatedAssets for server " + serverName);
        RelatedAssetsResponse response = new RelatedAssetsResponse();
        AuditLog auditLog = null;
        try {
            List supportedZones = instanceHandler.getSupportedZones(userId, serverName, serviceURLName, "getRelatedAssets");
            AssetHandler handler = instanceHandler.getAssetHandler(userId, serverName, "getRelatedAssets");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRelatedAssets");
            response.setList(handler.getRelatedAssets(userId, supportedZones, assetGUID, elementStart, maxElements, serviceURLName, "getRelatedAssets"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getRelatedAssets", auditLog);
        }
        log.debug("Returning from method: getRelatedAssets for server " + serverName + " with response: " + response.toString());
        return response;
    }

    public MoreInformationResponse getMoreInformation(String serverName, String serviceURLName, String userId, String elementGUID, int elementStart, int maxElements) {
        String methodName = "getMoreInformation";
        log.debug("Calling method: getMoreInformation for server " + serverName);
        MoreInformationResponse response = new MoreInformationResponse();
        AuditLog auditLog = null;
        try {
            ReferenceableHandler handler = instanceHandler.getReferenceableHandler(userId, serverName, "getMoreInformation");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMoreInformation");
            response.setList(handler.getMoreInformation(userId, elementGUID, elementStart, maxElements, "getMoreInformation"));
            response.setStartingFromElement(elementStart);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getMoreInformation", auditLog);
        }
        log.debug("Returning from method: getMoreInformation for server " + serverName + " with response: " + response.toString());
        return response;
    }

    public RelatedMediaReferencesResponse getRelatedMediaReferences(String serverName, String serviceURLName, String userId, String assetGUID, int elementStart, int maxElements) {
        String methodName = "getRelatedMediaReferences";
        log.debug("Calling method: getRelatedMediaReferences for server " + serverName);
        RelatedMediaReferencesResponse response = new RelatedMediaReferencesResponse();
        AuditLog auditLog = null;
        try {
            RelatedMediaHandler handler = instanceHandler.getRelatedMediaHandler(userId, serverName, "getRelatedMediaReferences");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRelatedMediaReferences");
            response.setList(handler.getRelatedMedia(userId, assetGUID, elementStart, maxElements, "getRelatedMediaReferences"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getRelatedMediaReferences", auditLog);
        }
        log.debug("Returning from method: getRelatedMediaReferences for server " + serverName + " with response: " + response.toString());
        return response;
    }

    public SchemaAttributesResponse getSchemaAttributes(String serverName, String serviceURLName, String userId, String schemaTypeGUID, int elementStart, int maxElements) {
        String methodName = "getSchemaAttributes";
        log.debug("Calling method: getSchemaAttributes for server " + serverName);
        SchemaAttributesResponse response = new SchemaAttributesResponse();
        AuditLog auditLog = null;
        try {
            SchemaTypeHandler handler = instanceHandler.getSchemaTypeHandler(userId, serverName, "getSchemaAttributes");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSchemaAttributes");
            response.setList(handler.getSchemaAttributes(userId, schemaTypeGUID, elementStart, maxElements, "getSchemaAttributes"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getSchemaAttributes", auditLog);
        }
        log.debug("Returning from method: getSchemaAttributes for server " + serverName + " with response: " + response.toString());
        return response;
    }
}

