/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.server.converters;

import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.OCFConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Rating;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.StarRating;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class RatingConverter<B>
extends OCFConverter<B> {
    public RatingConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.newInstance();
            if (returnBean instanceof Rating) {
                Rating bean = (Rating)returnBean;
                this.setUpElementHeader((ElementHeader)bean, entity, "Rating", methodName);
                InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                bean.setStarRating(this.removeStarRatingFromProperties(instanceProperties));
                bean.setReview(this.removeReview(instanceProperties));
                bean.setUser(entity.getCreatedBy());
                if (relationship != null) {
                    instanceProperties = new InstanceProperties(relationship.getProperties());
                    bean.setIsPublic(this.getIsPublic(instanceProperties));
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private StarRating removeStarRatingFromProperties(InstanceProperties properties) {
        StarRating starRating = this.getStarRatingFromProperties(properties);
        if (properties != null) {
            Map instancePropertiesMap = properties.getInstanceProperties();
            if (instancePropertiesMap != null) {
                instancePropertiesMap.remove("stars");
            }
            properties.setInstanceProperties(instancePropertiesMap);
        }
        return starRating;
    }

    private StarRating getStarRatingFromProperties(InstanceProperties properties) {
        InstancePropertyValue instancePropertyValue;
        Map instancePropertiesMap;
        StarRating starRating = StarRating.NO_RECOMMENDATION;
        if (properties != null && (instancePropertiesMap = properties.getInstanceProperties()) != null && (instancePropertyValue = (InstancePropertyValue)instancePropertiesMap.get("ownerType")) instanceof EnumPropertyValue) {
            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            switch (enumPropertyValue.getOrdinal()) {
                case 0: {
                    starRating = StarRating.NO_RECOMMENDATION;
                    break;
                }
                case 1: {
                    starRating = StarRating.ONE_STAR;
                    break;
                }
                case 2: {
                    starRating = StarRating.TWO_STARS;
                    break;
                }
                case 3: {
                    starRating = StarRating.THREE_STARS;
                    break;
                }
                case 4: {
                    starRating = StarRating.FOUR_STARS;
                    break;
                }
                case 99: {
                    starRating = StarRating.FIVE_STARS;
                }
            }
        }
        return starRating;
    }
}

