/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.server.converters;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.generichandlers.OCFConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttribute;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttributeRelationship;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SchemaAttributeConverter<B>
extends OCFConverter<B> {
    public SchemaAttributeConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public <T> B getNewSchemaAttributeBean(Class<B> beanClass, EntityDetail schemaAttributeEntity, Class<T> typeClass, T schemaType, List<Relationship> schemaAttributeRelationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.newInstance();
            if (returnBean instanceof SchemaAttribute) {
                SchemaAttribute bean = (SchemaAttribute)returnBean;
                this.setUpElementHeader((ElementHeader)bean, schemaAttributeEntity, "SchemaAttribute", methodName);
                InstanceProperties instanceProperties = new InstanceProperties(schemaAttributeEntity.getProperties());
                bean.setQualifiedName(this.removeQualifiedName(instanceProperties));
                bean.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                bean.setDisplayName(this.removeDisplayName(instanceProperties));
                bean.setDescription(this.removeDescription(instanceProperties));
                bean.setIsDeprecated(this.removeIsDeprecated(instanceProperties));
                bean.setAnchorGUID(this.removeAnchorGUID(instanceProperties));
                bean.setElementPosition(this.removePosition(instanceProperties));
                bean.setMinCardinality(this.removeMinCardinality(instanceProperties));
                bean.setMaxCardinality(this.removeMaxCardinality(instanceProperties));
                bean.setAllowsDuplicateValues(this.removeAllowsDuplicateValues(instanceProperties));
                bean.setOrderedValues(this.removeOrderedValues(instanceProperties));
                bean.setDefaultValueOverride(this.removeDefaultValueOverride(instanceProperties));
                bean.setMinimumLength(this.removeMinimumLength(instanceProperties));
                bean.setLength(this.removeLength(instanceProperties));
                bean.setPrecision(this.removePrecision(instanceProperties));
                bean.setIsNullable(this.removeIsNullable(instanceProperties));
                bean.setNativeJavaClass(this.removeNativeClass(instanceProperties));
                bean.setAliases(this.removeAliases(instanceProperties));
                bean.setSortOrder(this.removeSortOrder(instanceProperties));
                instanceProperties = super.getClassificationProperties("Anchors", schemaAttributeEntity);
                bean.setAnchorGUID(this.getAnchorGUID(instanceProperties));
                instanceProperties = super.getClassificationProperties("CalculatedValue", schemaAttributeEntity);
                bean.setCalculatedValue(instanceProperties != null);
                bean.setExpression(this.getFormula(instanceProperties));
                bean.setAttributeType((SchemaType)schemaType);
                bean.setAttributeRelationships(this.getSchemaAttributeRelationships(schemaAttributeEntity.getGUID(), schemaAttributeRelationships));
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private List<SchemaAttributeRelationship> getSchemaAttributeRelationships(String schemaAttributeGUID, List<Relationship> relationships) {
        ArrayList<SchemaAttributeRelationship> schemaAttributeRelationships = new ArrayList<SchemaAttributeRelationship>();
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (relationship == null || relationship.getType() == null) continue;
                SchemaAttributeRelationship schemaAttributeRelationship = new SchemaAttributeRelationship();
                schemaAttributeRelationship.setLinkType(relationship.getType().getTypeDefName());
                schemaAttributeRelationship.setLinkedAttributeName(this.repositoryHelper.getOtherEndName(this.serviceName, schemaAttributeGUID, relationship));
                EntityProxy otherEnd = relationship.getEntityOneProxy();
                if (otherEnd != null && schemaAttributeGUID.equals(otherEnd.getGUID())) {
                    otherEnd = relationship.getEntityTwoProxy();
                }
                if (otherEnd != null) {
                    schemaAttributeGUID = otherEnd.getGUID();
                }
                schemaAttributeRelationship.setLinkProperties(this.repositoryHelper.getInstancePropertiesAsMap(relationship.getProperties()));
                schemaAttributeRelationships.add(schemaAttributeRelationship);
            }
        }
        if (schemaAttributeRelationships.isEmpty()) {
            return null;
        }
        return schemaAttributeRelationships;
    }
}

