/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.server.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.OCFConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Asset;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class AssetConverter<B>
extends OCFConverter<B> {
    public AssetConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof Asset) {
                Asset bean = (Asset)returnBean;
                this.setUpElementHeader((ElementHeader)bean, entity, "Asset", methodName);
                InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                bean.setQualifiedName(this.removeQualifiedName(instanceProperties));
                bean.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                bean.setDisplayName(this.removeName(instanceProperties));
                bean.setDescription(this.removeDescription(instanceProperties));
                bean.setOwner(this.removeOwner(instanceProperties));
                bean.setOwnerType(this.removeOwnerTypeFromProperties(instanceProperties));
                bean.setZoneMembership(this.removeZoneMembership(instanceProperties));
                bean.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                instanceProperties = super.getClassificationProperties("AssetZoneMembership", entity);
                bean.setZoneMembership(this.getZoneMembership(instanceProperties));
                instanceProperties = super.getClassificationProperties("AssetOwnership", entity);
                bean.setOwner(this.getOwner(instanceProperties));
                bean.setOwnerType(this.getOwnerTypeFromProperties(instanceProperties));
                instanceProperties = super.getClassificationProperties("AssetOrigin", entity);
                HashMap<String, String> originMap = this.getOtherOriginValues(instanceProperties);
                String orgOriginValue = this.getOriginOrganizationGUID(instanceProperties);
                String bizOriginValue = this.getOriginBusinessCapabilityGUID(instanceProperties);
                if (orgOriginValue != null || bizOriginValue != null) {
                    if (originMap == null) {
                        originMap = new HashMap<String, String>();
                    }
                    if (orgOriginValue != null) {
                        originMap.put("organization", orgOriginValue);
                    }
                    if (bizOriginValue != null) {
                        originMap.put("businessCapability", bizOriginValue);
                    }
                }
                bean.setOrigin((Map)originMap);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, methodName);
    }
}

